/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.core.osgi.utils.BundleDelegatingClassLoader;
import org.apache.camel.impl.DefaultPackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiPackageScanClassResolver
extends DefaultPackageScanClassResolver {
    private Bundle bundle;

    public OsgiPackageScanClassResolver(Bundle bundle) {
        this.bundle = bundle;
    }

    public OsgiPackageScanClassResolver(BundleContext context) {
        this.bundle = context.getBundle();
    }

    public Set<ClassLoader> getClassLoaders() {
        return Collections.singleton(new BundleDelegatingClassLoader(this.bundle));
    }

    public void find(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        packageName = packageName.replace('.', '/');
        this.loadImplementationsInBundle(test, packageName, classes);
    }

    private void loadImplementationsInBundle(PackageScanFilter test, String packageName, Set<Class<?>> classes) {
        Set<String> urls = this.getImplementationsInBundle(test, packageName);
        if (urls != null) {
            for (String url : urls) {
                this.addIfMatching(test, url, classes);
            }
        }
    }

    private Set<String> getImplementationsInBundle(PackageScanFilter test, String packageName) {
        try {
            Bundle[] bundles = this.bundle.getBundleContext() != null ? this.bundle.getBundleContext().getBundles() : new Bundle[]{this.bundle};
            HashSet<String> urls = new HashSet<String>();
            for (Bundle bd : bundles) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Searching in bundle:" + bd));
                }
                Enumeration paths = bd.findEntries("/" + packageName, "*.class", true);
                while (paths != null && paths.hasMoreElements()) {
                    URL path = (URL)paths.nextElement();
                    String pathString = path.getPath();
                    String urlString = pathString.substring(pathString.indexOf(packageName));
                    urls.add(urlString);
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)("Added url: " + urlString));
                }
            }
            return urls;
        }
        catch (Throwable t) {
            this.log.error((Object)("Could not search osgi bundles for classes matching criteria: " + test + "due to an Exception: " + t.getMessage()));
            return null;
        }
    }
}

