/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.util.ServiceHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelProducerTemplateFactoryBean
extends IdentifiedType
implements CamelContextAware {
    @XmlTransient
    private ProducerTemplate template;
    @XmlAttribute(required=false)
    private String defaultEndpoint;
    @XmlAttribute
    private String camelContextId;
    @XmlTransient
    private CamelContext camelContext;
    @XmlAttribute
    private Integer maximumCacheSize;

    public void afterPropertiesSet() throws Exception {
        if (this.camelContext == null && this.camelContextId != null) {
            this.camelContext = this.getCamelContextWithId(this.camelContextId);
        }
        if (this.camelContext == null) {
            throw new IllegalArgumentException("A CamelContext or a CamelContextId must be injected!");
        }
    }

    protected abstract CamelContext getCamelContextWithId(String var1);

    public Object getObject() throws Exception {
        CamelContext context = this.getCamelContext();
        if (this.defaultEndpoint != null) {
            Endpoint endpoint = context.getEndpoint(this.defaultEndpoint);
            if (endpoint == null) {
                throw new IllegalArgumentException("No endpoint found for URI: " + this.defaultEndpoint);
            }
            this.template = new DefaultProducerTemplate(context, endpoint);
        } else {
            this.template = new DefaultProducerTemplate(context);
        }
        if (this.maximumCacheSize != null) {
            this.template.setMaximumCacheSize(this.maximumCacheSize.intValue());
        }
        ServiceHelper.startService((Object)this.template);
        return this.template;
    }

    public Class getObjectType() {
        return DefaultProducerTemplate.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        ServiceHelper.stopService((Object)this.template);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public String getCamelContextId() {
        return this.camelContextId;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }

    public Integer getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(Integer maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }
}

