/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;

public class Callback {
    protected Method m_methodObj;
    private String m_method;
    private boolean m_isStatic;
    private InstanceManager m_manager;
    private String[] m_args;

    public Callback(String method, String[] args, boolean isStatic, InstanceManager manager) {
        this.m_method = method;
        this.m_isStatic = isStatic;
        this.m_manager = manager;
        if (args != null) {
            this.computeArguments(args);
        } else {
            this.m_args = new String[0];
        }
    }

    public Callback(String method, Class[] args, boolean isStatic, InstanceManager manager) {
        this.m_method = method;
        this.m_isStatic = isStatic;
        this.m_manager = manager;
        this.m_args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.m_args[i] = args[i].getName();
        }
    }

    public Callback(MethodMetadata method, InstanceManager manager) {
        this.m_isStatic = false;
        this.m_method = method.getMethodName();
        this.m_manager = manager;
        this.computeArguments(method.getMethodArguments());
    }

    private void computeArguments(String[] args) {
        this.m_args = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.m_args[i] = FieldMetadata.getReflectionType(args[i]);
        }
    }

    private Method searchMethodInMethodArray(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            int argIndex;
            Class<?>[] clazzes;
            if (!methods[i].getName().equals(this.m_method) || (clazzes = methods[i].getParameterTypes()).length != this.m_args.length) continue;
            for (argIndex = 0; argIndex < this.m_args.length && this.m_args[argIndex].equals(clazzes[argIndex].getName()); ++argIndex) {
            }
            if (argIndex != this.m_args.length) continue;
            return methods[i];
        }
        return null;
    }

    protected void searchMethod() throws NoSuchMethodException {
        Method[] methods = this.m_manager.getClazz().getDeclaredMethods();
        this.m_methodObj = this.searchMethodInMethodArray(methods);
        if (this.m_methodObj == null) {
            methods = this.m_manager.getClazz().getMethods();
            this.m_methodObj = this.searchMethodInMethodArray(methods);
        }
        if (this.m_methodObj == null) {
            throw new NoSuchMethodException(this.m_method);
        }
        if (!this.m_methodObj.isAccessible()) {
            this.m_methodObj.setAccessible(true);
        }
    }

    public Object call() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.call(new Object[0]);
    }

    public Object call(Object instance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.call(instance, new Object[0]);
    }

    public Object call(Object[] arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        if (this.m_isStatic) {
            return this.m_methodObj.invoke(null, arg);
        }
        if (this.m_manager.getPojoObjects() == null) {
            return this.m_methodObj.invoke(this.m_manager.getPojoObject(), arg);
        }
        Object newObject = null;
        for (int i = 0; i < this.m_manager.getPojoObjects().length; ++i) {
            newObject = this.m_methodObj.invoke(this.m_manager.getPojoObjects()[i], arg);
        }
        return newObject;
    }

    public Object call(Object instance, Object[] arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.m_methodObj == null) {
            this.searchMethod();
        }
        return this.m_methodObj.invoke(instance, arg);
    }

    public String getMethod() {
        return this.m_method;
    }

    public String[] getArguments() {
        return this.m_args;
    }
}

