/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.audit;

import java.util.Vector;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.ConfigurationRepository;
import org.ow2.easybeans.api.EZBJ2EEManagedObject;
import org.ow2.easybeans.api.audit.EZBAuditComponent;
import org.ow2.easybeans.api.event.EZBEventListener;
import org.ow2.easybeans.component.api.EZBComponentException;
import org.ow2.easybeans.component.audit.Auditor;
import org.ow2.easybeans.component.audit.jmx.JMXNotifier;
import org.ow2.easybeans.component.audit.report.InvocationAuditReportFactory;
import org.ow2.easybeans.component.audit.rmi.interceptor.jrmp.Initializer;
import org.ow2.easybeans.component.itf.EZBEventComponent;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.CurrentInvocationID;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class AuditComponent
implements EZBAuditComponent {
    private JMXNotifier jmxNotifier;
    private EZBEventComponent eventComponent;
    private Vector<EZBJ2EEManagedObject> auditedObjects;
    private static Log logger = LogFactory.getLog(AuditComponent.class);
    private InvocationAuditReportFactory invocationAuditReportFactory = new InvocationAuditReportFactory();
    private ICurrentInvocationID currentInvocationID = CurrentInvocationID.getInstance();

    public void init() throws EZBComponentException {
        this.jmxNotifier = new JMXNotifier();
        this.auditedObjects = new Vector();
    }

    public void start() throws EZBComponentException {
        try {
            ConfigurationRepository.addInterceptors((String)"jrmp", Initializer.class);
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Cannot add JRMP interceptor", new Object[]{e});
        }
        logger.info((Object)"Audit component started.", new Object[0]);
    }

    public void stop() throws EZBComponentException {
        try {
            ConfigurationRepository.removeInterceptors((String)"jrmp", Initializer.class);
        }
        catch (ConfigurationException e) {
            logger.error((Object)"Cannot delete JRMP interceptor", new Object[]{e});
        }
        for (EZBJ2EEManagedObject object : this.auditedObjects) {
            this.unregisterJ2EEManagedObject(object);
        }
        this.auditedObjects.clear();
        logger.info((Object)"Audit component stopped.", new Object[0]);
    }

    public synchronized void setEventComponent(EZBEventComponent eventComponent) {
        this.eventComponent = eventComponent;
    }

    public void registerJ2EEManagedObject(EZBJ2EEManagedObject object) {
        logger.debug((Object)("Audit on " + object.getJ2EEManagedObjectId()), new Object[0]);
        if (this.auditedObjects.contains(object)) {
            this.unregisterJ2EEManagedObject(object);
        }
        this.auditedObjects.add(object);
        this.eventComponent.registerEventListener((EZBEventListener)new Auditor(object.getJ2EEManagedObjectId(), this.jmxNotifier, this.invocationAuditReportFactory));
    }

    public void unregisterJ2EEManagedObject(EZBJ2EEManagedObject object) {
        logger.debug((Object)(object.getJ2EEManagedObjectId() + " not audited anymore"), new Object[0]);
        if (this.auditedObjects.contains(object)) {
            this.auditedObjects.remove(object);
            this.eventComponent.unregisterEventListener((EZBEventListener)new Auditor(object.getJ2EEManagedObjectId(), this.jmxNotifier, this.invocationAuditReportFactory));
        }
    }

    public ICurrentInvocationID getCurrentInvocationID() {
        return this.currentInvocationID;
    }
}

