/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.DISCARD_PAYLOAD;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UNICAST_OOB_Test
extends TestCase {
    JChannel ch1;
    JChannel ch2;
    final String props = "udp.xml";

    public UNICAST_OOB_Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel("udp.xml");
        this.ch2 = new JChannel("udp.xml");
    }

    public void tearDown() throws Exception {
        if (this.ch1 != null) {
            this.ch1.close();
        }
        if (this.ch2 != null) {
            this.ch2.close();
        }
        super.tearDown();
    }

    public void testRegularMessages() throws Exception {
        this.sendMessages(false);
    }

    public void testOutOfBandMessages() throws Exception {
        this.sendMessages(true);
    }

    private void sendMessages(boolean oob) throws Exception {
        Long[] longArray;
        DISCARD_PAYLOAD prot1 = new DISCARD_PAYLOAD();
        MyReceiver receiver = new MyReceiver();
        this.ch2.setReceiver(receiver);
        this.ch2.getProtocolStack().insertProtocol((Protocol)prot1, 2, "UNICAST");
        this.ch1.connect("x");
        this.ch2.connect("x");
        UNICAST_OOB_Test.assertEquals((int)2, (int)this.ch2.getView().getMembers().size());
        Address dest = this.ch2.getLocalAddress();
        for (int i = 1; i <= 5; ++i) {
            Message msg = new Message(dest, null, new Long(i));
            if (i == 4 && oob) {
                msg.setFlag((byte)1);
            }
            System.out.println("-- sending message #" + i);
            this.ch1.send(msg);
            Util.sleep(100L);
        }
        Util.sleep(5000L);
        List seqnos = receiver.getSeqnos();
        System.out.println("sequence numbers: " + seqnos);
        if (oob) {
            Long[] longArray2 = new Long[5];
            longArray2[0] = new Long(1L);
            longArray2[1] = new Long(2L);
            longArray2[2] = new Long(4L);
            longArray2[3] = new Long(3L);
            longArray = longArray2;
            longArray2[4] = new Long(5L);
        } else {
            Long[] longArray3 = new Long[5];
            longArray3[0] = new Long(1L);
            longArray3[1] = new Long(2L);
            longArray3[2] = new Long(3L);
            longArray3[3] = new Long(4L);
            longArray = longArray3;
            longArray3[4] = new Long(5L);
        }
        Long[] expected_seqnos = longArray;
        for (int i = 0; i < expected_seqnos.length; ++i) {
            Long expected_seqno = expected_seqnos[i];
            Long received_seqno = (Long)seqnos.get(i);
            UNICAST_OOB_Test.assertEquals((Object)expected_seqno, (Object)received_seqno);
        }
    }

    public static Test suite() {
        return new TestSuite(UNICAST_OOB_Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)UNICAST_OOB_Test.suite());
    }

    public static class MyReceiver
    extends ReceiverAdapter {
        List seqnos = new LinkedList();

        public List getSeqnos() {
            return this.seqnos;
        }

        public void receive(Message msg) {
            if (msg != null) {
                Long num = (Long)msg.getObject();
                this.seqnos.add(num);
            }
        }
    }
}

