/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RouteDefinitionHelper {
    private RouteDefinitionHelper() {
    }

    public static void initParent(RouteDefinition route) {
        for (ProcessorDefinition output : route.getOutputs()) {
            output.setParent(route);
            if (output.getOutputs() == null) continue;
            RouteDefinitionHelper.initParent(output);
        }
    }

    public static void initParent(ProcessorDefinition parent) {
        List<ProcessorDefinition> children = parent.getOutputs();
        for (ProcessorDefinition child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null) continue;
            RouteDefinitionHelper.initParent(child);
        }
    }

    public static void prepareRouteForInit(RouteDefinition route, List<ProcessorDefinition> abstracts, List<ProcessorDefinition> lower) {
        for (ProcessorDefinition output : route.getOutputs()) {
            if (output.isAbstract()) {
                abstracts.add(output);
                continue;
            }
            lower.add(output);
        }
    }
}

