/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.Traceable;

public class Delayer
extends DelayProcessorSupport
implements Traceable {
    private Expression delay;
    private long delayValue;

    public Delayer(Processor processor, Expression delay, ScheduledExecutorService executorService) {
        super(processor, executorService);
        this.delay = delay;
    }

    public String toString() {
        return "Delayer[" + this.delay + " to: " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "delay[" + this.delay + "]";
    }

    public Expression getDelay() {
        return this.delay;
    }

    public long getDelayValue() {
        return this.delayValue;
    }

    public void setDelay(Expression delay) {
        this.delay = delay;
    }

    protected long calculateDelay(Exchange exchange) {
        long time = 0L;
        if (this.delay != null) {
            Long longValue = this.delay.evaluate(exchange, Long.class);
            if (longValue != null) {
                this.delayValue = longValue;
                time = longValue;
            } else {
                this.delayValue = 0L;
            }
        }
        if (time <= 0L) {
            return 0L;
        }
        return time;
    }
}

