/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.expressions.BaseExpression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.ReportQuery;

public class FunctionExpression
extends BaseExpression {
    protected Vector children = NonSynchronizedVector.newInstance(2);
    protected ExpressionOperator operator;
    protected transient ExpressionOperator platformOperator;
    protected Class resultType = null;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FunctionExpression expression = (FunctionExpression)object;
        if (!(this.operator == expression.getOperator() || this.operator != null && this.operator.equals(expression.getOperator()))) {
            return false;
        }
        Vector children = this.getChildren();
        Vector otherChildren = expression.getChildren();
        int size = children.size();
        if (size != otherChildren.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (children.get(index).equals(otherChildren.get(index))) continue;
            return false;
        }
        return true;
    }

    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.operator != null) {
            hashCode += this.operator.hashCode();
        }
        Vector children = this.getChildren();
        int size = children.size();
        for (int index = 0; index < size; ++index) {
            hashCode += children.get(index).hashCode();
        }
        return hashCode;
    }

    public void addChild(Expression child) {
        this.getChildren().addElement(child);
    }

    public DatabaseTable aliasForTable(DatabaseTable table) {
        return this.getBaseExpression().aliasForTable(table);
    }

    public Expression asOf(AsOfClause clause) {
        final AsOfClause finalClause = clause;
        ExpressionIterator iterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (each.isDataExpression()) {
                    each.asOf(finalClause);
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        iterator.iterateOn(this);
        return this;
    }

    public Expression create(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        this.addChild(base);
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        Expression arg = Expression.from(singleArgument, localBase);
        this.addChild(arg);
        this.setOperator(anOperator);
        return this;
    }

    public Expression createWithBaseLast(Expression base, Object singleArgument, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        Expression arg = Expression.from(singleArgument, localBase);
        this.addChild(arg);
        this.addChild(base);
        this.setOperator(anOperator);
        return this;
    }

    public Expression create(Expression base, Vector arguments, ExpressionOperator anOperator) {
        ExpressionBuilder builder;
        this.baseExpression = base;
        this.addChild(base);
        Expression localBase = base;
        if (anOperator.isFunctionOperator() && (builder = this.getBuilder()) != null) {
            localBase = builder;
        }
        Enumeration e = arguments.elements();
        while (e.hasMoreElements()) {
            Expression arg = Expression.from(e.nextElement(), localBase);
            this.addChild(arg);
        }
        this.setOperator(anOperator);
        return this;
    }

    public String descriptionOfNodeType() {
        return "Function";
    }

    public boolean doesConform(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        int selector = this.operator.getSelector();
        if (selector == 3) {
            return !this.getBaseExpression().doesConform(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        }
        if (selector == 15 || selector == 16 || selector == 13 || selector == 14 || selector == 11 || selector == 12) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            int size = this.children.size();
            Vector rightValue = new Vector(size);
            for (int index = 1; index < size; ++index) {
                Object child = this.children.get(index);
                Object valueFromRight = child instanceof Expression ? ((Expression)child).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered) : child;
                if (valueFromRight instanceof Vector) {
                    rightValue = (Vector)valueFromRight;
                    continue;
                }
                rightValue.add(valueFromRight);
            }
            if (leftValue instanceof Vector) {
                for (Object tempLeft : (Vector)leftValue) {
                    if (!this.operator.doesRelationConform(tempLeft, rightValue)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.doesRelationConform(leftValue, rightValue);
        }
        if (selector == 17 || selector == 18) {
            Object leftValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
            if (leftValue instanceof Vector) {
                for (Object tempLeft : (Vector)leftValue) {
                    if (!this.operator.doesRelationConform(tempLeft, null)) continue;
                    return true;
                }
                return false;
            }
            return this.operator.doesRelationConform(leftValue, null);
        }
        throw QueryException.cannotConformExpression();
    }

    public Vector getChildren() {
        return this.children;
    }

    public Vector getFields() {
        return this.getBaseExpression().getFields();
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public ExpressionOperator getPlatformOperator(DatabasePlatform platform) {
        if (this.platformOperator == null) {
            this.initializePlatformOperator(platform);
        }
        return this.platformOperator;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public boolean hasResultType() {
        return this.resultType != null;
    }

    public void initializePlatformOperator(DatabasePlatform platform) {
        if (this.operator.isComplete()) {
            this.platformOperator = this.operator;
            return;
        }
        this.platformOperator = platform.getOperator(this.operator.getSelector());
        if (this.platformOperator == null) {
            throw QueryException.invalidOperator(this.operator.toString());
        }
    }

    public boolean isFunctionExpression() {
        return true;
    }

    protected boolean isObjectComparison() {
        if (this.children.size() != 1) {
            return false;
        }
        int selector = this.operator.getSelector();
        if (selector != 17 && selector != 18) {
            return false;
        }
        Expression base = this.getBaseExpression();
        return base.isObjectExpression() && !((ObjectExpression)base).isAttribute();
    }

    public void iterateOn(ExpressionIterator iterator) {
        super.iterateOn(iterator);
        Enumeration childrenEnum = this.children.elements();
        while (childrenEnum.hasMoreElements()) {
            Expression child = (Expression)childrenEnum.nextElement();
            child.iterateOn(iterator);
        }
    }

    public Expression normalize(ExpressionNormalizer normalizer) {
        this.validateNode();
        if (this.children.isEmpty()) {
            return this;
        }
        ExpressionBuilder builder = this.getBuilder();
        if (builder != null && builder.getSession() == null) {
            builder.setSession(normalizer.getSession().getRootSession(null));
        }
        if (this.operator.getSelector() == 19 && this.getBaseExpression().isObjectExpression() && !((ObjectExpression)this.getBaseExpression()).isAttribute()) {
            this.prepareObjectAttributeCount(normalizer);
        }
        if (!this.isObjectComparison()) {
            for (int index = 0; index < this.children.size(); ++index) {
                this.children.setElementAt(((Expression)this.children.elementAt(index)).normalize(normalizer), index);
            }
            return this;
        }
        for (int index = 0; index < this.children.size(); ++index) {
            ((Expression)this.children.elementAt(index)).validateNode();
        }
        ObjectExpression base = (ObjectExpression)this.getBaseExpression();
        base.getBaseExpression().normalize(normalizer);
        Expression foreignKeyJoin = base.getMapping().buildObjectJoinExpression((Expression)base, (Object)null, this.getSession());
        if (this.operator.getSelector() == 18) {
            foreignKeyJoin = foreignKeyJoin.not();
        }
        return foreignKeyJoin.normalize(normalizer);
    }

    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        Vector oldChildren = this.children;
        this.children = NonSynchronizedVector.newInstance();
        for (int i = 0; i < oldChildren.size(); ++i) {
            this.addChild(((Expression)oldChildren.elementAt(i)).copiedVersionFrom(alreadyDone));
        }
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions() && !this.children.isEmpty()) {
            boolean allParams = true;
            for (Expression child : this.children) {
                if (child.isParameterExpression() || child.isConstantExpression()) continue;
                allParams = false;
            }
            if (allParams) {
                printer.getCall().setUsesBinding(false);
            }
        }
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printCollection(this.children, printer);
    }

    public void printJava(ExpressionJavaPrinter printer) {
        ExpressionOperator realOperator = this.getPlatformOperator(printer.getPlatform());
        realOperator.printJavaCollection(this.children, printer);
    }

    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.children.size());
        for (int i = 1; i < this.children.size(); ++i) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(i)).rebuildOn(newBase));
        }
        newLocalBase.setSelectIfOrderedBy(this.getBaseExpression().selectIfOrderedBy());
        FunctionExpression rebuilt = (FunctionExpression)newLocalBase.performOperator(this.operator, newChildren);
        rebuilt.setResultType(this.getResultType());
        return rebuilt;
    }

    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
        this.getBaseExpression().resetPlaceHolderBuilder(queryBuilder);
        for (int i = this.children.size() - 1; i > 0; --i) {
            ((Expression)this.children.elementAt(i)).resetPlaceHolderBuilder(queryBuilder);
        }
    }

    public void setLocalBase(Expression exp) {
        this.getBaseExpression().setLocalBase(exp);
    }

    public void setOperator(ExpressionOperator theOperator) {
        this.operator = theOperator;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    public Expression twistedForBaseAndContext(Expression newBase, Expression context) {
        if (this.children.isEmpty()) {
            return (Expression)this.clone();
        }
        NonSynchronizedVector newChildren = NonSynchronizedVector.newInstance(this.children.size());
        for (int index = 1; index < this.children.size(); ++index) {
            ((Vector)newChildren).addElement(((Expression)this.children.elementAt(index)).twistedForBaseAndContext(newBase, context));
        }
        Expression oldBase = (Expression)this.children.elementAt(0);
        return oldBase.twistedForBaseAndContext(newBase, context).performOperator(this.operator, newChildren);
    }

    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        Object baseValue = this.getBaseExpression().valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
        NonSynchronizedVector arguments = NonSynchronizedVector.newInstance(this.children.size());
        for (int index = 1; index < this.children.size(); ++index) {
            if (this.children.elementAt(index) instanceof Expression) {
                ((Vector)arguments).addElement(((Expression)this.children.elementAt(index)).valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered));
                continue;
            }
            ((Vector)arguments).addElement(this.children.elementAt(index));
        }
        if (baseValue instanceof Vector) {
            Vector<Object> baseVector = new Vector<Object>();
            Enumeration valuesToCompare = ((Vector)baseValue).elements();
            while (valuesToCompare.hasMoreElements()) {
                Object baseObject = valuesToCompare.nextElement();
                if (baseObject == null) {
                    baseVector.addElement(baseObject);
                    continue;
                }
                baseVector.addElement(this.operator.applyFunction(baseObject, arguments));
            }
            return baseVector;
        }
        if (baseValue == null) {
            return null;
        }
        return this.operator.applyFunction(baseValue, arguments);
    }

    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.operator.toString());
    }

    public void writeFields(ExpressionSQLPrinter printer, Vector newFields, SQLSelectStatement statement) {
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        if (this.getBaseExpression().isDataExpression()) {
            DatabaseField field = ((DataExpression)this.getBaseExpression()).getField();
            field = field == null ? new DatabaseField("*") : field.clone();
            field.setSqlType(Integer.MIN_VALUE);
            if (this.hasResultType()) {
                field.setType(this.getResultType());
            } else {
                int selector = this.operator.getSelector();
                if (selector != 22 && selector != 23) {
                    field.setType(null);
                }
            }
            newFields.addElement(field);
        } else {
            DatabaseField field = new DatabaseField("*");
            field.setSqlType(Integer.MIN_VALUE);
            field.setType(this.getResultType());
            newFields.addElement(field);
        }
        this.printSQL(printer);
    }

    public void writeSubexpressionsTo(BufferedWriter writer, int indent) throws IOException {
        if (this.baseExpression != null) {
            this.baseExpression.toString(writer, indent);
        }
    }

    private void prepareObjectAttributeCount(ExpressionNormalizer normalizer) {
        Expression baseExp = this.getBaseExpression();
        boolean distinctUsed = false;
        if (baseExp.isFunctionExpression() && ((FunctionExpression)baseExp).getOperator().getSelector() == 87) {
            distinctUsed = true;
            baseExp = ((FunctionExpression)baseExp).getBaseExpression();
        }
        boolean outerJoin = false;
        ClassDescriptor newDescriptor = null;
        if (baseExp.isQueryKeyExpression()) {
            DatabaseMapping mapping = this.getLeafMappingFor(baseExp, ((QueryKeyExpression)baseExp).descriptor);
            if (mapping != null && !mapping.isDirectToFieldMapping()) {
                outerJoin = ((QueryKeyExpression)baseExp).shouldUseOuterJoin();
                if (mapping.isAggregateMapping()) {
                    newDescriptor = mapping.getDescriptor();
                    baseExp = ((QueryKeyExpression)baseExp).getBaseExpression();
                } else {
                    newDescriptor = mapping.getReferenceDescriptor();
                }
            }
        } else if (baseExp.isExpressionBuilder()) {
            newDescriptor = normalizer.getSession().getDescriptor(((ExpressionBuilder)baseExp).getQueryClass());
        }
        if (newDescriptor != null) {
            DatabaseMapping pk;
            if (newDescriptor.hasSimplePrimaryKey() && newDescriptor.getPrimaryKeyFields().size() == 1) {
                pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                Expression countArg = baseExp.get(pk.getAttributeName());
                if (distinctUsed) {
                    countArg = countArg.distinct();
                }
                this.setBaseExpression(countArg);
                this.children.setElementAt(countArg, 0);
            } else if (!distinctUsed) {
                pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                Expression countArg = baseExp.get(pk.getAttributeName());
                while (pk.isAggregateObjectMapping()) {
                    newDescriptor = ((AggregateObjectMapping)pk).getReferenceDescriptor();
                    pk = this.getMappingOfFirstPrimaryKey(newDescriptor);
                    countArg = countArg.get(pk.getAttributeName());
                }
                this.setBaseExpression(countArg);
                this.children.setElementAt(countArg, 0);
            } else if (!outerJoin) {
                ExpressionBuilder countBuilder = baseExp.getBuilder();
                ExpressionBuilder outerBuilder = new ExpressionBuilder();
                ReportQuery subSelect = new ReportQuery(newDescriptor.getJavaClass(), countBuilder);
                subSelect.setShouldRetrieveFirstPrimaryKey(true);
                subSelect.setSelectionCriteria(baseExp.equal(outerBuilder));
                SubSelectExpression sub = new SubSelectExpression(subSelect, ((BaseExpression)baseExp).getBaseExpression());
                this.setBaseExpression(outerBuilder);
                this.children.setElementAt(outerBuilder, 0);
            } else {
                throw new UnsupportedOperationException("COMPOSIT PK WITH DISTINCT OUTER");
            }
        }
    }

    protected DatabaseMapping getLeafMappingFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression == null || expression.isFieldExpression()) {
            return null;
        }
        if (!expression.isQueryKeyExpression()) {
            return null;
        }
        if (expression.isMapEntryExpression()) {
            MapEntryExpression teExpression = (MapEntryExpression)expression;
            QueryKeyExpression baseExpression = (QueryKeyExpression)teExpression.getBaseExpression();
            Expression owningExpression = baseExpression.getBaseExpression();
            ClassDescriptor owningDescriptor = this.getLeafDescriptorFor(owningExpression, rootDescriptor);
            CollectionMapping mapping = (CollectionMapping)owningDescriptor.getObjectBuilder().getMappingForAttributeName(baseExpression.getName());
            if (teExpression.shouldReturnMapEntry()) {
                return mapping;
            }
            if (mapping.getContainerPolicy().isMappedKeyMapPolicy()) {
                MappedKeyMapContainerPolicy policy = (MappedKeyMapContainerPolicy)mapping.getContainerPolicy();
                return (DatabaseMapping)((Object)policy.getKeyMapping());
            }
            return mapping;
        }
        QueryKeyExpression qkExpression = (QueryKeyExpression)expression;
        Expression baseExpression = qkExpression.getBaseExpression();
        ClassDescriptor descriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        return descriptor.getObjectBuilder().getMappingForAttributeName(qkExpression.getName());
    }

    protected ClassDescriptor getLeafDescriptorFor(Expression expression, ClassDescriptor rootDescriptor) throws QueryException {
        if (expression.isExpressionBuilder()) {
            Class queryClass = ((ExpressionBuilder)expression).getQueryClass();
            return this.getSession().getDescriptor(queryClass);
        }
        Expression baseExpression = ((QueryKeyExpression)expression).getBaseExpression();
        ClassDescriptor baseDescriptor = this.getLeafDescriptorFor(baseExpression, rootDescriptor);
        ClassDescriptor descriptor = null;
        String attributeName = expression.getName();
        DatabaseMapping mapping = baseDescriptor.getObjectBuilder().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            QueryKey queryKey = baseDescriptor.getQueryKeyNamed(attributeName);
            if (queryKey != null) {
                descriptor = queryKey.isForeignReferenceQueryKey() ? this.getSession().getDescriptor(((ForeignReferenceQueryKey)queryKey).getReferenceClass()) : queryKey.getDescriptor();
            }
            if (descriptor == null) {
                throw QueryException.invalidQueryKeyInExpression(attributeName);
            }
        } else if (mapping.isAggregateObjectMapping()) {
            descriptor = ((AggregateObjectMapping)mapping).getReferenceDescriptor();
        } else if (mapping.isForeignReferenceMapping()) {
            descriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
        }
        return descriptor;
    }

    protected DatabaseMapping getMappingOfFirstPrimaryKey(ClassDescriptor descriptor) {
        if (descriptor != null) {
            for (DatabaseMapping m : descriptor.getMappings()) {
                if (!m.isPrimaryKeyMapping()) continue;
                return m;
            }
        }
        return null;
    }
}

