/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.jmx;

import fr.dyade.aaa.common.osgi.Activator;
import fr.dyade.aaa.util.management.MXServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.osgi.framework.ServiceRegistration;

public class JMXServer
implements MXServer {
    private MBeanServer mxserver = null;
    private Map registeredServices = new HashMap();
    public static boolean registerAsService = false;

    public JMXServer(MBeanServer mxserver) {
        this.mxserver = mxserver;
        MXWrapper.setMXServer(this);
    }

    public JMXServer() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            this.mxserver = (MBeanServer)method.invoke(null, (Object[])null);
        }
        catch (Exception exc) {
            this.mxserver = MBeanServerFactory.createMBeanServer("AgentServer");
        }
        MXWrapper.setMXServer(this);
    }

    private void registerOSGi(Object obj, ObjectName objName) {
        if (!registerAsService) {
            return;
        }
        Hashtable<String, String> registrationProperties = objName.getKeyPropertyList();
        registrationProperties.put("domain", objName.getDomain());
        if (this.registeredServices.containsKey(objName)) {
            ServiceRegistration registration = (ServiceRegistration)this.registeredServices.get(objName);
            registration.setProperties(registrationProperties);
            return;
        }
        HashSet serviceNames = new HashSet();
        this.computeOSGiServiceNames(obj.getClass(), obj, serviceNames);
        ServiceRegistration registration = Activator.context.registerService(serviceNames.toArray(new String[serviceNames.size()]), obj, registrationProperties);
        this.registeredServices.put(objName, registration);
    }

    private void computeOSGiServiceNames(Class beanClass, Object bean, Set registered) {
        if (beanClass == null) {
            return;
        }
        Class<?>[] interfaces = beanClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().endsWith("MBean") || registered.contains(interfaces[i].getName())) continue;
            registered.add(interfaces[i].getName());
            this.computeOSGiServiceNames(interfaces[i], bean, registered);
        }
        this.computeOSGiServiceNames(beanClass.getSuperclass(), bean, registered);
    }

    public String registerMBean(Object bean, String fullName) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        try {
            ObjectName objName = ObjectName.getInstance(fullName);
            this.mxserver.registerMBean(bean, objName);
            this.registerOSGi(bean, objName);
        }
        catch (InstanceAlreadyExistsException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (NotCompliantMBeanException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
        return fullName;
    }

    public void unregisterMBean(String fullName) throws Exception {
        if (this.mxserver == null) {
            return;
        }
        try {
            ServiceRegistration registration;
            ObjectName objName = ObjectName.getInstance(fullName);
            this.mxserver.unregisterMBean(objName);
            if (registerAsService && (registration = (ServiceRegistration)this.registeredServices.remove(objName)) != null) {
                registration.unregister();
            }
        }
        catch (InstanceNotFoundException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws Exception {
        if (this.mxserver != null) {
            this.mxserver.setAttribute(name, attribute);
        }
    }

    public Object getAttribute(ObjectName objectName, String attribute) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.getAttribute(objectName, attribute);
    }

    public MBeanAttributeInfo[] getAttributes(ObjectName objectName) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.getMBeanInfo(objectName).getAttributes();
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws Exception {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.setAttributes(name, attributes);
    }

    public Set queryNames(ObjectName objectName) {
        if (this.mxserver == null) {
            return null;
        }
        return this.mxserver.queryNames(objectName, null);
    }
}

