/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.admin;

import fr.dyade.aaa.common.stream.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.objectweb.joram.shared.admin.AdminReply;

public class GetRightsReply
extends AdminReply {
    private static final long serialVersionUID = 1L;
    private boolean isFreeReading;
    private boolean isFreeWriting;
    private Hashtable readers;
    private Hashtable writers;

    public GetRightsReply(boolean success, String info, boolean isFreeReading, boolean isFreeWriting) {
        super(success, info);
        this.isFreeReading = isFreeReading;
        this.isFreeWriting = isFreeWriting;
        this.readers = new Hashtable();
        this.writers = new Hashtable();
    }

    public boolean isFreeReading() {
        return this.isFreeReading;
    }

    public boolean isFreeWriting() {
        return this.isFreeWriting;
    }

    public void addReader(String name, String proxyId) {
        this.readers.put(name, proxyId);
    }

    public Hashtable getReaders() {
        return this.readers;
    }

    public void addWriter(String name, String proxyId) {
        this.writers.put(name, proxyId);
    }

    public Hashtable getWriters() {
        return this.writers;
    }

    public GetRightsReply() {
    }

    protected int getClassId() {
        return 46;
    }

    public void readFrom(InputStream is) throws IOException {
        String value;
        String key;
        int i;
        super.readFrom(is);
        this.isFreeReading = StreamUtil.readBooleanFrom((InputStream)is);
        this.isFreeWriting = StreamUtil.readBooleanFrom((InputStream)is);
        int size = StreamUtil.readIntFrom((InputStream)is);
        if (size <= 0) {
            this.readers = null;
        } else {
            this.readers = new Hashtable(size * 4 / 3);
            for (i = 0; i < size; ++i) {
                key = StreamUtil.readStringFrom((InputStream)is);
                value = StreamUtil.readStringFrom((InputStream)is);
                this.readers.put(key, value);
            }
        }
        size = StreamUtil.readIntFrom((InputStream)is);
        if (size <= 0) {
            this.writers = null;
        } else {
            this.writers = new Hashtable(size * 4 / 3);
            for (i = 0; i < size; ++i) {
                key = StreamUtil.readStringFrom((InputStream)is);
                value = StreamUtil.readStringFrom((InputStream)is);
                this.writers.put(key, value);
            }
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        String value;
        String key;
        Enumeration keys;
        int size;
        super.writeTo(os);
        StreamUtil.writeTo((boolean)this.isFreeReading, (OutputStream)os);
        StreamUtil.writeTo((boolean)this.isFreeWriting, (OutputStream)os);
        if (this.readers == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
        } else {
            size = this.readers.size();
            StreamUtil.writeTo((int)size, (OutputStream)os);
            keys = this.readers.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                StreamUtil.writeTo((String)key, (OutputStream)os);
                value = (String)this.readers.get(key);
                StreamUtil.writeTo((String)value, (OutputStream)os);
            }
        }
        if (this.writers == null) {
            StreamUtil.writeTo((int)-1, (OutputStream)os);
        } else {
            size = this.writers.size();
            StreamUtil.writeTo((int)size, (OutputStream)os);
            keys = this.writers.keys();
            while (keys.hasMoreElements()) {
                key = (String)keys.nextElement();
                StreamUtil.writeTo((String)key, (OutputStream)os);
                value = (String)this.writers.get(key);
                StreamUtil.writeTo((String)value, (OutputStream)os);
            }
        }
    }
}

