/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.util.Properties;
import org.objectweb.joram.mom.dest.DistributionModule;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.messages.ConversionHelper;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DistributionQueueImpl
extends QueueImpl {
    public static Logger logger = Debug.getLogger((String)DistributionQueueImpl.class.getName());
    private static final long serialVersionUID = 1L;
    private transient DistributionModule distributionModule;
    private Properties properties;

    public DistributionQueueImpl(AgentId adminId, Properties properties) throws RequestException {
        super(adminId, properties);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionQueueImpl.<init> prop = " + properties));
        }
        this.properties = (Properties)properties.clone();
        try {
            String className = ConversionHelper.toString((Object)properties.get("distribution.className"));
            Class.forName(className).getConstructor(new Class[0]);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.ERROR, (Object)"DistributionQueueImpl: error with distribution class.", (Throwable)exc);
            throw new RequestException(exc.getMessage());
        }
    }

    public void initialize(boolean firstTime) {
        super.initialize(firstTime);
        if (this.distributionModule == null) {
            try {
                this.distributionModule = new DistributionModule(this, (Properties)this.properties.clone());
            }
            catch (RequestException exc) {
                logger.log(BasicLevel.ERROR, (Object)("DistributionQueueImpl.initialize prop = " + this.properties), (Throwable)exc);
            }
        }
    }

    public ClientMessages preProcess(AgentId from, ClientMessages cm) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("DistributionQueueImpl. preProcess(" + from + ", " + (Object)((Object)cm) + ')'));
        }
        return this.distributionModule.processMessages(cm);
    }

    public String toString() {
        return "DistributionQueueImpl:" + this.getId().toString();
    }

    public void close() {
        if (this.distributionModule != null) {
            this.distributionModule.close();
        }
    }
}

