/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.Channel;
import fr.dyade.aaa.agent.DeleteNot;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.UnknownAgent;
import fr.dyade.aaa.agent.UnknownNotificationException;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.objectweb.joram.mom.dest.AdminTopic;
import org.objectweb.joram.mom.dest.AdminTopicImpl;
import org.objectweb.joram.mom.dest.Destination;
import org.objectweb.joram.mom.dest.Queue;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.dest.Topic;
import org.objectweb.joram.mom.notifications.AbortReceiveRequest;
import org.objectweb.joram.mom.notifications.AbstractReplyNot;
import org.objectweb.joram.mom.notifications.AbstractRequestNot;
import org.objectweb.joram.mom.notifications.AcknowledgeRequest;
import org.objectweb.joram.mom.notifications.AdminReplyNot;
import org.objectweb.joram.mom.notifications.BrowseReply;
import org.objectweb.joram.mom.notifications.BrowseRequest;
import org.objectweb.joram.mom.notifications.ClientMessages;
import org.objectweb.joram.mom.notifications.DenyRequest;
import org.objectweb.joram.mom.notifications.ExceptionReply;
import org.objectweb.joram.mom.notifications.FwdAdminRequestNot;
import org.objectweb.joram.mom.notifications.QueueMsgReply;
import org.objectweb.joram.mom.notifications.ReceiveRequest;
import org.objectweb.joram.mom.notifications.SubscribeReply;
import org.objectweb.joram.mom.notifications.SubscribeRequest;
import org.objectweb.joram.mom.notifications.TopicMsgsReply;
import org.objectweb.joram.mom.notifications.UnsubscribeRequest;
import org.objectweb.joram.mom.notifications.WakeUpNot;
import org.objectweb.joram.mom.proxies.ClientContext;
import org.objectweb.joram.mom.proxies.ClientSubscription;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.proxies.ProxyImplMBean;
import org.objectweb.joram.mom.proxies.RequestBuffer;
import org.objectweb.joram.mom.proxies.SendReplyNot;
import org.objectweb.joram.mom.proxies.SyncReply;
import org.objectweb.joram.mom.proxies.TopicSubscription;
import org.objectweb.joram.mom.proxies.Xid;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.DestinationConstants;
import org.objectweb.joram.shared.admin.AbstractAdminMessage;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetDMQSettingsReply;
import org.objectweb.joram.shared.admin.GetDMQSettingsRequest;
import org.objectweb.joram.shared.admin.GetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.GetNumberReply;
import org.objectweb.joram.shared.admin.GetSubscription;
import org.objectweb.joram.shared.admin.GetSubscriptionMessage;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIds;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageRep;
import org.objectweb.joram.shared.admin.GetSubscriptionRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.GetSubscriptionsRep;
import org.objectweb.joram.shared.admin.SetDMQRequest;
import org.objectweb.joram.shared.admin.SetNbMaxMsgRequest;
import org.objectweb.joram.shared.admin.SetThresholdRequest;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ActivateConsumerRequest;
import org.objectweb.joram.shared.client.CnxCloseReply;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.CnxConnectReply;
import org.objectweb.joram.shared.client.CnxConnectRequest;
import org.objectweb.joram.shared.client.CnxStartRequest;
import org.objectweb.joram.shared.client.CnxStopRequest;
import org.objectweb.joram.shared.client.CommitRequest;
import org.objectweb.joram.shared.client.ConsumerAckRequest;
import org.objectweb.joram.shared.client.ConsumerCloseSubRequest;
import org.objectweb.joram.shared.client.ConsumerDenyRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.ConsumerReceiveRequest;
import org.objectweb.joram.shared.client.ConsumerSetListRequest;
import org.objectweb.joram.shared.client.ConsumerSubRequest;
import org.objectweb.joram.shared.client.ConsumerUnsetListRequest;
import org.objectweb.joram.shared.client.ConsumerUnsubRequest;
import org.objectweb.joram.shared.client.GetAdminTopicReply;
import org.objectweb.joram.shared.client.GetAdminTopicRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.client.ProducerMessages;
import org.objectweb.joram.shared.client.QBrowseReply;
import org.objectweb.joram.shared.client.QBrowseRequest;
import org.objectweb.joram.shared.client.ServerReply;
import org.objectweb.joram.shared.client.SessAckRequest;
import org.objectweb.joram.shared.client.SessCreateDestReply;
import org.objectweb.joram.shared.client.SessCreateDestRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.joram.shared.client.TempDestDeleteRequest;
import org.objectweb.joram.shared.client.XACnxCommit;
import org.objectweb.joram.shared.client.XACnxPrepare;
import org.objectweb.joram.shared.client.XACnxRecoverReply;
import org.objectweb.joram.shared.client.XACnxRecoverRequest;
import org.objectweb.joram.shared.client.XACnxRollback;
import org.objectweb.joram.shared.excepts.AccessException;
import org.objectweb.joram.shared.excepts.DestinationException;
import org.objectweb.joram.shared.excepts.MomException;
import org.objectweb.joram.shared.excepts.RequestException;
import org.objectweb.joram.shared.excepts.StateException;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class ProxyImpl
implements Serializable,
ProxyImplMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)ProxyImpl.class.getName());
    protected long period = 60000L;
    protected long nbMsgsSentToDMQSinceCreation = 0L;
    private AgentId dmqId = null;
    private int threshold = -1;
    protected int nbMaxMsg = -1;
    private Map contexts = new Hashtable();
    private Map subsTable = new Hashtable();
    private Map recoveredTransactions;
    private long arrivalsCounter = 0L;
    private ProxyAgentItf proxyAgent;
    private transient Map topicsTable;
    private transient Map messagesTable;
    private transient int activeCtxId;
    private transient ClientContext activeCtx;
    transient String msgTxname = null;

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        if (this.period != period) {
            WakeUpNot not = new WakeUpNot();
            not.update = true;
            Channel.sendTo((AgentId)this.proxyAgent.getId(), (Notification)not);
            this.period = period;
        }
    }

    public String getDMQId() {
        if (this.dmqId != null) {
            return this.dmqId.toString();
        }
        return null;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.nbMaxMsg = nbMaxMsg;
    }

    public ProxyImpl(ProxyAgentItf proxyAgent) {
        this.proxyAgent = proxyAgent;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public String toString() {
        if (this.proxyAgent == null) {
            return "ProxyImpl:";
        }
        return "ProxyImpl:" + this.proxyAgent.getId();
    }

    public String getName() {
        return this.proxyAgent == null ? null : this.proxyAgent.getName();
    }

    public void initialize(boolean firstTime) throws Exception {
        AgentId destId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " (re)initializing..."));
        }
        this.topicsTable = new Hashtable();
        this.messagesTable = new Hashtable();
        this.setActiveCtxId(-1);
        Iterator ctxs = this.contexts.values().iterator();
        while (ctxs.hasNext()) {
            ClientContext activeCtx = (ClientContext)ctxs.next();
            ctxs.remove();
            Iterator queueIds = activeCtx.getDeliveringQueues();
            while (queueIds.hasNext()) {
                destId = (AgentId)queueIds.next();
                this.proxyAgent.sendNot(destId, new DenyRequest(activeCtx.getId()));
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Denies messages on queue " + destId.toString()));
            }
            Iterator xids = activeCtx.getTxIds();
            while (xids.hasNext()) {
                if (this.recoveredTransactions == null) {
                    this.recoveredTransactions = new Hashtable();
                }
                Xid xid = (Xid)xids.next();
                XACnxPrepare recoveredPrepare = (XACnxPrepare)this.recoveredTransactions.get(xid);
                XACnxPrepare prepare = activeCtx.getTxPrepare(xid);
                if (recoveredPrepare == null) {
                    this.recoveredTransactions.put(xid, prepare);
                    continue;
                }
                recoveredPrepare.getSendings().addAll(prepare.getSendings());
                recoveredPrepare.getAcks().addAll(prepare.getAcks());
            }
            Iterator tempDests = activeCtx.getTempDestinations();
            while (tempDests.hasNext()) {
                destId = (AgentId)tempDests.next();
                this.deleteTemporaryDestination(destId);
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)("Deletes temporary destination " + destId.toString()));
            }
        }
        Vector messages = org.objectweb.joram.mom.messages.Message.loadAll(this.getMsgTxname());
        if (this.subsTable.isEmpty()) {
            org.objectweb.joram.mom.messages.Message.deleteAll(this.getMsgTxname());
        }
        ArrayList<AgentId> topics = new ArrayList<AgentId>();
        Iterator subs = this.subsTable.entrySet().iterator();
        while (subs.hasNext()) {
            ClientSubscription cSub;
            Map.Entry subEntry;
            block17: {
                subEntry = subs.next();
                cSub = (ClientSubscription)subEntry.getValue();
                destId = cSub.getTopicId();
                if (!topics.contains(destId)) {
                    topics.add(destId);
                }
                if (!cSub.getDurable()) {
                    subs.remove();
                    try {
                        MXWrapper.unregisterMBean((String)this.getMBeanName((String)subEntry.getKey()));
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(BasicLevel.WARN)) continue;
                        logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                    }
                    continue;
                }
                cSub.setProxyAgent(this.proxyAgent);
                cSub.reinitialize(this.messagesTable, messages, true);
                try {
                    MXWrapper.registerMBean((Object)cSub, (String)this.getMBeanName((String)subEntry.getKey()));
                }
                catch (Exception e1) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block17;
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register ClientSubscriptionMbean", (Throwable)e1);
                }
            }
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(destId);
            if (tSub == null) {
                tSub = new TopicSubscription();
                this.topicsTable.put(destId, tSub);
            }
            tSub.putSubscription((String)subEntry.getKey(), cSub.getSelector());
        }
        Iterator topicIds = topics.iterator();
        while (topicIds.hasNext()) {
            this.updateSubscriptionToTopic((AgentId)topicIds.next(), -1, -1);
        }
    }

    private void setActiveCtxId(int activeCtxId) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.setActiveCtxId(" + activeCtxId + ')'));
        }
        this.activeCtxId = activeCtxId;
    }

    public void reactToClientRequest(int key, AbstractJmsRequest request) {
        try {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " got " + request.getClass().getName() + " with id: " + request.getRequestId() + " through activeCtx: " + key));
            }
            if (request instanceof ProducerMessages) {
                this.reactToClientRequest(key, (ProducerMessages)request);
            } else if (request instanceof ConsumerReceiveRequest) {
                this.reactToClientRequest(key, (ConsumerReceiveRequest)request);
            } else if (request instanceof ConsumerSetListRequest) {
                this.reactToClientRequest(key, (ConsumerSetListRequest)request);
            } else if (request instanceof QBrowseRequest) {
                this.reactToClientRequest(key, (QBrowseRequest)request);
            } else if (request instanceof JmsRequestGroup) {
                this.reactToClientRequest(key, (JmsRequestGroup)request);
            } else {
                this.doReact(key, request);
            }
        }
        catch (IllegalArgumentException iE) {
            DestinationException dE = new DestinationException("Incorrect destination identifier: " + iE);
            this.doReply(key, (AbstractJmsReply)new MomExceptionReply(request.getRequestId(), (MomException)dE));
        }
        catch (RequestException exc) {
            this.doReply(key, (AbstractJmsReply)new MomExceptionReply(request.getRequestId(), (MomException)((Object)exc)));
        }
    }

    private void reactToClientRequest(int key, ProducerMessages req) throws RequestException {
        AgentId destId;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.reactToClientRequest(" + key + ',' + req + ')'));
        }
        if ((destId = AgentId.fromString((String)req.getTarget())) == null) {
            throw new RequestException("Request to an undefined destination (null).");
        }
        ClientMessages not = new ClientMessages(key, req.getRequestId(), req.getMessages());
        this.setDmq(not);
        if (destId.getTo() == this.proxyAgent.getId().getTo()) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> local sending");
            }
            not.setPersistent(false);
            not.setExpiration(0L);
            if (req.getAsyncSend()) {
                not.setAsyncSend(true);
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> remote sending");
            }
            if (!req.getAsyncSend()) {
                this.proxyAgent.sendNot(this.proxyAgent.getId(), new SendReplyNot(key, req.getRequestId()));
            }
        }
        this.proxyAgent.sendNot(destId, not);
    }

    private void setDmq(ClientMessages not) {
        if (this.dmqId != null) {
            not.setDMQId(this.dmqId);
        } else {
            not.setDMQId(QueueImpl.getDefaultDMQId());
        }
    }

    private void reactToClientRequest(int key, ConsumerReceiveRequest req) throws RequestException {
        if (req.getQueueMode()) {
            ReceiveRequest not = new ReceiveRequest(key, req.getRequestId(), req.getSelector(), req.getTimeToLive(), req.getReceiveAck(), null, 1);
            AgentId destId = AgentId.fromString((String)req.getTarget());
            if (destId == null) {
                throw new RequestException("Request to an undefined destination (null).");
            }
            if (destId.getTo() == this.proxyAgent.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local receiving");
                }
                not.setPersistent(false);
                this.proxyAgent.sendNot(destId, not);
            } else {
                this.proxyAgent.sendNot(destId, not);
            }
        } else {
            this.doReact(key, (AbstractJmsRequest)req);
        }
    }

    private void reactToClientRequest(int key, ConsumerSetListRequest req) throws RequestException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImp.reactToClientRequest(" + key + ',' + req + ')'));
        }
        if (req.getQueueMode()) {
            ReceiveRequest not = new ReceiveRequest(key, req.getRequestId(), req.getSelector(), 0L, false, req.getMessageIdsToAck(), req.getMessageCount());
            AgentId destId = AgentId.fromString((String)req.getTarget());
            if (destId == null) {
                throw new RequestException("Request to an undefined destination (null).");
            }
            if (destId.getTo() == this.proxyAgent.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local sending");
                }
                not.setPersistent(false);
                this.proxyAgent.sendNot(destId, not);
            } else {
                this.proxyAgent.sendNot(destId, not);
            }
        } else {
            this.doReact(key, (AbstractJmsRequest)req);
        }
    }

    private void reactToClientRequest(int key, QBrowseRequest req) throws RequestException {
        AgentId destId = AgentId.fromString((String)req.getTarget());
        if (destId == null) {
            throw new RequestException("Request to an undefined destination (null).");
        }
        this.proxyAgent.sendNot(destId, new BrowseRequest(key, req.getRequestId(), req.getSelector()));
    }

    private void reactToClientRequest(int key, JmsRequestGroup request) {
        AbstractJmsRequest[] requests = request.getRequests();
        RequestBuffer rm = new RequestBuffer(this.proxyAgent);
        for (int i = 0; i < requests.length; ++i) {
            if (requests[i] instanceof ProducerMessages) {
                ProducerMessages pm = (ProducerMessages)requests[i];
                rm.put(key, pm);
                continue;
            }
            this.reactToClientRequest(key, requests[i]);
        }
        rm.flush();
    }

    public void react(AgentId from, Notification not) throws UnknownNotificationException {
        if (not instanceof SyncReply) {
            this.doReact((SyncReply)not);
        } else if (not instanceof AbstractReplyNot) {
            this.doFwd(from, (AbstractReplyNot)not);
        } else if (not instanceof AdminReplyNot) {
            this.doReact((AdminReplyNot)not);
        } else if (not instanceof UnknownAgent) {
            this.doReact((UnknownAgent)not);
        } else if (not instanceof FwdAdminRequestNot) {
            this.doReact((FwdAdminRequestNot)not);
        } else {
            throw new UnknownNotificationException("Unexpected notification: " + not.getClass().getName());
        }
    }

    private void doReact(int key, AbstractJmsRequest request) {
        try {
            if (!(request instanceof CnxConnectRequest)) {
                this.setCtx(key);
            }
            if (request instanceof GetAdminTopicRequest) {
                this.doReact(key, (GetAdminTopicRequest)request);
            } else if (request instanceof CnxConnectRequest) {
                this.doReact(key, (CnxConnectRequest)request);
            } else if (request instanceof CnxStartRequest) {
                this.doReact((CnxStartRequest)request);
            } else if (request instanceof CnxStopRequest) {
                this.doReact((CnxStopRequest)request);
            } else if (request instanceof SessCreateDestRequest) {
                this.doReact((SessCreateDestRequest)request);
            } else if (request instanceof ConsumerSubRequest) {
                this.doReact((ConsumerSubRequest)request);
            } else if (request instanceof ConsumerUnsubRequest) {
                this.doReact((ConsumerUnsubRequest)request);
            } else if (request instanceof ConsumerCloseSubRequest) {
                this.doReact((ConsumerCloseSubRequest)request);
            } else if (request instanceof ConsumerSetListRequest) {
                this.doReact((ConsumerSetListRequest)request);
            } else if (request instanceof ConsumerUnsetListRequest) {
                this.doReact((ConsumerUnsetListRequest)request);
            } else if (request instanceof ConsumerReceiveRequest) {
                this.doReact((ConsumerReceiveRequest)request);
            } else if (request instanceof ConsumerAckRequest) {
                this.doReact((ConsumerAckRequest)request);
            } else if (request instanceof ConsumerDenyRequest) {
                this.doReact((ConsumerDenyRequest)request);
            } else if (request instanceof SessAckRequest) {
                this.doReact((SessAckRequest)request);
            } else if (request instanceof SessDenyRequest) {
                this.doReact((SessDenyRequest)request);
            } else if (request instanceof TempDestDeleteRequest) {
                this.doReact((TempDestDeleteRequest)request);
            } else if (request instanceof XACnxPrepare) {
                this.doReact((XACnxPrepare)request);
            } else if (request instanceof XACnxCommit) {
                this.doReact((XACnxCommit)request);
            } else if (request instanceof XACnxRollback) {
                this.doReact((XACnxRollback)request);
            } else if (request instanceof XACnxRecoverRequest) {
                this.doReact((XACnxRecoverRequest)request);
            } else if (request instanceof CnxCloseRequest) {
                this.doReact(key, (CnxCloseRequest)request);
            } else if (request instanceof ActivateConsumerRequest) {
                this.doReact(key, (ActivateConsumerRequest)request);
            } else if (request instanceof CommitRequest) {
                this.doReact(key, (CommitRequest)request);
            }
        }
        catch (MomException mE) {
            logger.log(BasicLevel.ERROR, (Object)(this + " - error during request: " + request), (Throwable)mE);
            this.doReply((AbstractJmsReply)new MomExceptionReply(request.getRequestId(), mE));
        }
        catch (Exception exc) {
            logger.log(BasicLevel.FATAL, (Object)(this + " - unexpected error during request: " + request), (Throwable)exc);
            this.doReply((AbstractJmsReply)new MomExceptionReply(request.getRequestId(), new MomException(exc.getMessage())));
        }
    }

    private void doReact(int key, GetAdminTopicRequest req) throws AccessException {
        this.doReply(key, (AbstractJmsReply)new GetAdminTopicReply(req, AdminTopic.getDefault().toString()));
    }

    private void doReact(int key, CnxConnectRequest req) throws DestinationException {
        this.proxyAgent.setSave();
        this.setActiveCtxId(key);
        this.activeCtx = new ClientContext(this.proxyAgent.getId(), key);
        this.activeCtx.setProxyAgent(this.proxyAgent);
        this.contexts.put(new Integer(key), this.activeCtx);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Connection " + key + " opened."));
        }
        this.doReply((AbstractJmsReply)new CnxConnectReply(req, key, this.proxyAgent.getId().toString()));
    }

    private void doReact(CnxStartRequest req) {
        this.activeCtx.setActivated(true);
        Iterator deliveries = this.activeCtx.getPendingDeliveries();
        while (deliveries.hasNext()) {
            this.doReply((AbstractJmsReply)deliveries.next());
        }
        this.activeCtx.clearPendingDeliveries();
    }

    private void doReact(CnxStopRequest req) {
        this.activeCtx.setActivated(false);
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(SessCreateDestRequest req) throws RequestException {
        AgentId destId = null;
        AdminTopicImpl.DestinationDesc desc = AdminTopicImpl.lookupDest(req.getName(), req.getType());
        if (desc == null) {
            Destination dest = null;
            if (DestinationConstants.isQueue((byte)req.getType())) {
                dest = new Queue();
            } else if (DestinationConstants.isTopic((byte)req.getType())) {
                dest = new Topic();
            } else {
                throw new RequestException("Could not create destination, unknown type:" + req.getType());
            }
            dest.setName(req.getName());
            dest.init(this.proxyAgent.getId(), null);
            dest.setFreeWriting(true);
            if (!DestinationConstants.isTemporary((byte)req.getType())) {
                dest.setFreeReading(true);
            }
            destId = dest.getId();
            try {
                dest.deploy();
            }
            catch (IOException exc) {
                throw new RequestException("Could not create destination:" + exc.getMessage());
            }
            AdminTopicImpl.registerDest(destId, req.getName() == null ? destId.toString() : req.getName(), req.getType());
            if (DestinationConstants.isTemporary((byte)req.getType())) {
                this.activeCtx.addTemporaryDestination(destId);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl, new destination created: " + destId));
            }
        } else {
            destId = desc.getId();
        }
        SessCreateDestReply reply = new SessCreateDestReply((AbstractJmsRequest)req, destId.toString());
        this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)reply));
    }

    private void doReact(ConsumerSubRequest req) throws StateException, RequestException {
        TopicSubscription tSub;
        AgentId topicId = AgentId.fromString((String)req.getTarget());
        String subName = req.getSubName();
        if (topicId == null) {
            throw new RequestException("Cannot subscribe to an undefined topic (null).");
        }
        if (subName == null) {
            throw new RequestException("Unauthorized null subscription name.");
        }
        boolean newTopic = !this.topicsTable.containsKey(topicId);
        boolean newSub = !this.subsTable.containsKey(subName);
        boolean sent = false;
        if (newTopic) {
            tSub = new TopicSubscription();
            this.topicsTable.put(topicId, tSub);
        } else {
            tSub = (TopicSubscription)this.topicsTable.get(topicId);
        }
        if (newSub) {
            block14: {
                this.proxyAgent.setSave();
                ClientSubscription cSub = new ClientSubscription(this.proxyAgent.getId(), this.activeCtxId, req.getRequestId(), req.getDurable(), topicId, req.getSubName(), req.getSelector(), req.getNoLocal(), this.dmqId, this.threshold, this.nbMaxMsg, this.messagesTable);
                cSub.setProxyAgent(this.proxyAgent);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Subscription " + subName + " created."));
                }
                this.subsTable.put(subName, cSub);
                try {
                    MXWrapper.registerMBean((Object)cSub, (String)this.getMBeanName(subName));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block14;
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register ClientSubscriptionMbean", (Throwable)e);
                }
            }
            tSub.putSubscription(subName, req.getSelector());
            sent = this.updateSubscriptionToTopic(topicId, this.activeCtxId, req.getRequestId(), req.isAsyncSubscription());
        } else {
            boolean updatedTopic;
            ClientSubscription cSub = (ClientSubscription)this.subsTable.get(subName);
            if (cSub.getActive()) {
                throw new StateException("The durable subscription " + subName + " has already been activated.");
            }
            boolean bl = updatedTopic = !topicId.equals((Object)cSub.getTopicId());
            if (updatedTopic) {
                TopicSubscription oldTSub = (TopicSubscription)this.topicsTable.get(cSub.getTopicId());
                oldTSub.removeSubscription(subName);
                this.updateSubscriptionToTopic(cSub.getTopicId(), -1, -1, req.isAsyncSubscription());
            }
            boolean updatedSelector = req.getSelector() == null && cSub.getSelector() != null ? true : (req.getSelector() != null && cSub.getSelector() == null ? true : (req.getSelector() == null && cSub.getSelector() == null ? false : !req.getSelector().equals(cSub.getSelector())));
            cSub.reactivate(this.activeCtxId, req.getRequestId(), topicId, req.getSelector(), req.getNoLocal());
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Subscription " + subName + " reactivated."));
            }
            if (updatedTopic || updatedSelector) {
                tSub.putSubscription(subName, req.getSelector());
                sent = this.updateSubscriptionToTopic(topicId, this.activeCtxId, req.getRequestId(), req.isAsyncSubscription());
            }
        }
        this.activeCtx.addSubName(subName);
        if (!sent) {
            this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
        }
    }

    private void doReact(ConsumerSetListRequest req) throws DestinationException {
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't set a listener on the non existing subscription: " + subName);
        }
        sub.setListener(req.getRequestId());
        ConsumerMessages consM = sub.deliver();
        if (consM != null) {
            if (this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(ConsumerUnsetListRequest req) throws DestinationException {
        if (req.getQueueMode()) {
            this.activeCtx.cancelReceive(req.getCancelledRequestId());
            AgentId to = AgentId.fromString((String)req.getTarget());
            this.proxyAgent.sendNot(to, new AbortReceiveRequest(this.activeCtx.getId(), req.getRequestId(), req.getCancelledRequestId()));
        }
    }

    private void doReact(ConsumerCloseSubRequest req) throws DestinationException {
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't desactivate non existing subscription: " + subName);
        }
        this.activeCtx.removeSubName(subName);
        sub.deactivate();
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(ConsumerUnsubRequest req) throws DestinationException {
        block5: {
            this.proxyAgent.setSave();
            String subName = req.getTarget();
            ClientSubscription sub = null;
            if (subName != null) {
                sub = (ClientSubscription)this.subsTable.get(subName);
            }
            if (sub == null) {
                throw new DestinationException("Can't unsubscribe non existing subscription: " + subName);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("Deleting subscription " + subName));
            }
            AgentId topicId = sub.getTopicId();
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(topicId);
            tSub.removeSubscription(subName);
            this.updateSubscriptionToTopic(topicId, -1, -1);
            sub.delete();
            this.activeCtx.removeSubName(subName);
            this.subsTable.remove(subName);
            try {
                MXWrapper.unregisterMBean((String)this.getMBeanName(subName));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block5;
                logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
            }
        }
        this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void doReact(ConsumerReceiveRequest req) throws DestinationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.doReact(" + req + ')'));
        }
        String subName = req.getTarget();
        ClientSubscription sub = null;
        if (subName != null) {
            sub = (ClientSubscription)this.subsTable.get(subName);
        }
        if (sub == null) {
            throw new DestinationException("Can't request a message from the unknown subscription: " + subName);
        }
        sub.setReceiver(req.getRequestId(), req.getTimeToLive());
        ConsumerMessages consM = sub.deliver();
        if (consM != null && req.getReceiveAck()) {
            Vector messageList = consM.getMessages();
            for (int i = 0; i < messageList.size(); ++i) {
                org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)messageList.elementAt(i);
                sub.acknowledge(msg.getIdentifier());
            }
        }
        if (consM == null && req.getTimeToLive() == -1L) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> immediate delivery");
            }
            sub.unsetReceiver();
            consM = new ConsumerMessages(req.getRequestId(), subName, false);
        }
        if (consM != null && this.activeCtx.getActivated()) {
            this.doReply((AbstractJmsReply)consM);
        } else if (consM != null) {
            this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
        }
    }

    private void doReact(SessAckRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            Vector ids = req.getIds();
            AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), ids);
            if (qId.getTo() == this.proxyAgent.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local acking");
                }
                not.setPersistent(false);
            }
            this.proxyAgent.sendNot(qId, not);
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub != null) {
                sub.acknowledge(req.getIds().iterator());
            }
        }
    }

    private void doReact(SessDenyRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            Vector ids = req.getIds();
            this.proxyAgent.sendNot(qId, new DenyRequest(this.activeCtxId, req.getRequestId(), ids));
            if (!req.getDoNotAck()) {
                this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) {
                return;
            }
            sub.deny(req.getIds().iterator());
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else if (consM != null) {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(ConsumerAckRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), req.getIds());
            if (qId.getTo() == this.proxyAgent.getId().getTo()) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> local acking");
                }
                not.setPersistent(false);
                this.proxyAgent.sendNot(qId, not);
            } else {
                this.proxyAgent.sendNot(qId, not);
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub != null) {
                sub.acknowledge(req.getIds().iterator());
            }
        }
    }

    private void doReact(ConsumerDenyRequest req) {
        if (req.getQueueMode()) {
            AgentId qId = AgentId.fromString((String)req.getTarget());
            String id = req.getId();
            this.proxyAgent.sendNot(qId, new DenyRequest(this.activeCtxId, req.getRequestId(), id));
            if (!req.getDoNotAck()) {
                this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
            }
        } else {
            String subName = req.getTarget();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) {
                return;
            }
            Vector<String> ids = new Vector<String>();
            ids.add(req.getId());
            sub.deny(ids.iterator());
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
            } else if (consM != null) {
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
        }
    }

    private void doReact(TempDestDeleteRequest req) {
        AgentId tempId = AgentId.fromString((String)req.getTarget());
        this.activeCtx.removeTemporaryDestination(tempId);
        this.deleteTemporaryDestination(tempId);
        this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void deleteTemporaryDestination(AgentId destId) {
        this.proxyAgent.sendNot(destId, (Notification)new DeleteNot());
        AdminTopicImpl.unregisterDest(destId.toString());
    }

    private void doReact(XACnxPrepare req) throws StateException {
        try {
            Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
            this.activeCtx.registerTxPrepare(xid, req);
            this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
        }
        catch (Exception exc) {
            throw new StateException(exc.getMessage());
        }
    }

    private void doReact(XACnxCommit req) throws StateException {
        Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
        XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
        if (prepare == null) {
            throw new StateException("Unknown transaction identifier.");
        }
        Vector sendings = prepare.getSendings();
        Vector acks = prepare.getAcks();
        while (!sendings.isEmpty()) {
            ProducerMessages pM = (ProducerMessages)sendings.remove(0);
            ClientMessages not = new ClientMessages(this.activeCtxId, pM.getRequestId(), pM.getMessages());
            this.proxyAgent.sendNot(AgentId.fromString((String)pM.getTarget()), not);
        }
        while (!acks.isEmpty()) {
            this.doReact((SessAckRequest)acks.remove(0));
        }
        this.doReply((AbstractJmsReply)new ServerReply((AbstractJmsRequest)req));
    }

    private void doReact(XACnxRollback req) {
        Xid xid = new Xid(req.getBQ(), req.getFI(), req.getGTI());
        Enumeration queues = req.getQueues();
        while (queues.hasMoreElements()) {
            String queueName = (String)queues.nextElement();
            AgentId qId = AgentId.fromString((String)queueName);
            Vector ids = req.getQueueIds(queueName);
            this.proxyAgent.sendNot(qId, new DenyRequest(this.activeCtxId, req.getRequestId(), ids));
        }
        Enumeration subs = req.getSubs();
        while (subs.hasMoreElements()) {
            String subName = (String)subs.nextElement();
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) continue;
            sub.deny(req.getSubIds(subName).iterator());
            ConsumerMessages consM = sub.deliver();
            if (consM != null && this.activeCtx.getActivated()) {
                this.doReply((AbstractJmsReply)consM);
                continue;
            }
            if (consM == null) continue;
            this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
        }
        XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
        if (prepare != null) {
            Vector acks = prepare.getAcks();
            while (!acks.isEmpty()) {
                SessAckRequest ack = (SessAckRequest)acks.remove(0);
                this.doReact(new SessDenyRequest(ack.getTarget(), ack.getIds(), ack.getQueueMode(), true));
            }
        }
        this.proxyAgent.sendNot(this.proxyAgent.getId(), new SyncReply(this.activeCtxId, (AbstractJmsReply)new ServerReply((AbstractJmsRequest)req)));
    }

    private void doReact(XACnxRecoverRequest req) throws StateException {
        this.proxyAgent.setSave();
        Vector<byte[]> bqs = new Vector<byte[]>();
        Vector<Integer> fis = new Vector<Integer>();
        Vector<byte[]> gtis = new Vector<byte[]>();
        if (this.recoveredTransactions != null) {
            Iterator txs = this.recoveredTransactions.entrySet().iterator();
            while (txs.hasNext()) {
                Map.Entry txEntry = txs.next();
                Xid xid = (Xid)txEntry.getKey();
                bqs.add(xid.bq);
                fis.add(new Integer(xid.fi));
                gtis.add(xid.gti);
                try {
                    txs.remove();
                    this.activeCtx.registerTxPrepare(xid, (XACnxPrepare)txEntry.getValue());
                }
                catch (Exception exc) {
                    throw new StateException("Recovered transaction branch has already been prepared by the RM.");
                }
            }
        }
        this.recoveredTransactions = null;
        this.doReply((AbstractJmsReply)new XACnxRecoverReply(req, bqs, fis, gtis));
    }

    private void doReact(SyncReply not) {
        this.doReply(not.key, not.reply);
    }

    private void doReact(int key, CnxCloseRequest req) {
        this.proxyAgent.setSave();
        boolean prepared = false;
        Iterator ids = this.activeCtx.getDeliveringQueues();
        while (ids.hasNext()) {
            AgentId id = (AgentId)ids.next();
            Iterator xids = this.activeCtx.getTxIds();
            while (xids.hasNext()) {
                Xid xid = (Xid)xids.next();
                if (!this.activeCtx.isPrepared(xid)) continue;
                prepared = true;
                break;
            }
            if (!prepared) {
                this.proxyAgent.sendNot(id, new DenyRequest(key));
            }
            prepared = false;
        }
        String subName = null;
        Vector<AgentId> topics = new Vector<AgentId>();
        Iterator subs = this.activeCtx.getActiveSubs();
        while (subs.hasNext()) {
            ClientSubscription sub;
            block15: {
                subName = (String)subs.next();
                sub = (ClientSubscription)this.subsTable.get(subName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Deactivate subscription " + subName + ", topic id = " + sub.getTopicId()));
                }
                if (sub.getDurable()) {
                    sub.deactivate();
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("Durable subscription" + subName + " de-activated."));
                    continue;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable = " + this.topicsTable));
                }
                sub.delete();
                this.subsTable.remove(subName);
                try {
                    MXWrapper.unregisterMBean((String)this.getMBeanName(subName));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block15;
                    logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
                }
            }
            TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(sub.getTopicId());
            tSub.removeSubscription(subName);
            if (!topics.contains(sub.getTopicId())) {
                topics.add(sub.getTopicId());
            }
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Temporary subscription" + subName + " deleted."));
        }
        Iterator topicIds = topics.iterator();
        while (topicIds.hasNext()) {
            this.updateSubscriptionToTopic((AgentId)topicIds.next(), -1, -1);
        }
        Iterator dests = this.activeCtx.getTempDestinations();
        while (dests.hasNext()) {
            AgentId destId = (AgentId)dests.next();
            this.activeCtx.removeTemporaryDestination(destId);
            this.deleteTemporaryDestination(destId);
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("Deletes temporary destination " + destId.toString()));
        }
        Iterator xids = this.activeCtx.getTxIds();
        while (xids.hasNext()) {
            if (this.recoveredTransactions == null) {
                this.recoveredTransactions = new Hashtable();
            }
            Xid xid = (Xid)xids.next();
            XACnxPrepare recoveredPrepare = (XACnxPrepare)this.recoveredTransactions.get(xid);
            XACnxPrepare prepare = this.activeCtx.getTxPrepare(xid);
            if (recoveredPrepare == null) {
                this.recoveredTransactions.put(xid, prepare);
                continue;
            }
            recoveredPrepare.getSendings().addAll(prepare.getSendings());
            recoveredPrepare.getAcks().addAll(prepare.getAcks());
        }
        this.contexts.remove(new Integer(key));
        this.activeCtx = null;
        this.setActiveCtxId(-1);
        CnxCloseReply reply = new CnxCloseReply();
        reply.setCorrelationId(req.getRequestId());
        this.proxyAgent.sendToClient(key, (AbstractJmsReply)reply);
    }

    private void doReact(int key, ActivateConsumerRequest req) {
        String subName = req.getTarget();
        ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
        sub.setActive(req.getActivate());
    }

    private void doReact(int key, CommitRequest req) {
        Enumeration acks;
        int asyncReplyCount = 0;
        Enumeration pms = req.getProducerMessages();
        if (pms != null) {
            while (pms.hasMoreElements()) {
                ProducerMessages pm = (ProducerMessages)pms.nextElement();
                AgentId destId = AgentId.fromString((String)pm.getTarget());
                ClientMessages not = new ClientMessages(key, req.getRequestId(), pm.getMessages());
                this.setDmq(not);
                if (destId.getTo() == this.proxyAgent.getId().getTo()) {
                    not.setPersistent(false);
                    if (req.getAsyncSend()) {
                        not.setAsyncSend(true);
                    } else {
                        ++asyncReplyCount;
                    }
                }
                this.proxyAgent.sendNot(destId, not);
            }
        }
        if ((acks = req.getAckRequests()) != null) {
            while (acks.hasMoreElements()) {
                SessAckRequest sar = (SessAckRequest)acks.nextElement();
                if (sar.getQueueMode()) {
                    AgentId qId = AgentId.fromString((String)sar.getTarget());
                    Vector ids = sar.getIds();
                    AcknowledgeRequest not = new AcknowledgeRequest(this.activeCtxId, req.getRequestId(), ids);
                    if (qId.getTo() == this.proxyAgent.getId().getTo()) {
                        not.setPersistent(false);
                    }
                    this.proxyAgent.sendNot(qId, not);
                    continue;
                }
                String subName = sar.getTarget();
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub == null) continue;
                sub.acknowledge(sar.getIds().iterator());
                this.proxyAgent.setSave();
            }
        }
        if (!req.getAsyncSend()) {
            if (asyncReplyCount == 0) {
                this.proxyAgent.sendNot(this.proxyAgent.getId(), new SendReplyNot(key, req.getRequestId()));
            } else {
                this.activeCtx.addMultiReplyContext(req.getRequestId(), asyncReplyCount);
            }
        }
    }

    private void doFwd(AgentId from, AbstractReplyNot rep) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " got " + ((Object)((Object)rep)).getClass().getName() + " with id: " + rep.getCorrelationId() + " from: " + from));
        }
        if (rep instanceof QueueMsgReply) {
            this.doFwd(from, (QueueMsgReply)rep);
        } else if (rep instanceof BrowseReply) {
            this.doFwd((BrowseReply)rep);
        } else if (rep instanceof SubscribeReply) {
            this.doFwd((SubscribeReply)rep);
        } else if (rep instanceof TopicMsgsReply) {
            this.doFwd(from, (TopicMsgsReply)rep);
        } else if (rep instanceof ExceptionReply) {
            this.doReact(from, (ExceptionReply)rep);
        } else if (logger.isLoggable(BasicLevel.ERROR)) {
            logger.log(BasicLevel.ERROR, (Object)("Unexpected reply: " + (Object)((Object)rep)));
        }
    }

    private void doFwd(AgentId from, QueueMsgReply rep) {
        block18: {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.doFwd(" + from + ',' + (Object)((Object)rep) + ')'));
            }
            try {
                this.setCtx(rep.getClientContext());
                if (rep.getCorrelationId() == this.activeCtx.getCancelledReceive()) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)(" -> cancelled receive: id=" + this.activeCtx.getCancelledReceive()));
                    }
                    if (rep.getSize() > 0) {
                        Vector msgList = rep.getMessages();
                        for (int i = 0; i < msgList.size(); ++i) {
                            org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgList.elementAt(i));
                            String msgId = msg.getIdentifier();
                            if (logger.isLoggable(BasicLevel.INFO)) {
                                logger.log(BasicLevel.INFO, (Object)(" -> denying message: " + msgId));
                            }
                            this.proxyAgent.sendNot(from, new DenyRequest(0, rep.getCorrelationId(), msgId));
                        }
                    }
                } else {
                    ConsumerMessages jRep;
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> reply");
                    }
                    if (rep.getSize() > 0) {
                        jRep = new ConsumerMessages(rep.getCorrelationId(), rep.getMessages(), from.toString(), true);
                        this.activeCtx.addDeliveringQueue(from);
                    } else {
                        jRep = new ConsumerMessages(rep.getCorrelationId(), (Vector)null, from.toString(), true);
                    }
                    if (this.activeCtx.getActivated()) {
                        this.doReply((AbstractJmsReply)jRep);
                    } else {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)" -> buffer the reply");
                        }
                        this.activeCtx.addPendingDelivery((AbstractJmsReply)jRep);
                    }
                }
            }
            catch (StateException pE) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)pE);
                }
                if (rep.getMessages().size() <= 0) break block18;
                Vector msgList = rep.getMessages();
                for (int i = 0; i < msgList.size(); ++i) {
                    org.objectweb.joram.mom.messages.Message msg = new org.objectweb.joram.mom.messages.Message((Message)msgList.elementAt(i));
                    String msgId = msg.getIdentifier();
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("Denying message: " + msgId));
                    }
                    this.proxyAgent.sendNot(from, new DenyRequest(0, rep.getCorrelationId(), msgId));
                }
            }
        }
    }

    private void doFwd(BrowseReply rep) {
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new QBrowseReply(rep.getCorrelationId(), rep.getMessages()));
        }
        catch (StateException stateException) {
            // empty catch block
        }
    }

    private void doFwd(SubscribeReply rep) {
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new ServerReply(rep.getCorrelationId()));
        }
        catch (StateException stateException) {
            // empty catch block
        }
    }

    protected final String getMsgTxname() {
        if (this.msgTxname == null) {
            this.msgTxname = 'M' + this.proxyAgent.getId().toString() + '_';
        }
        return this.msgTxname;
    }

    protected final void setMsgTxName(org.objectweb.joram.mom.messages.Message msg) {
        if (msg.getTxName() == null) {
            msg.setTxName(this.getMsgTxname() + msg.order);
        }
    }

    private void doFwd(AgentId from, TopicMsgsReply rep) {
        ClientSubscription sub;
        String subName;
        TopicSubscription tSub = (TopicSubscription)this.topicsTable.get(from);
        if (tSub == null || tSub.isEmpty()) {
            return;
        }
        ArrayList<org.objectweb.joram.mom.messages.Message> messages = new ArrayList<org.objectweb.joram.mom.messages.Message>();
        Iterator msgs = rep.getMessages().iterator();
        while (msgs.hasNext()) {
            org.objectweb.joram.mom.messages.Message message = new org.objectweb.joram.mom.messages.Message((Message)msgs.next());
            ++this.arrivalsCounter;
            message.order = message.order;
            messages.add(message);
        }
        Iterator names = tSub.getNames();
        while (names.hasNext()) {
            subName = (String)names.next();
            sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null) continue;
            sub.browseNewMessages(messages);
        }
        for (org.objectweb.joram.mom.messages.Message message : messages) {
            if (message.durableAcksCounter <= 0) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> save message " + message));
            }
            this.proxyAgent.setSave();
            this.setMsgTxName(message);
            message.save();
            message.releaseFullMessage();
        }
        names = tSub.getNames();
        while (names.hasNext()) {
            ConsumerMessages consM;
            subName = (String)names.next();
            sub = (ClientSubscription)this.subsTable.get(subName);
            if (sub == null || !sub.getActive() || (consM = sub.deliver()) == null) continue;
            try {
                this.setCtx(sub.getContextId());
                if (this.activeCtx.getActivated()) {
                    this.doReply((AbstractJmsReply)consM);
                    continue;
                }
                this.activeCtx.addPendingDelivery((AbstractJmsReply)consM);
            }
            catch (StateException pE) {}
        }
    }

    private void doReact(AgentId from, ExceptionReply rep) {
        MomException exc;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.doReact(" + from + ',' + (Object)((Object)rep) + ')'));
        }
        if ((exc = rep.getException()) instanceof AccessException) {
            TopicSubscription tSub;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + from + ')'));
            }
            if ((tSub = (TopicSubscription)this.topicsTable.remove(from)) != null) {
                Iterator e = tSub.getNames();
                while (e.hasNext()) {
                    ClientSubscription sub;
                    String name;
                    block11: {
                        name = (String)e.next();
                        sub = (ClientSubscription)this.subsTable.remove(name);
                        try {
                            MXWrapper.unregisterMBean((String)this.getMBeanName(name));
                        }
                        catch (Exception e1) {
                            if (!logger.isLoggable(BasicLevel.WARN)) break block11;
                            logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                        }
                    }
                    sub.delete();
                    try {
                        this.setCtx(sub.getContextId());
                        this.activeCtx.removeSubName(name);
                        this.doReply((AbstractJmsReply)new MomExceptionReply(rep.getCorrelationId(), exc));
                    }
                    catch (StateException pExc) {}
                }
                return;
            }
        }
        try {
            this.setCtx(rep.getClientContext());
            this.doReply((AbstractJmsReply)new MomExceptionReply(rep.getCorrelationId(), exc));
        }
        catch (StateException pExc) {
            // empty catch block
        }
    }

    private String getMBeanName(String name) {
        return new StringBuffer().append(this.proxyAgent.getMBeanName()).append(",sub=").append(name).toString();
    }

    private void doReact(AdminReplyNot reply) {
    }

    private void doReact(UnknownAgent uA) {
        TopicSubscription tSub;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.doReact(" + uA + ')'));
        }
        Notification not = uA.not;
        AgentId agId = uA.agent;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("--- " + this + " notified of invalid destination: " + agId.toString()));
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + agId + ')'));
        }
        if ((tSub = (TopicSubscription)this.topicsTable.remove(agId)) != null) {
            DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
            Iterator e = tSub.getNames();
            while (e.hasNext()) {
                ClientSubscription sub;
                String name;
                block24: {
                    name = (String)e.next();
                    sub = (ClientSubscription)this.subsTable.remove(name);
                    try {
                        MXWrapper.unregisterMBean((String)this.getMBeanName(name));
                    }
                    catch (Exception e1) {
                        if (!logger.isLoggable(BasicLevel.WARN)) break block24;
                        logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e1);
                    }
                }
                sub.delete();
                try {
                    this.setCtx(sub.getContextId());
                    this.activeCtx.removeSubName(name);
                    this.doReply((AbstractJmsReply)new MomExceptionReply(sub.getSubRequestId(), (MomException)exc));
                }
                catch (StateException pExc) {}
            }
            return;
        }
        if (not instanceof AbstractRequestNot) {
            AbstractRequestNot req;
            block25: {
                req = (AbstractRequestNot)not;
                if (req instanceof ClientMessages) {
                    if (this.dmqId != null && agId.equals((Object)this.dmqId)) {
                        this.proxyAgent.setSave();
                        this.dmqId = null;
                        Iterator subs = this.subsTable.values().iterator();
                        while (subs.hasNext()) {
                            ((ClientSubscription)subs.next()).setDMQId(null);
                        }
                    }
                    if (QueueImpl.getDefaultDMQId() != null && !agId.equals((Object)QueueImpl.getDefaultDMQId())) {
                        DMQManager dmqManager = new DMQManager(this.dmqId, null);
                        for (Message msg : ((ClientMessages)req).getMessages()) {
                            ++this.nbMsgsSentToDMQSinceCreation;
                            dmqManager.addDeadMessage(msg, (short)4);
                        }
                        dmqManager.sendToDMQ();
                    }
                    DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
                    MomExceptionReply mer = new MomExceptionReply(req.getRequestId(), (MomException)exc);
                    try {
                        this.setCtx(req.getClientContext());
                        this.doReply((AbstractJmsReply)mer);
                    }
                    catch (StateException se) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)se);
                        }
                        break block25;
                    }
                }
                if (req instanceof ReceiveRequest) {
                    DestinationException exc = new DestinationException("Destination " + agId + " does not exist.");
                    MomExceptionReply mer = new MomExceptionReply(req.getRequestId(), (MomException)exc);
                    try {
                        this.setCtx(req.getClientContext());
                        if (this.activeCtx.getActivated()) {
                            this.doReply((AbstractJmsReply)mer);
                        } else {
                            this.activeCtx.addPendingDelivery((AbstractJmsReply)mer);
                        }
                    }
                    catch (StateException se) {
                        if (!logger.isLoggable(BasicLevel.DEBUG)) break block25;
                        logger.log(BasicLevel.DEBUG, (Object)"", (Throwable)se);
                    }
                }
            }
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("Connection " + req.getClientContext() + " notified of the deletion of destination " + agId));
            }
        }
    }

    private void doReact(FwdAdminRequestNot not) {
        AdminRequest adminRequest = not.getRequest();
        if (adminRequest instanceof GetSubscriptions) {
            this.doReact((GetSubscriptions)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptionMessageIds) {
            this.doReact((GetSubscriptionMessageIds)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscriptionMessage) {
            this.doReact((GetSubscriptionMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteSubscriptionMessage) {
            this.doReact((DeleteSubscriptionMessage)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetSubscription) {
            this.doReact((GetSubscription)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof ClearSubscription) {
            this.doReact((ClearSubscription)adminRequest, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetNbMaxMsgRequest) {
            GetNbMaxMsgRequest request = (GetNbMaxMsgRequest)adminRequest;
            int nbMaxMsg = -1;
            ClientSubscription sub = (ClientSubscription)this.subsTable.get(request.getSubName());
            if (sub != null) {
                nbMaxMsg = sub.getNbMaxMsg();
            }
            this.replyToTopic((AdminReply)new GetNumberReply(nbMaxMsg), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof GetDMQSettingsRequest) {
            this.replyToTopic((AdminReply)new GetDMQSettingsReply(this.dmqId != null ? this.dmqId.toString() : null, this.threshold), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetDMQRequest) {
            this.proxyAgent.setSave();
            this.dmqId = ((SetDMQRequest)adminRequest).getDmqId() != null ? AgentId.fromString((String)((SetDMQRequest)adminRequest).getDmqId()) : null;
            Iterator subs = this.subsTable.values().iterator();
            while (subs.hasNext()) {
                ((ClientSubscription)subs.next()).setDMQId(this.dmqId);
            }
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetThresholdRequest) {
            this.proxyAgent.setSave();
            this.threshold = ((SetThresholdRequest)adminRequest).getThreshold();
            Iterator subs = this.subsTable.values().iterator();
            while (subs.hasNext()) {
                ((ClientSubscription)subs.next()).setThreshold(this.threshold);
            }
            this.replyToTopic(new AdminReply(true, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof SetNbMaxMsgRequest) {
            this.proxyAgent.setSave();
            int nbMaxMsg = ((SetNbMaxMsgRequest)adminRequest).getNbMaxMsg();
            AdminReply reply = null;
            String subName = ((SetNbMaxMsgRequest)adminRequest).getSubName();
            if (subName == null) {
                this.nbMaxMsg = nbMaxMsg;
                reply = new AdminReply(true, null);
            } else {
                ClientSubscription sub = (ClientSubscription)this.subsTable.get(subName);
                if (sub != null) {
                    sub.setNbMaxMsg(nbMaxMsg);
                    reply = new AdminReply(true, null);
                } else {
                    reply = new AdminReply(6, "Subscription unknow: " + subName);
                }
            }
            this.replyToTopic(reply, not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        } else if (adminRequest instanceof DeleteUser) {
            this.deleteProxy(not);
        } else {
            logger.log(BasicLevel.ERROR, (Object)("Unknown administration request for proxy " + this.proxyAgent.getId()));
            this.replyToTopic(new AdminReply(5, null), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
    }

    private void doReact(GetSubscriptions request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        Iterator subsIterator = this.subsTable.entrySet().iterator();
        String[] subNames = new String[this.subsTable.size()];
        String[] topicIds = new String[this.subsTable.size()];
        int[] messageCounts = new int[this.subsTable.size()];
        boolean[] durable = new boolean[this.subsTable.size()];
        int i = 0;
        while (subsIterator.hasNext()) {
            Map.Entry subEntry = subsIterator.next();
            subNames[i] = (String)subEntry.getKey();
            ClientSubscription cs = (ClientSubscription)subEntry.getValue();
            topicIds[i] = cs.getTopicId().toString();
            messageCounts[i] = cs.getPendingMessageCount();
            durable[i] = cs.getDurable();
            ++i;
        }
        GetSubscriptionsRep reply = new GetSubscriptionsRep(subNames, topicIds, messageCounts, durable);
        this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
    }

    public String[] getSubscriptionNames() {
        return this.subsTable.keySet().toArray(new String[this.subsTable.size()]);
    }

    private void doReact(GetSubscriptionMessageIds request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            GetSubscriptionMessageIdsRep reply = new GetSubscriptionMessageIdsRep(cs.getMessageIds());
            this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(GetSubscription request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            GetSubscriptionRep reply = new GetSubscriptionRep(cs.getTopicId().toString(), cs.getPendingMessageCount(), cs.getDurable());
            this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(GetSubscriptionMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        ClientSubscription cs = null;
        String subName = request.getSubscriptionName();
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            String msgId = request.getMessageId();
            org.objectweb.joram.mom.messages.Message message = null;
            if (msgId != null) {
                message = cs.getSubscriptionMessage(msgId);
            }
            if (message != null) {
                GetSubscriptionMessageRep reply = null;
                reply = request.getFullMessage() ? new GetSubscriptionMessageRep(message.getFullMessage()) : new GetSubscriptionMessageRep(message.getHeaderMessage());
                this.replyToTopic((AdminReply)reply, replyTo, requestMsgId, replyMsgId);
            } else {
                this.replyToTopic(new AdminReply(false, "Message not found: " + request.getMessageId()), replyTo, requestMsgId, replyMsgId);
            }
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + subName), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void doReact(DeleteSubscriptionMessage request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            cs.deleteMessage(request.getMessageId());
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    public void deleteSubscriptionMessage(String subName, String msgId) {
        ClientSubscription cs = (ClientSubscription)this.subsTable.get(subName);
        if (cs != null) {
            cs.deleteMessage(msgId);
        }
    }

    private void doReact(ClearSubscription request, AgentId replyTo, String requestMsgId, String replyMsgId) {
        String subName = request.getSubscriptionName();
        ClientSubscription cs = null;
        if (subName != null) {
            cs = (ClientSubscription)this.subsTable.get(subName);
        }
        if (cs != null) {
            cs.clear();
            this.replyToTopic(new AdminReply(true, null), replyTo, requestMsgId, replyMsgId);
        } else {
            this.replyToTopic(new AdminReply(false, "Subscription not found: " + request.getSubscriptionName()), replyTo, requestMsgId, replyMsgId);
        }
    }

    private void replyToTopic(AdminReply reply, AgentId replyTo, String requestMsgId, String replyMsgId) {
        Message message = new Message();
        message.correlationId = requestMsgId;
        message.timestamp = System.currentTimeMillis();
        message.setDestination(replyTo.toString(), (byte)1);
        message.id = replyMsgId;
        try {
            message.setAdminMessage((AbstractAdminMessage)reply);
            ClientMessages clientMessages = new ClientMessages(-1, -1, message);
            Channel.sendTo((AgentId)replyTo, (Notification)clientMessages);
        }
        catch (Exception exc) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
            }
            throw new Error(exc.getMessage());
        }
    }

    private void setCtx(int key) throws StateException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.setCtx(" + key + ')'));
        }
        if (key < 0) {
            throw new StateException("Invalid context: " + key);
        }
        if (key == this.activeCtxId) {
            return;
        }
        this.setActiveCtxId(key);
        this.activeCtx = (ClientContext)this.contexts.get(new Integer(key));
        if (this.activeCtx == null) {
            this.setActiveCtxId(-1);
            this.activeCtx = null;
            throw new StateException("Context " + key + " is closed or broken.");
        }
    }

    private void doReply(AbstractJmsReply reply) {
        this.doReply(this.activeCtxId, reply);
    }

    ClientContext getClientContext(int ctxId) {
        return (ClientContext)this.contexts.get(new Integer(ctxId));
    }

    private void doReply(int key, AbstractJmsReply reply) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.doReply(" + key + ',' + reply + ')'));
        }
        this.proxyAgent.sendToClient(key, reply);
    }

    void cleanPendingMessages(long currentTime) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.cleanPendingMessages(" + this.messagesTable.size() + ')'));
        }
        org.objectweb.joram.mom.messages.Message message = null;
        DMQManager dmqManager = null;
        Iterator values = this.messagesTable.values().iterator();
        while (values.hasNext()) {
            message = (org.objectweb.joram.mom.messages.Message)values.next();
            if (message == null || message.isValid(currentTime)) continue;
            values.remove();
            if (message.durableAcksCounter > 0) {
                message.delete();
            }
            if (dmqManager == null) {
                dmqManager = new DMQManager(this.dmqId, null);
            }
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl expired message " + message.getIdentifier()));
        }
        Iterator subs = this.subsTable.values().iterator();
        while (subs.hasNext()) {
            ((ClientSubscription)subs.next()).cleanMessageIds();
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.cleanPendingMessages -> " + this.messagesTable.size()));
        }
    }

    public void delete() {
        DeleteUser request = new DeleteUser(this.getName(), this.proxyAgent.getId().toString());
        FwdAdminRequestNot deleteNot = new FwdAdminRequestNot((AdminRequest)request, null, null);
        Channel.sendTo((AgentId)AdminTopic.getDefault(), (Notification)deleteNot);
    }

    private void deleteProxy(FwdAdminRequestNot not) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("--- " + this + " notified to be deleted."));
        }
        String userName = ((DeleteUser)not.getRequest()).getUserName();
        if (this.contexts.size() > 0) {
            String info = "Delete proxy request successful [false]: proxy [" + this.proxyAgent.getId() + "] of user [" + userName + "] is currently in use.";
            if (not.getReplyTo() != null) {
                this.replyToTopic(new AdminReply(4, info), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
            }
            return;
        }
        AdminTopicImpl.deleteUser(userName);
        String info = "Delete proxy request successful [true]: proxy [" + this.proxyAgent.getId() + "] of user [" + userName + "] has been notified of deletion";
        if (not.getReplyTo() != null) {
            this.replyToTopic(new AdminReply(true, info), not.getReplyTo(), not.getRequestMsgId(), not.getReplyMsgId());
        }
        Iterator topics = this.topicsTable.keySet().iterator();
        while (topics.hasNext()) {
            AgentId destId = (AgentId)topics.next();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + destId + ')'));
            }
            topics.remove();
            this.updateSubscriptionToTopic(destId, -1, -1);
        }
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            String subName = (String)subEntry.getKey();
            ClientSubscription sub = (ClientSubscription)subEntry.getValue();
            sub.delete();
            try {
                MXWrapper.unregisterMBean((String)this.getMBeanName(subName));
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) continue;
                logger.log(BasicLevel.WARN, (Object)"  - Problem when unregistering ClientSubscriptionMbean", (Throwable)e);
            }
        }
        Channel.sendTo((AgentId)this.proxyAgent.getId(), (Notification)new DeleteNot());
    }

    private boolean updateSubscriptionToTopic(AgentId topicId, int contextId, int requestId) {
        return this.updateSubscriptionToTopic(topicId, contextId, requestId, false);
    }

    private boolean updateSubscriptionToTopic(AgentId topicId, int contextId, int requestId, boolean asyncSub) {
        TopicSubscription tSub;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl.updateSubscriptionToTopic(" + topicId + ',' + contextId + ',' + requestId + ',' + asyncSub + ')'));
        }
        if ((tSub = (TopicSubscription)this.topicsTable.get(topicId)) == null || tSub.isEmpty()) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable.remove(" + topicId + ')'));
            }
            this.topicsTable.remove(topicId);
            this.proxyAgent.sendNot(topicId, new UnsubscribeRequest(contextId, requestId));
            return false;
        }
        String builtSelector = tSub.buildSelector();
        if (tSub.getLastSelector() != null && builtSelector.equals(tSub.getLastSelector())) {
            return false;
        }
        tSub.setLastSelector(builtSelector);
        SubscribeRequest req = new SubscribeRequest(contextId, requestId, builtSelector, asyncSub);
        this.proxyAgent.sendNot(topicId, req);
        if (asyncSub) {
            this.doFwd(new SubscribeReply(req));
        }
        return true;
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int j;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl[" + this.proxyAgent.getId() + "].readbag()"));
        }
        this.activeCtxId = in.readInt();
        int size = in.readInt();
        Object obj = null;
        for (j = 0; j < size; ++j) {
            obj = in.readObject();
            ClientContext cc = (ClientContext)this.contexts.get(obj);
            cc.setProxyAgent(this.proxyAgent);
            cc.readBag(in);
        }
        size = in.readInt();
        for (j = 0; j < size; ++j) {
            obj = in.readObject();
            ClientSubscription cs = (ClientSubscription)this.subsTable.get(obj);
            cs.setProxyAgent(this.proxyAgent);
            cs.readBag(in);
        }
        this.activeCtx = (ClientContext)this.contexts.get(new Integer(this.activeCtxId));
        Vector messages = (Vector)in.readObject();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messages = " + messages));
        }
        this.topicsTable = new Hashtable();
        this.messagesTable = new Hashtable();
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            TopicSubscription tSub;
            String subName = (String)subEntry.getKey();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> subName = " + subName));
            }
            ClientSubscription cSub = (ClientSubscription)subEntry.getValue();
            AgentId destId = cSub.getTopicId();
            cSub.reinitialize(this.messagesTable, messages, false);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> destId = " + destId + ')'));
            }
            if ((tSub = (TopicSubscription)this.topicsTable.get(destId)) == null) {
                tSub = new TopicSubscription();
                this.topicsTable.put(destId, tSub);
            }
            tSub.putSubscription(subName, cSub.getSelector());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> topicsTable = " + this.topicsTable));
        }
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ProxyImpl[" + this.proxyAgent.getId() + "].writeBag()"));
        }
        out.writeInt(this.activeCtxId);
        out.writeInt(this.contexts.size());
        for (Map.Entry ctxEntry : this.contexts.entrySet()) {
            out.writeObject(ctxEntry.getKey());
            ((ClientContext)ctxEntry.getValue()).writeBag(out);
        }
        out.writeInt(this.subsTable.size());
        for (Map.Entry subEntry : this.subsTable.entrySet()) {
            out.writeObject(subEntry.getKey());
            ((ClientSubscription)subEntry.getValue()).writeBag(out);
        }
        Vector messages = new Vector();
        Iterator msgs = this.messagesTable.values().iterator();
        while (msgs.hasNext()) {
            messages.add(msgs.next());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messages = " + messages + ')'));
        }
        out.writeObject(messages);
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }
}

