/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.Directory;

final class TermInfosReader {
    private Directory directory;
    private String segment;
    private FieldInfos fieldInfos;
    private ThreadLocal enumerators = new ThreadLocal();
    private SegmentTermEnum origEnum;
    private long size;
    private Term[] indexTerms = null;
    private TermInfo[] indexInfos;
    private long[] indexPointers;
    private SegmentTermEnum indexEnum;
    private int indexDivisor = 1;
    private int totalIndexInterval;

    TermInfosReader(Directory dir, String seg, FieldInfos fis) throws CorruptIndexException, IOException {
        this(dir, seg, fis, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TermInfosReader(Directory dir, String seg, FieldInfos fis, int readBufferSize) throws CorruptIndexException, IOException {
        boolean success = false;
        try {
            this.directory = dir;
            this.segment = seg;
            this.fieldInfos = fis;
            this.origEnum = new SegmentTermEnum(this.directory.openInput(this.segment + ".tis", readBufferSize), this.fieldInfos, false);
            this.size = this.origEnum.size;
            this.totalIndexInterval = this.origEnum.indexInterval;
            this.indexEnum = new SegmentTermEnum(this.directory.openInput(this.segment + ".tii", readBufferSize), this.fieldInfos, true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public int getSkipInterval() {
        return this.origEnum.skipInterval;
    }

    public int getMaxSkipLevels() {
        return this.origEnum.maxSkipLevels;
    }

    public void setIndexDivisor(int indexDivisor) throws IllegalStateException {
        if (indexDivisor < 1) {
            throw new IllegalArgumentException("indexDivisor must be > 0: got " + indexDivisor);
        }
        if (this.indexTerms != null) {
            throw new IllegalStateException("index terms are already loaded");
        }
        this.indexDivisor = indexDivisor;
        this.totalIndexInterval = this.origEnum.indexInterval * indexDivisor;
    }

    public int getIndexDivisor() {
        return this.indexDivisor;
    }

    final void close() throws IOException {
        if (this.origEnum != null) {
            this.origEnum.close();
        }
        if (this.indexEnum != null) {
            this.indexEnum.close();
        }
        this.enumerators.set(null);
    }

    final long size() {
        return this.size;
    }

    private SegmentTermEnum getEnum() {
        SegmentTermEnum termEnum = (SegmentTermEnum)this.enumerators.get();
        if (termEnum == null) {
            termEnum = this.terms();
            this.enumerators.set(termEnum);
        }
        return termEnum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ensureIndexIsRead() throws IOException {
        if (this.indexTerms != null) {
            return;
        }
        try {
            int indexSize = 1 + ((int)this.indexEnum.size - 1) / this.indexDivisor;
            this.indexTerms = new Term[indexSize];
            this.indexInfos = new TermInfo[indexSize];
            this.indexPointers = new long[indexSize];
            int i = 0;
            while (this.indexEnum.next()) {
                this.indexTerms[i] = this.indexEnum.term();
                this.indexInfos[i] = this.indexEnum.termInfo();
                this.indexPointers[i] = this.indexEnum.indexPointer;
                for (int j = 1; j < this.indexDivisor && this.indexEnum.next(); ++j) {
                }
                ++i;
            }
        }
        finally {
            this.indexEnum.close();
            this.indexEnum = null;
        }
    }

    private final int getIndexOffset(Term term) {
        int lo = 0;
        int hi = this.indexTerms.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int delta = term.compareTo(this.indexTerms[mid]);
            if (delta < 0) {
                hi = mid - 1;
                continue;
            }
            if (delta > 0) {
                lo = mid + 1;
                continue;
            }
            return mid;
        }
        return hi;
    }

    private final void seekEnum(int indexOffset) throws IOException {
        this.getEnum().seek(this.indexPointers[indexOffset], indexOffset * this.totalIndexInterval - 1, this.indexTerms[indexOffset], this.indexInfos[indexOffset]);
    }

    TermInfo get(Term term) throws IOException {
        int enumOffset;
        if (this.size == 0L) {
            return null;
        }
        this.ensureIndexIsRead();
        SegmentTermEnum enumerator = this.getEnum();
        if (enumerator.term() != null && (enumerator.prev() != null && term.compareTo(enumerator.prev()) > 0 || term.compareTo(enumerator.term()) >= 0) && (this.indexTerms.length == (enumOffset = (int)(enumerator.position / (long)this.totalIndexInterval) + 1) || term.compareTo(this.indexTerms[enumOffset]) < 0)) {
            return this.scanEnum(term);
        }
        this.seekEnum(this.getIndexOffset(term));
        return this.scanEnum(term);
    }

    private final TermInfo scanEnum(Term term) throws IOException {
        SegmentTermEnum enumerator = this.getEnum();
        enumerator.scanTo(term);
        if (enumerator.term() != null && term.compareTo(enumerator.term()) == 0) {
            return enumerator.termInfo();
        }
        return null;
    }

    final Term get(int position) throws IOException {
        if (this.size == 0L) {
            return null;
        }
        SegmentTermEnum enumerator = this.getEnum();
        if (enumerator != null && enumerator.term() != null && (long)position >= enumerator.position && (long)position < enumerator.position + (long)this.totalIndexInterval) {
            return this.scanEnum(position);
        }
        this.seekEnum(position / this.totalIndexInterval);
        return this.scanEnum(position);
    }

    private final Term scanEnum(int position) throws IOException {
        SegmentTermEnum enumerator = this.getEnum();
        while (enumerator.position < (long)position) {
            if (enumerator.next()) continue;
            return null;
        }
        return enumerator.term();
    }

    final long getPosition(Term term) throws IOException {
        if (this.size == 0L) {
            return -1L;
        }
        this.ensureIndexIsRead();
        int indexOffset = this.getIndexOffset(term);
        this.seekEnum(indexOffset);
        SegmentTermEnum enumerator = this.getEnum();
        while (term.compareTo(enumerator.term()) > 0 && enumerator.next()) {
        }
        if (term.compareTo(enumerator.term()) == 0) {
            return enumerator.position;
        }
        return -1L;
    }

    public SegmentTermEnum terms() {
        return (SegmentTermEnum)this.origEnum.clone();
    }

    public SegmentTermEnum terms(Term term) throws IOException {
        this.get(term);
        return (SegmentTermEnum)this.getEnum().clone();
    }
}

