/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.xmlconfig.properties;

import java.util.LinkedList;
import java.util.List;
import org.ow2.util.xmlconfig.properties.IPropertyResolver;

public class PropertyResolverHelper {
    public static String resolve(IPropertyResolver propertyResolver, String propertyValue) throws IllegalArgumentException {
        Property property = new Property();
        PropertyResolverHelper.buildChain(property, propertyValue);
        return PropertyResolverHelper.resolveProperty(propertyResolver, property);
    }

    private static void buildChain(Property property, String propertyValue) {
        String tmp = propertyValue;
        while (!tmp.equals("")) {
            Property subProperty;
            String prefix;
            int imin = tmp.indexOf("${");
            if (imin == -1) {
                prefix = tmp;
                subProperty = null;
            } else if (imin == 0) {
                prefix = "";
                subProperty = new Property();
            } else {
                prefix = tmp.substring(0, imin);
                subProperty = new Property();
            }
            if (prefix.contains("}")) {
                throw new IllegalArgumentException(tmp + " is not a valid expression: ${ missing");
            }
            if (subProperty != null) {
                int imax;
                int counter = 1;
                for (imax = imin + 2; counter != 0 && imax < tmp.length(); ++imax) {
                    if (tmp.charAt(imax) == '}') {
                        --counter;
                        continue;
                    }
                    if (tmp.charAt(imax) != '{') continue;
                    ++counter;
                }
                if (counter != 0 && imax == tmp.length()) {
                    throw new IllegalArgumentException(tmp + " is not a valid expression: } missing");
                }
                String sProperty = tmp.substring(imin + 2, imax - 1);
                if (sProperty.equals("")) {
                    throw new IllegalArgumentException("The chain ${} is forbidden.");
                }
                PropertyResolverHelper.buildChain(subProperty, sProperty);
                tmp = tmp.substring(imax);
            } else {
                tmp = "";
            }
            property.getPrefixedProperties().add(new PrefixedProperty(prefix, subProperty));
        }
    }

    private static String resolveProperty(IPropertyResolver propertyResolver, Property property) {
        String result = "";
        for (PrefixedProperty prefixedProperty : property.getPrefixedProperties()) {
            result = result + prefixedProperty.getPrefix();
            Property subProperty = prefixedProperty.getProperty();
            if (subProperty == null) continue;
            String resolvedProperty = propertyResolver.resolve(PropertyResolverHelper.resolveProperty(propertyResolver, subProperty));
            if (resolvedProperty == null) {
                throw new IllegalArgumentException("Cannot resolve: " + subProperty);
            }
            result = result + resolvedProperty;
        }
        return result;
    }

    private static class PrefixedProperty {
        private final String prefix;
        private final Property property;

        public PrefixedProperty(String prefix, Property property) {
            this.prefix = prefix;
            this.property = property;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Property getProperty() {
            return this.property;
        }

        public String toString() {
            return this.prefix + (this.property == null ? "" : "${" + this.property + "}");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Property {
        private final List<PrefixedProperty> prefixedProperties = new LinkedList<PrefixedProperty>();

        public List<PrefixedProperty> getPrefixedProperties() {
            return this.prefixedProperties;
        }

        public String toString() {
            String result = "";
            for (PrefixedProperty prefixedProperty : this.prefixedProperties) {
                result = result + prefixedProperty;
            }
            return result;
        }
    }
}

