/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.clue;

import java.util.List;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.accessmanager.IClueAccessManager;
import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.LastUsedAccessManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LastUsedClueAccessManager<E, C>
extends LastUsedAccessManager<E>
implements IClueAccessManager<E, C> {
    private static final Log LOG = LogFactory.getLog(LastUsedClueAccessManager.class);
    private IClueManager<E, C> clueManager;

    public LastUsedClueAccessManager(IClueManager<E, C> clueManager) {
        this.clueManager = clueManager;
    }

    @Override
    public int choosePoolItemToGet(List<? extends E> poolItemList, C clue) {
        int lastIndex;
        for (int index = lastIndex = poolItemList.size() - 1; index >= 0; --index) {
            E poolItem = poolItemList.get(index);
            if (!this.clueManager.tryMatch(poolItem, clue)) continue;
            LOG.debug((Object)"We choose matching clue {0}.", new Object[]{poolItem});
            return index;
        }
        LOG.debug((Object)"Delay get", new Object[0]);
        return -1;
    }

    @Override
    public void removePoolItem(E poolItem) {
        super.removePoolItem(poolItem);
        this.clueManager.unMatch(poolItem);
    }

    @Override
    public int putPoolItem(List<? extends E> poolItemList, E poolItem) {
        int pos = super.putPoolItem(poolItemList, poolItem);
        this.clueManager.unMatch(poolItem);
        return pos;
    }
}

