/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.MessageListener;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.McastServiceImpl;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.UUIDGenerator;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class McastService
implements MembershipService,
MembershipListener,
MessageListener {
    private static final Log log = LogFactory.getLog(McastService.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.membership");
    private static final String info = "McastService/2.1";
    protected Properties properties = new Properties();
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected MessageListener msglistener;
    protected MemberImpl localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    protected byte[] payload;
    protected byte[] domain;
    protected static final Member[] EMPTY_MEMBERS = new Member[0];

    public McastService() {
        this.properties.setProperty("mcastPort", "45564");
        this.properties.setProperty("mcastAddress", "228.0.0.4");
        this.properties.setProperty("memberDropTime", "3000");
        this.properties.setProperty("mcastFrequency", "500");
    }

    public String getInfo() {
        return info;
    }

    @Override
    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "mcastFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public String getLocalMemberName() {
        return this.localMember.toString();
    }

    @Override
    public Member getLocalMember(boolean alive) {
        if (alive && this.localMember != null && this.impl != null) {
            this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        }
        return this.localMember;
    }

    @Override
    public void setLocalMemberProperties(String listenHost, int listenPort, int securePort, int udpPort) {
        this.properties.setProperty("tcpListenHost", listenHost);
        this.properties.setProperty("tcpListenPort", String.valueOf(listenPort));
        this.properties.setProperty("udpListenPort", String.valueOf(udpPort));
        this.properties.setProperty("tcpSecurePort", String.valueOf(securePort));
        try {
            if (this.localMember != null) {
                this.localMember.setHostname(listenHost);
                this.localMember.setPort(listenPort);
            } else {
                this.localMember = new MemberImpl(listenHost, listenPort, 0L);
                this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
                this.localMember.setPayload(this.getPayload());
                this.localMember.setDomain(this.getDomain());
            }
            this.localMember.setSecurePort(securePort);
            this.localMember.setUdpPort(udpPort);
            this.localMember.getData(true, true);
        }
        catch (IOException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public void setAddress(String addr) {
        this.properties.setProperty("mcastAddress", addr);
    }

    @Deprecated
    public void setMcastAddr(String addr) {
        this.setAddress(addr);
    }

    public String getAddress() {
        return this.properties.getProperty("mcastAddress");
    }

    @Deprecated
    public String getMcastAddr() {
        return this.getAddress();
    }

    public void setMcastBindAddress(String bindaddr) {
        this.setBind(bindaddr);
    }

    public void setBind(String bindaddr) {
        this.properties.setProperty("mcastBindAddress", bindaddr);
    }

    @Deprecated
    public String getMcastBindAddress() {
        return this.getBind();
    }

    public String getBind() {
        return this.properties.getProperty("mcastBindAddress");
    }

    @Deprecated
    public void setMcastPort(int port) {
        this.setPort(port);
    }

    public void setPort(int port) {
        this.properties.setProperty("mcastPort", String.valueOf(port));
    }

    public void setRecoveryCounter(int recoveryCounter) {
        this.properties.setProperty("recoveryCounter", String.valueOf(recoveryCounter));
    }

    public int getRecoveryCounter() {
        String p = this.properties.getProperty("recoveryCounter");
        if (p != null) {
            return new Integer(p);
        }
        return -1;
    }

    public void setRecoveryEnabled(boolean recoveryEnabled) {
        this.properties.setProperty("recoveryEnabled", String.valueOf(recoveryEnabled));
    }

    public boolean getRecoveryEnabled() {
        String p = this.properties.getProperty("recoveryEnabled");
        if (p != null) {
            return new Boolean(p);
        }
        return false;
    }

    public void setRecoverySleepTime(long recoverySleepTime) {
        this.properties.setProperty("recoverySleepTime", String.valueOf(recoverySleepTime));
    }

    public long getRecoverySleepTime() {
        String p = this.properties.getProperty("recoverySleepTime");
        if (p != null) {
            return new Long(p);
        }
        return -1L;
    }

    public void setLocalLoopbackDisabled(boolean localLoopbackDisabled) {
        this.properties.setProperty("localLoopbackDisabled", String.valueOf(localLoopbackDisabled));
    }

    public boolean getLocalLoopbackDisabled(boolean localLoopbackDisabled) {
        String p = this.properties.getProperty("localLoopbackDisabled");
        if (p != null) {
            return new Boolean(p);
        }
        return false;
    }

    @Deprecated
    public int getMcastPort() {
        return this.getPort();
    }

    public int getPort() {
        String p = this.properties.getProperty("mcastPort");
        return new Integer(p);
    }

    @Deprecated
    public void setMcastFrequency(long time) {
        this.setFrequency(time);
    }

    public void setFrequency(long time) {
        this.properties.setProperty("mcastFrequency", String.valueOf(time));
    }

    @Deprecated
    public long getMcastFrequency() {
        return this.getFrequency();
    }

    public long getFrequency() {
        String p = this.properties.getProperty("mcastFrequency");
        return new Long(p);
    }

    public void setMcastDropTime(long time) {
        this.setDropTime(time);
    }

    public void setDropTime(long time) {
        this.properties.setProperty("memberDropTime", String.valueOf(time));
    }

    @Deprecated
    public long getMcastDropTime() {
        return this.getDropTime();
    }

    public long getDropTime() {
        String p = this.properties.getProperty("memberDropTime");
        return new Long(p);
    }

    protected void hasProperty(Properties properties, String name) {
        if (properties.getProperty(name) == null) {
            throw new IllegalArgumentException("McastService:Required property \"" + name + "\" is missing.");
        }
    }

    @Override
    public void start() throws Exception {
        this.start(4);
        this.start(8);
    }

    @Override
    public void start(int level) throws Exception {
        this.hasProperty(this.properties, "mcastPort");
        this.hasProperty(this.properties, "mcastAddress");
        this.hasProperty(this.properties, "memberDropTime");
        this.hasProperty(this.properties, "mcastFrequency");
        this.hasProperty(this.properties, "tcpListenPort");
        this.hasProperty(this.properties, "tcpListenHost");
        this.hasProperty(this.properties, "tcpSecurePort");
        this.hasProperty(this.properties, "udpListenPort");
        if (this.impl != null) {
            this.impl.start(level);
            return;
        }
        String host = this.getProperties().getProperty("tcpListenHost");
        int port = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        int securePort = Integer.parseInt(this.getProperties().getProperty("tcpSecurePort"));
        int udpPort = Integer.parseInt(this.getProperties().getProperty("udpListenPort"));
        if (this.localMember == null) {
            this.localMember = new MemberImpl(host, port, 100L);
            this.localMember.setUniqueId(UUIDGenerator.randomUUID(true));
        } else {
            this.localMember.setHostname(host);
            this.localMember.setPort(port);
            this.localMember.setMemberAliveTime(100L);
        }
        this.localMember.setSecurePort(securePort);
        this.localMember.setUdpPort(udpPort);
        if (this.payload != null) {
            this.localMember.setPayload(this.payload);
        }
        if (this.domain != null) {
            this.localMember.setDomain(this.domain);
        }
        this.localMember.setServiceStartTime(System.currentTimeMillis());
        InetAddress bind = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            bind = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int ttl = -1;
        int soTimeout = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                ttl = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception x) {
                log.error("Unable to parse mcastTTL=" + this.properties.getProperty("mcastTTL"), x);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                soTimeout = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception x) {
                log.error("Unable to parse mcastSoTimeout=" + this.properties.getProperty("mcastSoTimeout"), x);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("mcastFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), bind, InetAddress.getByName(this.properties.getProperty("mcastAddress")), ttl, soTimeout, this, this, Boolean.valueOf(this.properties.getProperty("localLoopbackDisabled", "false")));
        String value = this.properties.getProperty("recoveryEnabled", "true");
        boolean recEnabled = Boolean.valueOf(value);
        this.impl.setRecoveryEnabled(recEnabled);
        int recCnt = Integer.parseInt(this.properties.getProperty("recoveryCounter", "10"));
        this.impl.setRecoveryCounter(recCnt);
        long recSlpTime = Long.parseLong(this.properties.getProperty("recoverySleepTime", "5000"));
        this.impl.setRecoverySleepTime(recSlpTime);
        this.impl.start(level);
    }

    @Override
    public void stop(int svc) {
        try {
            if (this.impl != null && this.impl.stop(svc)) {
                this.impl = null;
            }
        }
        catch (Exception x) {
            log.error("Unable to stop the mcast service, level:" + svc + ".", x);
        }
    }

    @Override
    public String[] getMembersByName() {
        String[] membernames;
        Member[] currentMembers = this.getMembers();
        if (currentMembers != null) {
            membernames = new String[currentMembers.length];
            for (int i = 0; i < currentMembers.length; ++i) {
                membernames[i] = currentMembers[i].toString();
            }
        } else {
            membernames = new String[]{};
        }
        return membernames;
    }

    @Override
    public Member findMemberByName(String name) {
        Member[] currentMembers = this.getMembers();
        for (int i = 0; i < currentMembers.length; ++i) {
            if (!name.equals(currentMembers[i].toString())) continue;
            return currentMembers[i];
        }
        return null;
    }

    @Override
    public boolean hasMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return false;
        }
        return this.impl.membership.hasMembers();
    }

    @Override
    public Member getMember(Member mbr) {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMember(mbr);
    }

    @Override
    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return EMPTY_MEMBERS;
        }
        return this.impl.membership.getMembers();
    }

    @Override
    public void setMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    public void setMessageListener(MessageListener listener) {
        this.msglistener = listener;
    }

    public void removeMessageListener() {
        this.msglistener = null;
    }

    @Override
    public void removeMembershipListener() {
        this.listener = null;
    }

    @Override
    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    @Override
    public void messageReceived(ChannelMessage msg) {
        if (this.msglistener != null && this.msglistener.accept(msg)) {
            this.msglistener.messageReceived(msg);
        }
    }

    @Override
    public boolean accept(ChannelMessage msg) {
        return true;
    }

    @Override
    public void broadcast(ChannelMessage message) throws ChannelException {
        if (this.impl == null || (this.impl.startLevel & 8) != 8) {
            throw new ChannelException("Multicast send is not started or enabled.");
        }
        byte[] data = XByteBuffer.createDataPackage((ChannelData)message);
        if (data.length > McastServiceImpl.MAX_PACKET_SIZE) {
            throw new ChannelException("Packet length[" + data.length + "] exceeds max packet size of " + McastServiceImpl.MAX_PACKET_SIZE + " bytes.");
        }
        DatagramPacket packet = new DatagramPacket(data, 0, data.length);
        try {
            this.impl.send(false, packet);
        }
        catch (Exception x) {
            throw new ChannelException(x);
        }
    }

    @Deprecated
    public int getMcastSoTimeout() {
        return this.getSoTimeout();
    }

    public int getSoTimeout() {
        return this.mcastSoTimeout;
    }

    @Deprecated
    public void setMcastSoTimeout(int mcastSoTimeout) {
        this.setSoTimeout(mcastSoTimeout);
    }

    public void setSoTimeout(int mcastSoTimeout) {
        this.mcastSoTimeout = mcastSoTimeout;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(mcastSoTimeout));
    }

    @Deprecated
    public int getMcastTTL() {
        return this.getTtl();
    }

    public int getTtl() {
        return this.mcastTTL;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getDomain() {
        return this.domain;
    }

    @Deprecated
    public void setMcastTTL(int mcastTTL) {
        this.setTtl(mcastTTL);
    }

    public void setTtl(int mcastTTL) {
        this.mcastTTL = mcastTTL;
        this.properties.setProperty("mcastTTL", String.valueOf(mcastTTL));
    }

    @Override
    public void setPayload(byte[] payload) {
        this.payload = payload;
        if (this.localMember != null) {
            this.localMember.setPayload(payload);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception x) {
                log.error("Unable to send payload update.", x);
            }
        }
    }

    @Override
    public void setDomain(byte[] domain) {
        this.domain = domain;
        if (this.localMember != null) {
            this.localMember.setDomain(domain);
            this.localMember.getData(true, true);
            try {
                if (this.impl != null) {
                    this.impl.send(false);
                }
            }
            catch (Exception x) {
                log.error("Unable to send domain update.", x);
            }
        }
    }

    public void setDomain(String domain) {
        if (domain == null) {
            return;
        }
        if (domain.startsWith("{")) {
            this.setDomain(Arrays.fromString(domain));
        } else {
            this.setDomain(Arrays.convert(domain));
        }
    }

    public static void main(String[] args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Usage McastService hostname tcpport");
        }
        McastService service = new McastService();
        Properties p = new Properties();
        p.setProperty("mcastPort", "5555");
        p.setProperty("mcastAddress", "224.10.10.10");
        p.setProperty("mcastClusterDomain", "catalina");
        p.setProperty("bindAddress", "localhost");
        p.setProperty("memberDropTime", "3000");
        p.setProperty("mcastFrequency", "500");
        p.setProperty("tcpListenPort", "4000");
        p.setProperty("tcpListenHost", "127.0.0.1");
        service.setProperties(p);
        service.start();
        Thread.sleep(3600000L);
    }
}

