/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class Protocols {
    public static final String RMI_JRMP = "jrmp";
    public static final String RMI_IRMI = "irmi";
    public static final String RMI_IIOP = "iiop";
    public static final String CMI_RMI = "cmi";
    private SortedSet protocolNames = new TreeSet();

    public Protocols(String pns) {
        this(pns, false);
    }

    public Protocols(String pns, boolean configure) {
        if (pns != null && pns.length() > 0) {
            StringTokenizer st = new StringTokenizer(pns, ",", false);
            while (st.hasMoreTokens()) {
                this.protocolNames.add(st.nextToken().trim());
            }
        }
        if (configure) {
            if (this.protocolNames.size() == 0) {
                this.protocolNames.add(RMI_JRMP);
            }
            if (this.protocolNames.contains(CMI_RMI) || this.protocolNames.contains(RMI_IRMI)) {
                this.protocolNames.add(RMI_JRMP);
            }
            if (this.protocolNames.contains(RMI_JRMP)) {
                this.protocolNames.add(RMI_IRMI);
            }
        }
    }

    public boolean isSupported(String pn) {
        return this.protocolNames.contains(pn) || pn.equals(RMI_IRMI) && this.protocolNames.contains(RMI_JRMP) || pn.equals(RMI_JRMP) && this.protocolNames.contains(RMI_IRMI);
    }

    public boolean isSupported(Protocols pns) {
        Iterator it = pns.iterator();
        while (it.hasNext()) {
            if (!this.isSupported((String)it.next())) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return this.protocolNames.iterator();
    }

    public String list() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    public String toString() {
        return this.list();
    }
}

