/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import com.scalagent.jmx.JMXServer;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.CommException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.objectweb.joram.client.connector.ActivationSpecImpl;
import org.objectweb.joram.client.connector.InboundConsumer;
import org.objectweb.joram.client.connector.JoramAdapterMBean;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.ConnectionMetaData;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.local.HALocalConnectionFactory;
import org.objectweb.joram.client.jms.ha.tcp.HATcpConnectionFactory;
import org.objectweb.joram.client.jms.local.LocalConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public final class JoramAdapter
implements ResourceAdapter,
JoramAdapterMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)JoramAdapter.class.getName());
    private boolean started = false;
    private boolean stopped = false;
    boolean collocated = false;
    String hostName = "localhost";
    int serverPort = 16010;
    String haURL = null;
    String rootName = "root";
    String rootPasswd = "root";
    String identityClass = SimpleIdentity.class.getName();
    short serverId = 0;
    private String serverName = "s0";
    short clusterId = (short)-1;
    boolean isHa = false;
    private String platformConfigDir;
    private boolean persistentPlatform = false;
    private String adminFileXML = "joramAdmin.xml";
    private String adminFileExportXML = "joramAdminExport.xml";
    public int connectingTimer = 0;
    public int txPendingTimer = 0;
    public int cnxPendingTimer = 0;
    public int queueMessageReadMax = 2;
    public int topicAckBufferMax = 0;
    public int topicPassivationThreshold = Integer.MAX_VALUE;
    public int topicActivationThreshold = 0;
    public boolean asyncSend = false;
    public boolean multiThreadSync = false;
    public int multiThreadSyncDelay = 1;
    public boolean deleteDurableSubscription = false;
    public JMXServer jmxServer;
    private static MBeanServer mbs = null;
    private static String jmxRootName = "joramClient";
    private static Vector boundNames = new Vector();
    private transient WorkManager workManager;
    private transient Hashtable consumers;
    private transient Vector producers;
    private transient Hashtable connections;

    public void setCollocatedServer(Boolean collocatedServer) {
        this.collocated = collocatedServer;
    }

    public Boolean getCollocatedServer() {
        return new Boolean(this.collocated);
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getServerPort() {
        return new Integer(this.serverPort);
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public String getHAURL() {
        return this.haURL;
    }

    public void setHAURL(String haURL) {
        this.haURL = haURL;
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String rn) {
        this.rootName = rn;
    }

    public String getRootPasswd() {
        return this.rootPasswd;
    }

    public void setRootPasswd(String rp) {
        this.rootPasswd = rp;
    }

    public String getIdentityClass() {
        return this.identityClass;
    }

    public void setIdentityClass(String identityClass) {
        this.identityClass = identityClass;
    }

    public Short getServerId() {
        return new Short(this.serverId);
    }

    public void setServerId(Short serverId) {
        this.serverId = serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Short getClusterId() {
        return new Short(this.clusterId);
    }

    public void setClusterId(Short clusterId) {
        this.clusterId = clusterId;
        if (this.clusterId != -1) {
            this.isHa = true;
        }
    }

    public String getPlatformConfigDir() {
        return this.platformConfigDir;
    }

    public void setPlatformConfigDir(String platformConfigDir) {
        this.platformConfigDir = platformConfigDir;
    }

    public Boolean getPersistentPlatform() {
        return new Boolean(this.persistentPlatform);
    }

    public void setPersistentPlatform(Boolean persistentPlatform) {
        this.persistentPlatform = persistentPlatform;
    }

    public String getAdminFileXML() {
        return this.adminFileXML;
    }

    public void setAdminFileXML(String adminFileXML) {
        this.adminFileXML = adminFileXML;
    }

    public String getAdminFileExportXML() {
        return this.adminFileExportXML;
    }

    public void setAdminFileExportXML(String adminFileExportXML) {
        this.adminFileExportXML = adminFileExportXML;
    }

    public Integer getConnectingTimer() {
        return new Integer(this.connectingTimer);
    }

    public void setConnectingTimer(Integer connectingTimer) {
        this.connectingTimer = connectingTimer;
    }

    public Integer getTxPendingTimer() {
        return new Integer(this.txPendingTimer);
    }

    public void setTxPendingTimer(Integer txPendingTimer) {
        this.txPendingTimer = txPendingTimer;
    }

    public Integer getCnxPendingTimer() {
        return new Integer(this.cnxPendingTimer);
    }

    public void setCnxPendingTimer(Integer cnxPendingTimer) {
        this.cnxPendingTimer = cnxPendingTimer;
    }

    public Integer getQueueMessageReadMax() {
        return new Integer(this.queueMessageReadMax);
    }

    public void setQueueMessageReadMax(Integer queueMessageReadMax) {
        this.queueMessageReadMax = queueMessageReadMax;
    }

    public Integer getTopicAckBufferMax() {
        return new Integer(this.topicAckBufferMax);
    }

    public void setTopicAckBufferMax(Integer topicAckBufferMax) {
        this.topicAckBufferMax = topicAckBufferMax;
    }

    public Integer getTopicPassivationThreshold() {
        return new Integer(this.topicPassivationThreshold);
    }

    public void setTopicPassivationThreshold(Integer topicPassivationThreshold) {
        this.topicPassivationThreshold = topicPassivationThreshold;
    }

    public Integer getTopicActivationThreshold() {
        return new Integer(this.topicActivationThreshold);
    }

    public void setTopicActivationThreshold(Integer topicActivationThreshold) {
        this.topicActivationThreshold = topicActivationThreshold;
    }

    public Boolean getAsyncSend() {
        return new Boolean(this.asyncSend);
    }

    public void setAsyncSend(Boolean asyncSend) {
        this.asyncSend = asyncSend;
    }

    public Boolean getMultiThreadSync() {
        return new Boolean(this.multiThreadSync);
    }

    public void setMultiThreadSync(Boolean multiThreadSync) {
        this.multiThreadSync = multiThreadSync;
    }

    public Integer getMultiThreadSyncDelay() {
        return new Integer(this.multiThreadSyncDelay);
    }

    public void setMultiThreadSyncDelay(Integer multiThreadSyncDelay) {
        this.multiThreadSyncDelay = multiThreadSyncDelay;
    }

    public Boolean getDeleteDurableSubscription() {
        return new Boolean(this.deleteDurableSubscription);
    }

    public void setDeleteDurableSubscription(Boolean flg) {
        this.deleteDurableSubscription = flg;
    }

    public JoramAdapter() {
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter instantiated.");
        }
        this.consumers = new Hashtable();
        this.producers = new Vector();
        ArrayList<MBeanServer> array = MBeanServerFactory.findMBeanServer(null);
        if (!array.isEmpty()) {
            mbs = array.get(0);
        }
        this.jmxServer = new JMXServer(mbs);
    }

    public synchronized void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        block27: {
            block26: {
                block25: {
                    if (this.started) {
                        throw new ResourceAdapterInternalException("Adapter already started.");
                    }
                    if (this.stopped) {
                        throw new ResourceAdapterInternalException("Adapter has been stopped.");
                    }
                    AdminModule.setHa((boolean)this.isHa);
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)"JORAM adapter starting deployment...");
                    }
                    this.workManager = ctx.getWorkManager();
                    if (this.collocated) {
                        if (logger.isLoggable(BasicLevel.INFO)) {
                            logger.log(BasicLevel.INFO, (Object)" - Collocated JORAM server is starting...");
                        }
                        if (this.persistentPlatform) {
                            System.setProperty("Transaction", "fr.dyade.aaa.util.NTransaction");
                            System.setProperty("NTNoLockFile", "true");
                        } else {
                            System.setProperty("Transaction", "fr.dyade.aaa.util.NullTransaction");
                            System.setProperty("NbMaxAgents", "2147483647");
                        }
                        if (this.platformConfigDir != null) {
                            System.setProperty("fr.dyade.aaa.agent.A3CONF_DIR", this.platformConfigDir);
                            System.setProperty("fr.dyade.aaa.DEBUG_DIR", this.platformConfigDir);
                        }
                        try {
                            AgentServer.init((short)this.serverId, (String)this.serverName, null, (short)this.clusterId);
                            AgentServer.start();
                            if (logger.isLoggable(BasicLevel.INFO)) {
                                logger.log(BasicLevel.INFO, (Object)"JoramAdapter - Collocated JORAM server has successfully started.");
                            }
                        }
                        catch (Exception exc) {
                            AgentServer.stop();
                            AgentServer.reset((boolean)true);
                            throw new ResourceAdapterInternalException("Could not start collocated JORAM instance: " + exc);
                        }
                    }
                    try {
                        this.adminConnect();
                        this.serverId = (short)AdminModule.getLocalServerId();
                    }
                    catch (Exception exc) {
                        if (!logger.isLoggable(BasicLevel.WARN)) break block25;
                        logger.log(BasicLevel.WARN, (Object)(" - JORAM server not administerable: " + exc));
                    }
                }
                try {
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("  - Reading the provided admin file: " + this.adminFileXML));
                    }
                    AdminModule.executeXMLAdmin((String)this.platformConfigDir, (String)this.adminFileXML);
                }
                catch (FileNotFoundException exc) {
                    if (logger.isLoggable(BasicLevel.INFO)) {
                        logger.log(BasicLevel.INFO, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML));
                    }
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.ERROR)) break block26;
                    logger.log(BasicLevel.ERROR, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML), (Throwable)exc);
                }
            }
            try {
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("  - Reading the provided admin file: " + this.adminFileExportXML));
                }
                AdminModule.executeXMLAdmin((String)this.platformConfigDir, (String)this.adminFileExportXML);
            }
            catch (FileNotFoundException exc) {
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML));
                }
            }
            catch (Exception exc) {
                if (!logger.isLoggable(BasicLevel.ERROR)) break block27;
                logger.log(BasicLevel.ERROR, (Object)("JoramAdapter - problem during XML configuration: " + this.adminFileExportXML), (Throwable)exc);
            }
        }
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("Server port is " + this.serverPort));
        }
        this.started = true;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)("JORAM adapter " + ConnectionMetaData.providerVersion + " successfully deployed."));
        }
    }

    void adminConnect() throws AdminException {
        try {
            ConnectionFactory cf;
            if (this.isHa) {
                if (this.collocated) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)("haURL = " + this.haURL));
                    }
                    cf = this.haURL != null ? HATcpConnectionFactory.create((String)this.haURL) : HALocalConnectionFactory.create();
                } else {
                    String urlHa = "hajoram://" + this.hostName + ":" + this.serverPort;
                    cf = HATcpConnectionFactory.create((String)urlHa);
                }
            } else {
                cf = this.collocated ? LocalConnectionFactory.create() : TcpConnectionFactory.create((String)this.hostName, (int)this.serverPort);
            }
            cf.getParameters().connectingTimer = 60;
            AdminModule.connect((TopicConnectionFactory)cf, (String)this.rootName, (String)this.rootPasswd, (String)this.identityClass);
            try {
                this.jmxServer.registerMBean((Object)this, MXWrapper.objectName((String)jmxRootName, (String)"type=JoramAdapter"));
            }
            catch (Exception e) {
                if (logger.isLoggable(BasicLevel.WARN)) {
                    logger.log(BasicLevel.WARN, (Object)"  - Could not register JoramAdapterMBean", (Throwable)e);
                }
            }
        }
        catch (ConnectException exc) {
            throw new AdminException("Admin connection can't be established: " + exc.getMessage());
        }
    }

    public synchronized void stop() {
        block18: {
            block17: {
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)"JORAM adapter stopping...");
                }
                if (!this.started || this.stopped) {
                    return;
                }
                while (!boundNames.isEmpty()) {
                    this.unbind((String)boundNames.remove(0));
                }
                AdminModule.disconnect();
                try {
                    this.jmxServer.unregisterMBean(MXWrapper.objectName((String)jmxRootName, (String)"type=JoramAdapter"));
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block17;
                    logger.log(BasicLevel.WARN, (Object)"unregisterMBean", (Throwable)e);
                }
            }
            while (!this.producers.isEmpty()) {
                try {
                    ((ManagedConnectionImpl)this.producers.remove(0)).destroy();
                }
                catch (Exception exc) {}
            }
            Enumeration keys = this.consumers.keys();
            while (keys.hasMoreElements()) {
                ((InboundConsumer)this.consumers.get(keys.nextElement())).close();
            }
            if (this.connections != null) {
                keys = this.connections.keys();
                while (keys.hasMoreElements()) {
                    try {
                        ((XAConnection)this.connections.get(keys.nextElement())).close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.collocated) {
                try {
                    AgentServer.stop();
                }
                catch (Exception exc) {
                    if (!logger.isLoggable(BasicLevel.WARN)) break block18;
                    logger.log(BasicLevel.WARN, (Object)"Error during AgentServer stopping", (Throwable)exc);
                }
            }
        }
        this.stopped = true;
        if (logger.isLoggable(BasicLevel.INFO)) {
            logger.log(BasicLevel.INFO, (Object)"JORAM adapter successfully stopped.");
        }
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        int ackMode;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (!this.started) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        if (!(spec instanceof ActivationSpecImpl)) {
            throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
        }
        ActivationSpecImpl specImpl = (ActivationSpecImpl)spec;
        if (!specImpl.getResourceAdapter().equals(this)) {
            throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Activating Endpoint on JORAM adapter.");
        }
        boolean durable = specImpl.getSubscriptionDurability() != null && specImpl.getSubscriptionDurability().equalsIgnoreCase("Durable");
        boolean transacted = false;
        try {
            Class<?> listenerClass = Class.forName("javax.jms.MessageListener");
            Class[] parameters = new Class[]{Class.forName("javax.jms.Message")};
            Method meth = listenerClass.getMethod("onMessage", parameters);
            transacted = endpointFactory.isDeliveryTransacted(meth);
        }
        catch (Exception exc) {
            throw new ResourceException("Could not determine transactional context: " + exc);
        }
        int maxWorks = 10;
        try {
            maxWorks = Integer.parseInt(specImpl.getMaxNumberOfWorks());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max number of works instances number: " + exc);
        }
        int maxMessages = 10;
        try {
            maxMessages = Integer.parseInt(specImpl.getMaxMessages());
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid max messages number: " + exc);
        }
        try {
            ackMode = "Auto-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 1 : ("Dups-ok-acknowledge".equals(specImpl.getAcknowledgeMode()) ? 3 : 1);
        }
        catch (Exception exc) {
            throw new ResourceException("Invalid acknowledge mode: " + exc);
        }
        String destType = specImpl.getDestinationType();
        String destName = specImpl.getDestination();
        try {
            Destination dest;
            try {
                InitialContext ctx = new InitialContext();
                dest = (Destination)ctx.lookup(destName);
            }
            catch (NamingException exc) {
                String shortName = JoramAdapter.removePrefix(destName);
                if ("javax.jms.Queue".equals(destType)) {
                    dest = AdminModule.createQueue((int)this.serverId, (String)shortName, (String)"org.objectweb.joram.mom.dest.Queue", null);
                } else if ("javax.jms.Topic".equals(destType)) {
                    dest = AdminModule.createTopic((int)this.serverId, (String)shortName, (String)"org.objectweb.joram.mom.dest.Topic", null);
                } else {
                    throw new NotSupportedException("Invalid destination type provided as activation parameter: " + destType);
                }
                dest.setFreeReading();
                dest.setFreeWriting();
                if (logger.isLoggable(BasicLevel.INFO)) {
                    logger.log(BasicLevel.INFO, (Object)("  - Destination [" + shortName + "] has been created."));
                }
                this.bind(destName, dest);
            }
            if ("javax.jms.Queue".equals(destType)) {
                if (!(dest instanceof Queue)) {
                    throw new NotSupportedException("Existing destination " + destName + " does not provide correct type.");
                }
            } else if ("javax.jms.Topic".equals(destType)) {
                if (!(dest instanceof Topic)) {
                    throw new NotSupportedException("Existing destination " + destName + " does not provide correct type.");
                }
            } else {
                throw new NotSupportedException("Invalid destination type provided as activation parameter: " + destType);
            }
            String userName = specImpl.getUserName();
            String password = specImpl.getPassword();
            String identityClass = specImpl.getIdentityClass();
            this.createUser(userName, password, identityClass);
            ConnectionFactory cf = null;
            cf = this.isHa ? (this.collocated ? (this.haURL != null ? HATcpConnectionFactory.create((String)this.haURL) : HALocalConnectionFactory.create()) : HATcpConnectionFactory.create((String)("hajoram://" + this.hostName + ':' + this.serverPort))) : (this.collocated ? LocalConnectionFactory.create() : TcpConnectionFactory.create((String)this.hostName, (int)this.serverPort));
            cf.getParameters().connectingTimer = this.connectingTimer;
            cf.getParameters().cnxPendingTimer = this.cnxPendingTimer;
            cf.getParameters().txPendingTimer = this.txPendingTimer;
            if (this.queueMessageReadMax > 0) {
                cf.getParameters().queueMessageReadMax = this.queueMessageReadMax;
            }
            if (this.topicAckBufferMax > 0) {
                cf.getParameters().topicAckBufferMax = this.topicAckBufferMax;
            }
            if (this.topicPassivationThreshold > 0) {
                cf.getParameters().topicPassivationThreshold = this.topicPassivationThreshold;
            }
            if (this.topicActivationThreshold > 0) {
                cf.getParameters().topicActivationThreshold = this.topicActivationThreshold;
            }
            cf.setIdentityClassName(identityClass);
            XAConnection cnx = cf.createXAConnection(userName, password);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " endpointActivation cnx = " + cnx));
            }
            InboundConsumer consumer = new InboundConsumer(this.workManager, endpointFactory, cnx, (javax.jms.Destination)dest, specImpl.getMessageSelector(), durable, specImpl.getSubscriptionName(), transacted, maxWorks, maxMessages, ackMode, this.deleteDurableSubscription);
            this.consumers.put(specImpl, consumer);
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            throw new CommException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        catch (ConnectException exc) {
            throw new ResourceException("Problem when handling the JORAM destinations: " + exc);
        }
        catch (AdminException exc) {
            throw new ResourceException("Problem when handling the JORAM destinations: " + (Object)((Object)exc));
        }
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        InboundConsumer consumer;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " endpointDeactivation(" + endpointFactory + ", " + spec + ")"));
        }
        if (!this.started || this.stopped) {
            return;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Deactivating Endpoint on JORAM adapter.");
        }
        if ((consumer = (InboundConsumer)this.consumers.remove(spec)) != null) {
            consumer.close();
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResources(" + specs + ")"));
        }
        if (!this.started) {
            throw new IllegalStateException("Non started resource adapter.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Stopped resource adapter.");
        }
        ConnectionFactory cf = null;
        Vector<XAResource> resources = new Vector<XAResource>();
        if (this.connections == null) {
            this.connections = new Hashtable();
        }
        try {
            for (int i = 0; i < specs.length; ++i) {
                if (!(specs[i] instanceof ActivationSpecImpl)) {
                    throw new ResourceException("Provided ActivationSpec instance is not a JORAM activation spec.");
                }
                ActivationSpecImpl specImpl = (ActivationSpecImpl)specs[i];
                if (!specImpl.getResourceAdapter().equals(this)) {
                    throw new ResourceException("Supplied ActivationSpec instance associated to an other ResourceAdapter.");
                }
                String userName = specImpl.getUserName();
                if (!this.connections.containsKey(userName)) {
                    String password = specImpl.getPassword();
                    String identityClass = specImpl.getIdentityClass();
                    if (this.isHa) {
                        if (this.collocated) {
                            if (logger.isLoggable(BasicLevel.DEBUG)) {
                                logger.log(BasicLevel.DEBUG, (Object)("haURL = " + this.haURL));
                            }
                            cf = this.haURL != null ? HATcpConnectionFactory.create((String)this.haURL) : HALocalConnectionFactory.create();
                        } else {
                            String urlHa = "hajoram://" + this.hostName + ":" + this.serverPort;
                            cf = HATcpConnectionFactory.create((String)urlHa);
                        }
                    } else {
                        cf = this.collocated ? LocalConnectionFactory.create() : TcpConnectionFactory.create((String)this.hostName, (int)this.serverPort);
                    }
                    cf.getParameters().connectingTimer = this.connectingTimer;
                    cf.getParameters().cnxPendingTimer = this.cnxPendingTimer;
                    cf.getParameters().txPendingTimer = this.txPendingTimer;
                    cf.setIdentityClassName(identityClass);
                    XAConnection connection = cf.createXAConnection(userName, password);
                    this.connections.put(userName, connection);
                    resources.add(connection.createXASession().getXAResource());
                }
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(this + " getXAResources resources = " + resources));
            }
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            throw new CommException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        return resources.toArray(new XAResource[resources.size()]);
    }

    public void exit() {
        AdminModule.disconnect();
    }

    public int hashCode() {
        return (this.collocated + " " + this.hostName + " " + this.serverPort).hashCode();
    }

    public boolean equals(Object o) {
        boolean res;
        if (!(o instanceof JoramAdapter)) {
            return false;
        }
        JoramAdapter other = (JoramAdapter)o;
        boolean bl = res = this.collocated == other.collocated && this.hostName.equals(other.hostName) && this.serverPort == other.serverPort;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " equals = " + res));
        }
        return res;
    }

    void addProducer(ManagedConnectionImpl managedCx) {
        this.producers.add(managedCx);
    }

    void removeProducer(ManagedConnectionImpl managedCx) {
        this.producers.remove(managedCx);
    }

    public String getJMSVersion() {
        return "1.1";
    }

    public String getJMSProviderName() {
        return "Joram";
    }

    public String getProviderVersion() {
        return ConnectionMetaData.providerVersion;
    }

    public long getTimeOutToAbortRequest() throws ConnectException {
        return AdminModule.getTimeOutToAbortRequest();
    }

    public void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        AdminModule.setTimeOutToAbortRequest((long)timeOut);
    }

    public String getDefaultDMQId() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId();
    }

    public String getDefaultDMQId(short serverId) throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId((int)serverId);
    }

    public void resetDefaultDMQ() throws ConnectException, AdminException {
        AdminModule.setDefaultDMQ(null);
    }

    public void resetDefaultDMQ(short serverId) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQ((int)serverId, null);
    }

    public int getDefaultThreshold() throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold();
    }

    public int getDefaultThreshold(short serverId) throws ConnectException, AdminException {
        return AdminModule.getDefaultThreshold((int)serverId);
    }

    public void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold((int)threshold);
    }

    public void setDefaultThreshold(short serverId, int threshold) throws ConnectException, AdminException {
        AdminModule.setDefaultThreshold((int)serverId, (int)threshold);
    }

    public String[] getDestinations() throws ConnectException, AdminException {
        return this.getDestinations((short)AdminModule.getLocalServerId());
    }

    public String[] getDestinations(short serverId) throws ConnectException, AdminException {
        Destination[] destinations = AdminModule.getDestinations((int)serverId);
        String[] names = new String[destinations.length];
        for (int i = 0; i < destinations.length; ++i) {
            names[i] = destinations[i].registerMBean(jmxRootName);
        }
        return names;
    }

    public String createQueue(String name) throws AdminException, ConnectException {
        return this.createQueue(this.serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public String createQueue(short serverId, String name) throws AdminException, ConnectException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public String createQueue(short serverId, String name, String className, Properties prop) throws AdminException, ConnectException {
        org.objectweb.joram.client.jms.Queue queue = null;
        try {
            InitialContext ctx = new InitialContext();
            queue = (org.objectweb.joram.client.jms.Queue)ctx.lookup(name);
        }
        catch (NamingException exc) {
            String shortName = JoramAdapter.removePrefix(name);
            queue = (org.objectweb.joram.client.jms.Queue)AdminModule.createQueue((int)serverId, (String)shortName, (String)className, (Properties)prop);
            queue.setFreeReading();
            queue.setFreeWriting();
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - Queue [" + shortName + "] has been created."));
            }
            this.bind(name, queue);
        }
        return queue.registerMBean(jmxRootName);
    }

    public String createTopic(String name) throws AdminException, ConnectException {
        return this.createTopic(this.serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public String createTopic(short serverId, String name) throws AdminException, ConnectException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public String createTopic(short serverId, String name, String className, Properties prop) throws AdminException, ConnectException {
        org.objectweb.joram.client.jms.Topic topic = null;
        try {
            InitialContext ctx = new InitialContext();
            topic = (org.objectweb.joram.client.jms.Topic)ctx.lookup(name);
        }
        catch (NamingException exc) {
            String shortName = JoramAdapter.removePrefix(name);
            topic = (org.objectweb.joram.client.jms.Topic)AdminModule.createTopic((int)serverId, (String)shortName, (String)className, (Properties)prop);
            topic.setFreeReading();
            topic.setFreeWriting();
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - Topic [" + shortName + "] has been created."));
            }
            this.bind(name, topic);
        }
        return topic.registerMBean(jmxRootName);
    }

    public void removeDestination(String name) throws AdminException {
        try {
            InitialContext ctx = new InitialContext();
            Destination dest = (Destination)ctx.lookup(name);
            ctx.close();
            dest.delete();
            this.unbind(name);
        }
        catch (Exception exc) {
            logger.log(BasicLevel.WARN, (Object)("removeDestination failed: " + name), (Throwable)exc);
            throw new AdminException("removeDestination(" + name + ") failed.");
        }
    }

    public String[] getUsers() throws ConnectException, AdminException {
        return this.getUsers((short)AdminModule.getLocalServerId());
    }

    public String[] getUsers(short serverId) throws ConnectException, AdminException {
        User[] users = AdminModule.getUsers((int)serverId);
        String[] names = new String[users.length];
        for (int i = 0; i < users.length; ++i) {
            names[i] = users[i].registerMBean(jmxRootName);
        }
        return names;
    }

    public String createUser(String name, String password) throws AdminException, ConnectException {
        return this.createUser(name, password, (short)AdminModule.getLocalServerId(), SimpleIdentity.class.getName());
    }

    public String createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        return this.createUser(name, password, (short)AdminModule.getLocalServerId(), identityClass);
    }

    public String createUser(String name, String password, short serverId) throws AdminException, ConnectException {
        return this.createUser(name, password, serverId, SimpleIdentity.class.getName());
    }

    public String createUser(String name, String password, short serverId, String identityClass) throws AdminException, ConnectException {
        User user = AdminModule.createUser((String)name, (String)password, (int)serverId, (String)identityClass);
        return user.registerMBean(jmxRootName);
    }

    public void createCF(String name) {
        ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = mcf.createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - ConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createQueueCF(String name) {
        ManagedQueueConnectionFactoryImpl mcf = new ManagedQueueConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = ((ManagedConnectionFactoryImpl)mcf).createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - QueueConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTopicCF(String name) {
        ManagedTopicConnectionFactoryImpl mcf = new ManagedTopicConnectionFactoryImpl();
        try {
            mcf.setResourceAdapter(this);
            mcf.setCollocated(new Boolean(false));
            Object factory = ((ManagedConnectionFactoryImpl)mcf).createConnectionFactory();
            this.bind(name, factory);
            if (logger.isLoggable(BasicLevel.INFO)) {
                logger.log(BasicLevel.INFO, (Object)("  - TopicConnectionFactory [" + name + "] has been created and bound."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String removePrefix(String name) {
        String PREFIX_NAME = "scn:comp/";
        try {
            if (name.startsWith(PREFIX_NAME)) {
                return name.substring(PREFIX_NAME.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    void bind(String name, Object obj) {
        block3: {
            try {
                InitialContext ctx = new InitialContext();
                ctx.rebind(name, obj);
                if (!boundNames.contains(name)) {
                    boundNames.add(name);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.WARN)) break block3;
                logger.log(BasicLevel.WARN, (Object)("Binding failed:  bind(" + name + "," + obj + ")"), (Throwable)e);
            }
        }
    }

    void unbind(String name) {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(name);
            boundNames.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void executeXMLAdmin(String path) throws Exception {
        AdminModule.executeXMLAdmin((String)path);
    }

    public void exportRepositoryToFile(String exportDir) throws AdminException {
        AdminModule.exportRepositoryToFile((String)exportDir, (String)this.adminFileExportXML);
    }

    public void exportRepositoryToFile(String exportDir, String exportFilename) throws AdminException {
        AdminModule.exportRepositoryToFile((String)exportDir, (String)exportFilename);
    }

    public Short[] getServersIds() throws ConnectException, AdminException {
        int[] sids = AdminModule.getWrapper().getServersIds();
        Short[] serversIds = new Short[sids.length];
        for (int i = 0; i < sids.length; ++i) {
            serversIds[i] = new Short((short)sids[i]);
        }
        return serversIds;
    }

    public final String[] getServersNames() throws ConnectException, AdminException {
        return AdminModule.getWrapper().getServersNames(null);
    }

    public final String getConfiguration() throws ConnectException, AdminException {
        return AdminModule.getConfiguration();
    }
}

