/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.UNKNOWN;
import org.omg.GIOP.ReplyStatusType_1_0;
import org.omg.GIOP.ReplyStatusType_1_0Helper;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.ReplyStatusType_1_2Helper;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContextListHelper;

public class ReplyOutputStream
extends ServiceContextTransportingOutputStream {
    private boolean is_locate_reply = false;
    private Logger logger;

    public ReplyOutputStream(int n, ReplyStatusType_1_2 replyStatusType_1_2, int n2, boolean bl, Logger logger) {
        this.is_locate_reply = bl;
        this.setGIOPMinor(n2);
        this.writeGIOPMsgHeader(1, n2);
        switch (n2) {
            case 0: 
            case 1: {
                ServiceContextListHelper.write(this, Messages.service_context);
                this.write_ulong(n);
                ReplyStatusType_1_0Helper.write(this, ReplyStatusType_1_0.from_int(replyStatusType_1_2.value()));
                break;
            }
            case 2: {
                this.write_ulong(n);
                ReplyStatusType_1_2Helper.write(this, replyStatusType_1_2);
                ServiceContextListHelper.write(this, Messages.service_context);
                this.markHeaderEnd();
                break;
            }
            default: {
                throw new MARSHAL("Unknown GIOP minor: " + n2);
            }
        }
    }

    public void write_to(GIOPConnection gIOPConnection) throws IOException {
        if (this.is_locate_reply) {
            ReplyInputStream replyInputStream = new ReplyInputStream(null, this.getBufferCopy());
            MessageOutputStream messageOutputStream = null;
            if (replyInputStream.getGIOPMinor() < 2) {
                switch (replyInputStream.rep_hdr.reply_status.value()) {
                    case 0: {
                        int n = replyInputStream.read_boolean() ? 0 : 1;
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, n, replyInputStream.getGIOPMinor());
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest");
                        }
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 0, replyInputStream.getGIOPMinor());
                        break;
                    }
                    case 3: {
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                        messageOutputStream.write_IOR(IORHelper.read(replyInputStream));
                    }
                }
            } else {
                switch (replyInputStream.rep_hdr.reply_status.value()) {
                    case 0: {
                        int n = replyInputStream.read_boolean() ? 0 : 1;
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, n, replyInputStream.getGIOPMinor());
                        break;
                    }
                    case 1: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received an exception when processing a LocateRequest - mapping to UNKNOWN system exception");
                        }
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                        SystemExceptionHelper.write(messageOutputStream, new UNKNOWN());
                    }
                    case 2: {
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 4, replyInputStream.getGIOPMinor());
                        SystemExceptionHelper.write(messageOutputStream, SystemExceptionHelper.read(replyInputStream));
                        break;
                    }
                    case 3: {
                        messageOutputStream = new LocateReplyOutputStream(replyInputStream.rep_hdr.request_id, 2, replyInputStream.getGIOPMinor());
                        messageOutputStream.write_IOR(IORHelper.read(replyInputStream));
                    }
                }
            }
            messageOutputStream.write_to(gIOPConnection);
        } else {
            super.write_to(gIOPConnection);
        }
    }
}

