/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.WorkerFactory;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.backend.configuration.MaskedProperty;
import org.hibernate.search.backend.impl.BatchedQueueingProcessor;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.backend.impl.batchlucene.LuceneBatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.MRUFilterCachingStrategy;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.impl.InitContext;
import org.hibernate.search.impl.MappingModelMetadataProvider;
import org.hibernate.search.impl.SearchMappingBuilder;
import org.hibernate.search.query.dsl.v2.QueryContextBuilder;
import org.hibernate.search.query.dsl.v2.impl.ConnectedQueryContextBuilder;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderFactory;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PluginLoader;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFactoryImpl
implements SearchFactoryImplementor {
    private static final Logger log;
    private final Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities = new HashMap();
    private final Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities = new HashMap();
    private final Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData = new HashMap();
    private final Worker worker;
    private final ReaderProvider readerProvider;
    private BackendQueueProcessorFactory backendQueueProcessorFactory;
    private final Map<String, FilterDef> filterDefinitions = new HashMap<String, FilterDef>();
    private final FilterCachingStrategy filterCachingStrategy;
    private Map<String, Analyzer> analyzers;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private final Properties configurationProperties;
    private final ErrorHandler errorHandler;
    private final PolymorphicIndexHierarchy indexHierarchy = new PolymorphicIndexHierarchy();
    private volatile short barrier;
    private Map<DirectoryProvider, LuceneIndexingParameters> dirProviderIndexingParams = new HashMap<DirectoryProvider, LuceneIndexingParameters>();
    private final String indexingStrategy;

    @Override
    public BackendQueueProcessorFactory getBackendQueueProcessorFactory() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.backendQueueProcessorFactory;
    }

    @Override
    public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
        this.backendQueueProcessorFactory = backendQueueProcessorFactory;
    }

    public SearchFactoryImpl(SearchConfiguration cfg) {
        this.configurationProperties = cfg.getProperties();
        this.errorHandler = SearchFactoryImpl.createErrorHandler(this.configurationProperties);
        ReflectionManager reflectionManager = this.getReflectionManager(cfg);
        SearchMapping mapping = SearchMappingBuilder.getSearchMapping(cfg);
        if (mapping != null) {
            if (!(reflectionManager instanceof MetadataProviderInjector)) {
                throw new SearchException("Programmatic mapping model used but ReflectionManager does not implement " + MetadataProviderInjector.class.getName());
            }
            MetadataProviderInjector injector = (MetadataProviderInjector)((Object)reflectionManager);
            MetadataProvider original = injector.getMetadataProvider();
            injector.setMetadataProvider(new MappingModelMetadataProvider(original, mapping));
        }
        this.indexingStrategy = SearchFactoryImpl.defineIndexingStrategy(cfg);
        this.initDocumentBuilders(cfg, reflectionManager);
        Set<Class<?>> indexedClasses = this.documentBuildersIndexedEntities.keySet();
        for (DocumentBuilderIndexedEntity<?> documentBuilderIndexedEntity : this.documentBuildersIndexedEntities.values()) {
            documentBuilderIndexedEntity.postInitialize(indexedClasses);
        }
        for (DocumentBuilderContainedEntity documentBuilderContainedEntity : this.documentBuildersContainedEntities.values()) {
            documentBuilderContainedEntity.postInitialize(indexedClasses);
        }
        this.fillSimilarityMapping();
        this.worker = WorkerFactory.createWorker(cfg, this);
        this.readerProvider = ReaderProviderFactory.createReaderProvider(cfg, this);
        this.filterCachingStrategy = SearchFactoryImpl.buildFilterCachingStrategy(cfg.getProperties());
        this.cacheBitResultsSize = ConfigurationParseHelper.getIntValue(cfg.getProperties(), "hibernate.search.filter.cache_docidresults.size", 5);
        this.barrier = 1;
    }

    private void fillSimilarityMapping() {
        for (DirectoryProviderData directoryConfiguration : this.dirProviderData.values()) {
            for (Class<?> indexedType : directoryConfiguration.classes) {
                DocumentBuilderIndexedEntity<?> documentBuilder = this.documentBuildersIndexedEntities.get(indexedType);
                Similarity similarity = documentBuilder.getSimilarity();
                Similarity prevSimilarity = directoryConfiguration.similarity;
                if (prevSimilarity != null && !prevSimilarity.getClass().equals(similarity.getClass())) {
                    throw new SearchException("Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overrriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation.");
                }
                directoryConfiguration.similarity = similarity;
            }
        }
    }

    private ReflectionManager getReflectionManager(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    private static String defineIndexingStrategy(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if (!"event".equals(indexingStrategy) && !"manual".equals(indexingStrategy)) {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
        return indexingStrategy;
    }

    @Override
    public String getIndexingStrategy() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.indexingStrategy;
    }

    @Override
    public void close() {
        if (this.barrier != 0) {
            // empty if block
        }
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.worker.close();
            }
            catch (Exception e) {
                log.error("Worker raises an exception on close()", (Throwable)e);
            }
            try {
                this.readerProvider.destroy();
            }
            catch (Exception e) {
                log.error("ReaderProvider raises an exception on destroy()", (Throwable)e);
            }
            for (DirectoryProvider<?> dp : this.getDirectoryProviders()) {
                try {
                    dp.stop();
                }
                catch (Exception e) {
                    log.error("DirectoryProvider raises an exception on stop() ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void addClassToDirectoryProvider(Class<?> clazz, DirectoryProvider<?> directoryProvider, boolean exclusiveIndexUsage) {
        DirectoryProviderData data = this.dirProviderData.get(directoryProvider);
        if (data == null) {
            data = new DirectoryProviderData();
            this.dirProviderData.put(directoryProvider, data);
        }
        data.classes.add(clazz);
        data.exclusiveIndexUsage = exclusiveIndexUsage;
    }

    @Override
    public Set<Class<?>> getClassesInDirectoryProvider(DirectoryProvider<?> directoryProvider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return Collections.unmodifiableSet(this.dirProviderData.get(directoryProvider).classes);
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void initProgrammaticallyDefinedFilterDef(ReflectionManager reflectionManager) {
        Map defaults = reflectionManager.getDefaults();
        FullTextFilterDef[] filterDefs = (FullTextFilterDef[])defaults.get(FullTextFilterDefs.class);
        if (filterDefs != null && filterDefs.length != 0) {
            for (FullTextFilterDef defAnn : filterDefs) {
                if (this.filterDefinitions.containsKey(defAnn.name())) {
                    throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name());
                }
                this.bindFullTextFilterDef(defAnn);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.filterDefinitions.containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        this.bindFullTextFilterDef(defAnn);
    }

    private void bindFullTextFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            this.filterDefinitions.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefinitions.put(defAnn.name(), filterDef);
    }

    @Override
    public Map<Class<?>, DocumentBuilderIndexedEntity<?>> getDocumentBuildersIndexedEntities() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.documentBuildersIndexedEntities;
    }

    @Override
    public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilderIndexedEntity(Class<T> entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.documentBuildersIndexedEntities.get(entityType);
    }

    @Override
    public <T> DocumentBuilderContainedEntity<T> getDocumentBuilderContainedEntity(Class<T> entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.documentBuildersContainedEntities.get(entityType);
    }

    @Override
    public Set<DirectoryProvider<?>> getDirectoryProviders() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.keySet();
    }

    @Override
    public Worker getWorker() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.worker;
    }

    @Override
    public void addOptimizerStrategy(DirectoryProvider<?> provider, OptimizerStrategy optimizerStrategy) {
        DirectoryProviderData data = this.dirProviderData.get(provider);
        if (data == null) {
            data = new DirectoryProviderData();
            this.dirProviderData.put(provider, data);
        }
        data.optimizerStrategy = optimizerStrategy;
    }

    @Override
    public void addIndexingParameters(DirectoryProvider<?> provider, LuceneIndexingParameters indexingParams) {
        this.dirProviderIndexingParams.put(provider, indexingParams);
    }

    @Override
    public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.get(provider).optimizerStrategy;
    }

    @Override
    public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderIndexingParams.get(provider);
    }

    @Override
    public ReaderProvider getReaderProvider() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.readerProvider;
    }

    @Override
    public DirectoryProvider[] getDirectoryProviders(Class<?> entity) {
        DocumentBuilderIndexedEntity<?> documentBuilder;
        if (this.barrier != 0) {
            // empty if block
        }
        return (documentBuilder = this.getDocumentBuilderIndexedEntity(entity)) == null ? null : documentBuilder.getDirectoryProviders();
    }

    @Override
    public void optimize() {
        if (this.barrier != 0) {
            // empty if block
        }
        Set<Class<?>> clazzs = this.getDocumentBuildersIndexedEntities().keySet();
        for (Class<?> clazz : clazzs) {
            this.optimize(clazz);
        }
    }

    @Override
    public void optimize(Class entityType) {
        if (this.barrier != 0) {
            // empty if block
        }
        if (!this.getDocumentBuildersIndexedEntities().containsKey(entityType)) {
            throw new SearchException("Entity not indexed: " + entityType);
        }
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>(1);
        queue.add(new OptimizeLuceneWork(entityType));
        this.getBackendQueueProcessorFactory().getProcessor(queue).run();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        Analyzer analyzer;
        if (this.barrier != 0) {
            // empty if block
        }
        if ((analyzer = this.analyzers.get(name)) == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("A class has to be specified for retrieving a scoped analyzer");
        }
        DocumentBuilderIndexedEntity<?> builder = this.documentBuildersIndexedEntities.get(clazz);
        if (builder == null) {
            throw new IllegalArgumentException("Entity for which to retrieve the scoped analyzer is not an @Indexed entity: " + clazz.getName());
        }
        return builder.getAnalyzer();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return new ConnectedQueryContextBuilder(this);
    }

    private void initDocumentBuilders(SearchConfiguration cfg, ReflectionManager reflectionManager) {
        InitContext context = new InitContext(cfg);
        Iterator<Class<?>> iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        this.initProgrammaticAnalyzers(context, reflectionManager);
        this.initProgrammaticallyDefinedFilterDef(reflectionManager);
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                if (mappedXClass.isAbstract()) {
                    log.warn("Abstract classes can never insert index documents. Remove @Indexed.");
                    continue;
                }
                DirectoryProviderFactory.DirectoryProviders providers = factory.createDirectoryProviders(mappedXClass, cfg, this, reflectionManager);
                DocumentBuilderIndexedEntity documentBuilder = new DocumentBuilderIndexedEntity(mappedXClass, context, providers.getProviders(), providers.getSelectionStrategy(), reflectionManager);
                this.indexHierarchy.addIndexedClass(mappedClass);
                this.documentBuildersIndexedEntities.put(mappedClass, documentBuilder);
            } else {
                DocumentBuilderContainedEntity documentBuilder = new DocumentBuilderContainedEntity(mappedXClass, context, reflectionManager);
                if (documentBuilder.getEntityState() != EntityState.NON_INDEXABLE) {
                    this.documentBuildersContainedEntities.put(mappedClass, documentBuilder);
                }
            }
            this.bindFilterDefs(mappedXClass);
        }
        this.analyzers = context.initLazyAnalyzers();
        factory.startDirectoryProviders();
    }

    private void initProgrammaticAnalyzers(InitContext context, ReflectionManager reflectionManager) {
        AnalyzerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (AnalyzerDef[])defaults.get(AnalyzerDefs.class)) != null) {
            for (AnalyzerDef def : defs) {
                context.addAnalyzerDef(def);
            }
        }
    }

    private static FilterCachingStrategy buildFilterCachingStrategy(Properties properties) {
        String impl = properties.getProperty("hibernate.search.filter.cache_strategy");
        FilterCachingStrategy filterCachingStrategy = StringHelper.isEmpty(impl) || "mru".equalsIgnoreCase(impl) ? new MRUFilterCachingStrategy() : PluginLoader.instanceFromName(FilterCachingStrategy.class, impl, SearchFactoryImpl.class, "filterCachingStrategy");
        filterCachingStrategy.initialize(properties);
        return filterCachingStrategy;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.filterCachingStrategy;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.filterDefinitions.get(name);
    }

    @Override
    public ReentrantLock getDirectoryProviderLock(DirectoryProvider<?> dp) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.get(dp).dirLock;
    }

    @Override
    public void addDirectoryProvider(DirectoryProvider<?> provider, boolean exclusiveIndexUsage) {
        DirectoryProviderData dirConfiguration = new DirectoryProviderData();
        dirConfiguration.exclusiveIndexUsage = exclusiveIndexUsage;
        this.dirProviderData.put(provider, dirConfiguration);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.cacheBitResultsSize;
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.indexHierarchy.getIndexedClasses(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        String impl = this.configurationProperties.getProperty("hibernate.search.batchbackend");
        BatchBackend batchBackend = StringHelper.isEmpty(impl) || "LuceneBatch".equalsIgnoreCase(impl) ? new LuceneBatchBackend() : PluginLoader.instanceFromName(BatchBackend.class, impl, SearchFactoryImpl.class, "batchbackend");
        MaskedProperty batchBackendConfiguration = new MaskedProperty(this.configurationProperties, "hibernate.search.batchbackend");
        batchBackend.initialize(batchBackendConfiguration, progressMonitor, this);
        return batchBackend;
    }

    @Override
    public Similarity getSimilarity(DirectoryProvider<?> provider) {
        Similarity similarity;
        if (this.barrier != 0) {
            // empty if block
        }
        if ((similarity = this.dirProviderData.get(provider).similarity) == null) {
            throw new SearchException("Assertion error: a similarity should be defined for each provider");
        }
        return similarity;
    }

    @Override
    public boolean isExclusiveIndexUsageEnabled(DirectoryProvider<?> provider) {
        if (this.barrier != 0) {
            // empty if block
        }
        return this.dirProviderData.get(provider).exclusiveIndexUsage;
    }

    private static ErrorHandler createErrorHandler(Properties configuration) {
        boolean sync = BatchedQueueingProcessor.isConfiguredAsSync(configuration);
        String errorHandlerClassName = configuration.getProperty("hibernate.search.error_handler");
        if (StringHelper.isEmpty(errorHandlerClassName)) {
            return new LogErrorHandler();
        }
        if (errorHandlerClassName.trim().equals("log")) {
            return new LogErrorHandler();
        }
        return PluginLoader.instanceFromName(ErrorHandler.class, errorHandlerClassName, SearchFactoryImpl.class, "Error Handler");
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PolymorphicIndexHierarchy {
        private Map<Class<?>, Set<Class<?>>> classToIndexedClass = new HashMap();

        PolymorphicIndexHierarchy() {
        }

        void addIndexedClass(Class indexedClass) {
            this.addClass(indexedClass, indexedClass);
            for (Class superClass = indexedClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                this.addClass(superClass, indexedClass);
            }
            for (Class<?> clazz : indexedClass.getInterfaces()) {
                this.addClass(clazz, indexedClass);
            }
        }

        private void addClass(Class superclass, Class indexedClass) {
            Set<Class<?>> classesSet = this.classToIndexedClass.get(superclass);
            if (classesSet == null) {
                classesSet = new HashSet();
                this.classToIndexedClass.put(superclass, classesSet);
            }
            classesSet.add(indexedClass);
        }

        Set<Class<?>> getIndexedClasses(Class<?>[] classes) {
            HashSet idexedClasses = new HashSet();
            for (Class<?> clazz : classes) {
                Set<Class<?>> set = this.classToIndexedClass.get(clazz);
                if (set == null) continue;
                idexedClasses.addAll(set);
            }
            if (log.isTraceEnabled()) {
                log.trace("Targeted indexed classes for {}: {}", (Object)Arrays.toString(classes), idexedClasses);
            }
            return idexedClasses;
        }
    }

    private static class DirectoryProviderData {
        public final ReentrantLock dirLock = new ReentrantLock();
        public OptimizerStrategy optimizerStrategy;
        public final Set<Class<?>> classes = new HashSet(2);
        public Similarity similarity = null;
        private boolean exclusiveIndexUsage;

        private DirectoryProviderData() {
        }
    }
}

