/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.Constants;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Processor
implements ActionHook,
Processor {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.http11");
    protected static boolean isSecurityEnabled = Constants.IS_SECURITY_ENABLED;
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected Pattern[] restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern[] noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected String server = null;
    protected AsyncStateMachine asyncStateMachine = new AsyncStateMachine(this);

    protected abstract Log getLog();

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void addNoCompressionUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.noCompressionUserAgents = this.addREArray(this.noCompressionUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            this.getLog().error(sm.getString("http11processor.regexp.error", userAgent), pse);
        }
    }

    public void setNoCompressionUserAgents(Pattern[] noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        if (noCompressionUserAgents != null) {
            StringTokenizer st = new StringTokenizer(noCompressionUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addNoCompressionUserAgent(st.nextToken().trim());
            }
        }
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public String[] findCompressableMimeTypes() {
        return this.compressableMimeTypes;
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    private String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    private Pattern[] addREArray(Pattern[] rArray, Pattern value) {
        Pattern[] result = null;
        if (rArray == null) {
            result = new Pattern[]{value};
        } else {
            result = new Pattern[rArray.length + 1];
            for (int i = 0; i < rArray.length; ++i) {
                result[i] = rArray[i];
            }
            result[rArray.length] = value;
        }
        return result;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedUserAgent(String userAgent) {
        try {
            Pattern nRule = Pattern.compile(userAgent);
            this.restrictedUserAgents = this.addREArray(this.restrictedUserAgents, nRule);
        }
        catch (PatternSyntaxException pse) {
            this.getLog().error(sm.getString("http11processor.regexp.error", userAgent), pse);
        }
    }

    public void setRestrictedUserAgents(Pattern[] restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        if (restrictedUserAgents != null) {
            StringTokenizer st = new StringTokenizer(restrictedUserAgents, ",");
            while (st.hasMoreTokens()) {
                this.addRestrictedUserAgent(st.nextToken().trim());
            }
        }
    }

    public String[] findRestrictedUserAgents() {
        String[] sarr = new String[this.restrictedUserAgents.length];
        for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
            sarr[i] = this.restrictedUserAgents[i].toString();
        }
        return sarr;
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public String getServer() {
        return this.server;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    private boolean isCompressable() {
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        long contentLength = this.response.getContentLengthLong();
        if ((contentLength == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    private boolean useCompression() {
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.noCompressionUserAgents.length; ++i) {
                if (!this.noCompressionUserAgents[i].matcher(userAgentValue).matches()) continue;
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected abstract AbstractInputBuffer getInputBuffer();

    protected abstract AbstractOutputBuffer getOutputBuffer();

    protected void initializeFilters() {
        this.getInputBuffer().addFilter(new IdentityInputFilter());
        this.getOutputBuffer().addFilter(new IdentityOutputFilter());
        this.getInputBuffer().addFilter(new ChunkedInputFilter());
        this.getOutputBuffer().addFilter(new ChunkedOutputFilter());
        this.getInputBuffer().addFilter(new VoidInputFilter());
        this.getOutputBuffer().addFilter(new VoidOutputFilter());
        this.getInputBuffer().addFilter(new BufferedInputFilter());
        this.getOutputBuffer().addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.getInputBuffer().getFilters().length;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.getInputBuffer().addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.getOutputBuffer().addFilter((OutputFilter)obj);
            } else {
                this.getLog().warn(sm.getString("http11processor.filter.unknown", className));
            }
        }
        catch (Exception e) {
            this.getLog().error(sm.getString("http11processor.filter.error", className), e);
        }
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.getInputBuffer().addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = this.pluggableFilterIndex; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.getInputBuffer().addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            try {
                this.prepareResponse();
                this.getOutputBuffer().commit();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACK) {
            if (this.response.isCommitted() || !this.expectation) {
                return;
            }
            this.getInputBuffer().setSwallowInput(true);
            try {
                this.getOutputBuffer().sendAck();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.CLIENT_FLUSH) {
            try {
                this.getOutputBuffer().flush();
            }
            catch (IOException e) {
                this.error = true;
                this.response.setErrorException(e);
            }
        } else if (actionCode == ActionCode.RESET) {
            this.getOutputBuffer().reset();
        } else if (actionCode != ActionCode.CUSTOM) {
            if (actionCode == ActionCode.REQ_SET_BODY_REPLAY) {
                ByteChunk body = (ByteChunk)param;
                SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
                savedBody.setRequest(this.request);
                AbstractInputBuffer internalBuffer = (AbstractInputBuffer)this.request.getInputBuffer();
                internalBuffer.addActiveFilter(savedBody);
            } else if (actionCode == ActionCode.ASYNC_START) {
                this.asyncStateMachine.asyncStart((AsyncContextImpl)param);
            } else if (actionCode == ActionCode.ASYNC_DISPATCHED) {
                this.asyncStateMachine.asyncDispatched();
            } else if (actionCode == ActionCode.ASYNC_TIMEOUT) {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
            } else if (actionCode == ActionCode.ASYNC_RUN) {
                this.asyncStateMachine.asyncRun((Runnable)param);
            } else if (actionCode == ActionCode.ASYNC_ERROR) {
                this.asyncStateMachine.asyncError();
            } else if (actionCode == ActionCode.ASYNC_IS_STARTED) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
            } else if (actionCode == ActionCode.ASYNC_IS_DISPATCHING) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
            } else if (actionCode == ActionCode.ASYNC_IS_ASYNC) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
            } else if (actionCode == ActionCode.ASYNC_IS_TIMINGOUT) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
            } else {
                this.actionInternal(actionCode, param);
            }
        }
    }

    abstract void actionInternal(ActionCode var1, Object var2);

    private void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.getOutputBuffer().getFilters();
        if (this.http09) {
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean sendingWithSendfile = false;
        if (this.getEndpoint().getUseSendfile()) {
            sendingWithSendfile = this.prepareSendfile(outputFilters);
        }
        boolean isCompressable = false;
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && !sendingWithSendfile) {
            isCompressable = this.isCompressable();
            if (isCompressable) {
                useCompression = this.useCompression();
            }
            if (useCompression) {
                this.response.setContentLength(-1);
            }
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11) {
            this.getOutputBuffer().addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            headers.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.getOutputBuffer().addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
        }
        if (isCompressable) {
            MessageBytes vary = headers.getValue("Vary");
            if (vary == null) {
                headers.setValue("Vary").setString("Accept-Encoding");
            } else if (!vary.equals("*")) {
                headers.setValue("Vary").setString(vary.getString() + ",Accept-Encoding");
            }
        }
        headers.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            headers.addValue("Connection").setString("close");
        } else if (!this.http11 && !this.error) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.getOutputBuffer().sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else if (headers.getValue("Server") == null) {
            this.getOutputBuffer().write(org.apache.coyote.http11.Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.getOutputBuffer().sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.getOutputBuffer().endHeaders();
    }

    abstract AbstractEndpoint getEndpoint();

    abstract boolean prepareSendfile(OutputFilter[] var1);

    public void endRequest() {
        try {
            this.getInputBuffer().endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getLog().error(sm.getString("http11processor.request.finish"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        try {
            this.getOutputBuffer().endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getLog().error(sm.getString("http11processor.response.finish"), t);
            this.error = true;
        }
    }

    public final void recycle() {
        this.getInputBuffer().recycle();
        this.getOutputBuffer().recycle();
        this.asyncStateMachine.recycle();
        this.recycleInternal();
    }

    protected abstract void recycleInternal();

    @Override
    public abstract Executor getExecutor();

    protected boolean isAsync() {
        return this.asyncStateMachine.isAsync();
    }

    protected AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }
}

