/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.HttpHeaderHelper;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSPropertyType;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.SimpleMessageConverter102;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMSUtils {
    static final Logger LOG = LogUtils.getL7dLogger(JMSUtils.class);
    private static final char[] CORRELATTION_ID_PADDING = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    private JMSUtils() {
    }

    public static long getTimeToLive(JMSMessageHeadersType headers) {
        long ttl = -1L;
        if (headers != null && headers.isSetTimeToLive()) {
            ttl = headers.getTimeToLive();
        }
        return ttl;
    }

    public static void setMessageProperties(JMSMessageHeadersType headers, javax.jms.Message message) throws JMSException {
        if (headers != null && headers.isSetProperty()) {
            List<JMSPropertyType> props = headers.getProperty();
            for (int x = 0; x < props.size(); ++x) {
                message.setStringProperty(props.get(x).getName(), props.get(x).getValue());
            }
        }
    }

    public static javax.jms.Message createAndSetPayload(Object payload, Session session, String messageType) throws JMSException {
        TextMessage message = null;
        if ("text".equals(messageType)) {
            message = session.createTextMessage((String)payload);
        } else if ("byte".equals(messageType)) {
            message = session.createBytesMessage();
            ((BytesMessage)message).writeBytes((byte[])payload);
        } else {
            message = session.createObjectMessage();
            ((ObjectMessage)message).setObject((Serializable)((byte[])payload));
        }
        return message;
    }

    public static byte[] retrievePayload(javax.jms.Message message, String encoding) throws UnsupportedEncodingException {
        Object converted;
        try {
            converted = new SimpleMessageConverter102().fromMessage(message);
        }
        catch (MessageConversionException e) {
            throw new RuntimeException("Conversion failed", e);
        }
        catch (JMSException e) {
            throw JmsUtils.convertJmsAccessException((JMSException)e);
        }
        if (converted instanceof String) {
            if (encoding != null) {
                return ((String)converted).getBytes(encoding);
            }
            return ((String)converted).getBytes("UTF-8");
        }
        if (converted instanceof byte[]) {
            return (byte[])converted;
        }
        return null;
    }

    public static void populateIncomingContext(javax.jms.Message message, Message inMessage, String headerType, JMSConfiguration jmsConfig) throws UnsupportedEncodingException {
        try {
            JMSMessageHeadersType headers = null;
            headers = (JMSMessageHeadersType)inMessage.get(headerType);
            if (headers == null) {
                headers = new JMSMessageHeadersType();
                inMessage.put(headerType, headers);
            }
            headers.setJMSCorrelationID(message.getJMSCorrelationID());
            headers.setJMSDeliveryMode(new Integer(message.getJMSDeliveryMode()));
            headers.setJMSExpiration(new Long(message.getJMSExpiration()));
            headers.setJMSMessageID(message.getJMSMessageID());
            headers.setJMSPriority(new Integer(message.getJMSPriority()));
            headers.setJMSRedelivered(message.getJMSRedelivered());
            headers.setJMSTimeStamp(new Long(message.getJMSTimestamp()));
            headers.setJMSType(message.getJMSType());
            if (message.getJMSReplyTo() != null) {
                Destination replyTo = message.getJMSReplyTo();
                if (replyTo instanceof Queue) {
                    headers.setJMSReplyTo(((Queue)replyTo).getQueueName());
                } else if (replyTo instanceof Topic) {
                    headers.setJMSReplyTo(((Topic)replyTo).getTopicName());
                }
            }
            HashMap<String, List<String>> protHeaders = new HashMap<String, List<String>>();
            List<JMSPropertyType> props = headers.getProperty();
            Enumeration enm = message.getPropertyNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                String val = message.getStringProperty(name);
                JMSPropertyType prop = new JMSPropertyType();
                prop.setName(name);
                prop.setValue(val);
                props.add(prop);
                protHeaders.put(name, Collections.singletonList(val));
                if (!name.equals("Content-Type") && (!name.equals("SOAPJMS_contentType") || val == null)) continue;
                inMessage.put("Content-Type", val);
                inMessage.put(Message.ENCODING, JMSUtils.getEncoding(val));
            }
            inMessage.put(Message.PROTOCOL_HEADERS, protHeaders);
            SecurityContext securityContext = JMSUtils.buildSecurityContext(message, jmsConfig);
            inMessage.put(SecurityContext.class, securityContext);
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    private static SecurityContext buildSecurityContext(javax.jms.Message message, JMSConfiguration config) throws JMSException {
        String tempUserName = message.getStringProperty("JMSXUserID");
        if (tempUserName == null && config.isJmsProviderTibcoEms()) {
            tempUserName = message.getStringProperty("JMS_TIBCO_SENDER");
        }
        if (tempUserName == null) {
            return null;
        }
        final String jmsUserName = tempUserName;
        final Principal principal = new Principal(){

            public String getName() {
                return jmsUserName;
            }
        };
        SecurityContext securityContext = new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                return false;
            }
        };
        return securityContext;
    }

    static String getEncoding(String ct) throws UnsupportedEncodingException {
        String normalizedEncoding;
        String[] tokens;
        String contentType = ct.toLowerCase();
        String enc = null;
        for (String token : tokens = contentType.split(";")) {
            int index = token.indexOf("charset=");
            if (index < 0) continue;
            enc = token.substring(index + 8);
            break;
        }
        if ((normalizedEncoding = HttpHeaderHelper.mapCharset(enc, "UTF-8")) == null) {
            String m = new org.apache.cxf.common.i18n.Message("INVALID_ENCODING_MSG", LOG, enc).toString();
            LOG.log(Level.WARNING, m);
            throw new UnsupportedEncodingException(m);
        }
        return normalizedEncoding;
    }

    protected static void addProtocolHeaders(javax.jms.Message message, Map<String, List<String>> headers) throws JMSException {
        if (headers == null) {
            return;
        }
        StringBuilder value = new StringBuilder(256);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            value.setLength(0);
            boolean first = true;
            for (String s : entry.getValue()) {
                if (!first) {
                    value.append("; ");
                }
                value.append(s);
                first = false;
            }
            if (entry.getKey().equals("Content-Type")) {
                message.setStringProperty("SOAPJMS_contentType", value.toString());
                continue;
            }
            message.setStringProperty(entry.getKey(), value.toString());
        }
    }

    public static void addContentTypeToProtocolHeader(Message message) {
        List<String> ct;
        Map headers;
        String contentType = (String)message.get("Content-Type");
        String enc = (String)message.get(Message.ENCODING);
        if (null != contentType) {
            if (enc != null && contentType.indexOf("charset=") == -1) {
                contentType = contentType + "; charset=" + enc;
            }
        } else {
            contentType = enc != null ? "text/xml; charset=" + enc : "text/xml";
        }
        if (null == (headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS)))) {
            headers = new HashMap();
            message.put(Message.PROTOCOL_HEADERS, headers);
        }
        if (headers.get("SOAPJMS_contentType") != null) {
            ct = (ArrayList<String>)headers.get("SOAPJMS_contentType");
        } else if (headers.get("Content-Type") != null) {
            ct = (List)headers.get("Content-Type");
        } else {
            ct = new ArrayList<String>();
            headers.put("SOAPJMS_contentType", ct);
        }
        ct.add(contentType);
    }

    public static javax.jms.Message buildJMSMessageFromCXFMessage(Message outMessage, Object payload, String messageType, Session session, Destination replyTo, String correlationId) throws JMSException {
        JMSMessageHeadersType headers;
        javax.jms.Message jmsMessage = JMSUtils.createAndSetPayload(payload, session, messageType);
        if (replyTo != null) {
            jmsMessage.setJMSReplyTo(replyTo);
        }
        if ((headers = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.client.request.headers")) == null) {
            headers = new JMSMessageHeadersType();
        }
        JMSUtils.setMessageProperties(headers, jmsMessage);
        JMSUtils.addContentTypeToProtocolHeader(outMessage);
        Map<String, List<String>> protHeaders = CastUtils.cast((Map)outMessage.get(Message.PROTOCOL_HEADERS));
        JMSUtils.addProtocolHeaders(jmsMessage, protHeaders);
        jmsMessage.setJMSCorrelationID(correlationId);
        return jmsMessage;
    }

    public static String createCorrelationId(String prefix, long i) {
        String index = Long.toHexString(i);
        StringBuilder id = new StringBuilder(prefix);
        id.append(CORRELATTION_ID_PADDING, 0, 16 - index.length());
        id.append(index);
        return id.toString();
    }
}

