/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.eval.prefetch.api.PrefetchBuffer;
import org.objectweb.medor.eval.prefetch.api.PrefetchBufferHolder;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;
import org.objectweb.util.monolog.api.BasicLevel;

public class ProjectEvaluatedTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC,
PrefetchBufferHolder {
    private QueryNode query;
    private TupleCollection subResultTC;
    private ParameterOperand[] parameters;
    private Tuple currentBuffer;
    private VariableOperand[] currentAttBuffers;
    private int cursor;
    private int size;
    private boolean empty;
    private boolean userHasClosed = false;
    private PrefetchBuffer prefetchBuffer;

    public ProjectEvaluatedTC(QueryNode query, NodeEvaluator subNodeEvaluator, ParameterOperand[] parameters, PrefetchBuffer pb) throws MedorException {
        this.parameters = parameters;
        this.query = query;
        this.prefetchBuffer = pb;
        if (this.prefetchBuffer != null) {
            pb.setTupleCollection(this);
        }
        this.size = query.getTupleStructure().getSize();
        this.currentAttBuffers = new BasicVariableOperand[this.size];
        for (int cpt = 0; cpt < query.getTupleStructure().getSize(); ++cpt) {
            this.currentAttBuffers[cpt] = new BasicVariableOperand(query.getTupleStructure().getField(cpt + 1).getType());
        }
        this.currentBuffer = new MemoryTuple(this.currentAttBuffers);
        this.subResultTC = subNodeEvaluator.fetchData(parameters);
        this.empty = this.subResultTC.isEmpty();
        if (this.empty) {
            this.cursor = 0;
        } else {
            this.init();
        }
    }

    public void invalidatePrefetchBuffer() throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Invalidating PrefetchBuffer " + this.prefetchBuffer + " for " + this));
        }
        this.prefetchBuffer = null;
        if (this.userHasClosed) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)"The tupleCollection was closed earlier: closing it for real");
            }
            this.close();
        }
    }

    public void close() throws MedorException {
        if (this.debug) {
            this.log.log(BasicLevel.DEBUG, (Object)("Closing TupleCollection " + this));
        }
        this.userHasClosed = true;
        if (this.prefetchBuffer == null || this.prefetchBuffer.isClosed()) {
            if (this.debug) {
                this.log.log(BasicLevel.DEBUG, (Object)("PrefetchBuffer " + this.prefetchBuffer + " is null or was closed previously: real close of the TupleCollection"));
            }
            this.prefetchBuffer = null;
            super.close();
            if (this.subResultTC != null) {
                this.subResultTC.close();
            }
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.query.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        return this.subResultTC.isLast();
    }

    public int card() throws MedorException {
        return this.cursor;
    }

    public boolean next() throws MedorException {
        boolean moved;
        if (this.subResultTC.isLast()) {
            this.cursor = -2;
            moved = false;
        } else {
            ++this.cursor;
            this.subResultTC.next();
            this.getNextResult();
            if (this.prefetchBuffer != null) {
                this.prefetchBuffer.addPrefetchTuple();
            }
            moved = true;
        }
        return moved;
    }

    private void init() throws MedorException {
        this.subResultTC.first();
        this.getNextResult();
        this.cursor = 1;
        if (this.prefetchBuffer != null) {
            this.prefetchBuffer.addPrefetchTuple();
        }
    }

    public void first() throws MedorException {
        this.init();
    }

    public int getRow() throws MedorException {
        return this.cursor;
    }

    public Tuple getTuple() throws MedorException {
        if (!this.isEmpty() && this.getRow() >= 1) {
            return this.currentBuffer;
        }
        throw new MedorException(" No elements fetched in this TupleCollection  " + this.getRow());
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        this.row(numTuple);
        return this.getTuple();
    }

    public boolean isEmpty() throws MedorException {
        return this.subResultTC.isEmpty();
    }

    public boolean row(int numTuple) throws MedorException {
        boolean go = this.subResultTC.row(numTuple);
        if (!go) {
            return false;
        }
        this.getNextResult();
        this.cursor = numTuple;
        return true;
    }

    public int getLeftTCCursor() throws MedorException {
        return this.subResultTC.getRow();
    }

    public int getRightTCCursor() throws MedorException {
        return -1;
    }

    private void getNextResult() throws MedorException {
        try {
            this.query.getTupleLoader().loadTuple(this.subResultTC.getTuple(), this.currentAttBuffers, this.parameters);
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
    }
}

