/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.rpc;

import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.server.ProtocolNotFoundException;
import org.ow2.cmi.reference.CMIReference;
import org.ow2.cmi.reference.CMIReferenceable;
import org.ow2.cmi.reference.CMIReferenceableWrapper;
import org.ow2.cmi.reference.ObjectNotFoundException;
import org.ow2.cmi.reference.ServerRef;
import org.ow2.cmi.reference.serialization.RemoteIIOPCMIReferenceableWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StubOrProxyHelper {
    private static Log logger = LogFactory.getLog(StubOrProxyHelper.class);

    private StubOrProxyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMIReferenceable<?> download(ClusterViewManager clusterViewManager, CMIReference cmiReference) throws ProtocolNotFoundException, ObjectNotFoundException, ClassCastException, NamingException {
        Object object;
        ServerRef serverRef = cmiReference.getServerRef();
        String protocol = serverRef.getProtocol();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", clusterViewManager.getInitialContextFactoryName(protocol));
        env.put("java.naming.provider.url", serverRef.getProviderURL());
        InitialContext chosenContext = new InitialContext(env);
        String bindName = cmiReference.getObjectName();
        Class<?> interfaceClass = clusterViewManager.getInterface(bindName);
        logger.debug((Object)"Lookup {0} on {1}", new Object[]{bindName, serverRef.getProviderURL()});
        try {
            object = PortableRemoteObject.narrow((Object)chosenContext.lookup(bindName), interfaceClass);
        }
        catch (Throwable throwable) {
            try {
                chosenContext.close();
            }
            catch (NamingException e) {
                logger.debug((Object)"Unable to close the context", new Object[]{e});
            }
            throw throwable;
        }
        try {
            chosenContext.close();
        }
        catch (NamingException e) {
            logger.debug((Object)"Unable to close the context", new Object[]{e});
        }
        if (protocol.equals("iiop") && object instanceof Remote) {
            return new RemoteIIOPCMIReferenceableWrapper<Remote>(cmiReference, (Remote)object);
        }
        return new CMIReferenceableWrapper<Object>(cmiReference, object);
    }
}

