/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRegistryImpl
implements ServerRegistry,
BusLifeCycleListener {
    List<Server> serversList = new ArrayList<Server>();
    Bus bus;
    BusLifeCycleManager lifeCycleManager;

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension(this, ServerRegistry.class);
            this.lifeCycleManager = this.bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener(this);
            }
        }
    }

    @Override
    public void register(Server server) {
        this.serversList.add(server);
    }

    @Override
    public void unregister(Server server) {
        this.serversList.remove(server);
    }

    @Override
    public List<Server> getServers() {
        return this.serversList;
    }

    @Override
    public void initComplete() {
    }

    @Override
    @PreDestroy
    public void preShutdown() {
        Object[] servers = this.serversList.toArray();
        for (int i = 0; i < servers.length; ++i) {
            Server server = (Server)servers[i];
            server.destroy();
        }
    }

    @Override
    public void postShutdown() {
        this.serversList.clear();
    }
}

