/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.base.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Arrays;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.base.proxy.ContextInfo;
import org.ow2.jonas.web.base.proxy.CopyingStream;
import org.ow2.jonas.web.base.proxy.HTTPResponse;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxy;
import org.ow2.jonas.web.base.proxy.HttpOnDemandProxyException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HttpSocketHandler
implements Runnable {
    private static Log logger = LogFactory.getLog(HttpSocketHandler.class);
    private static int counter = 0;
    private HttpOnDemandProxy onDemandProxy = null;
    private Socket clientSocket = null;
    private InputStream clientInputStream = null;
    private OutputStream clientOutputStream = null;
    private OutputStream remoteOutputStream = null;
    private InputStream remoteInputStream = null;
    private boolean webContainerStartRequested = false;

    public HttpSocketHandler(HttpOnDemandProxy onDemandProxy, Socket clientSocket) throws HttpOnDemandProxyException {
        this.onDemandProxy = onDemandProxy;
        this.clientSocket = clientSocket;
        try {
            this.clientInputStream = clientSocket.getInputStream();
        }
        catch (IOException e) {
            throw new HttpOnDemandProxyException("Cannot get input stream", e);
        }
        try {
            this.clientOutputStream = clientSocket.getOutputStream();
        }
        catch (IOException e) {
            throw new HttpOnDemandProxyException("Cannot get output stream", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeRequest() throws HttpOnDemandProxyException {
        Socket remoteServerSocket;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean requestFound = false;
        byte[] buffer = new byte[128];
        String firstLine = null;
        try {
            int bytesRead;
            while (!requestFound && (bytesRead = this.clientInputStream.read(buffer)) > 0) {
                String line = new String(buffer);
                String[] splitLines = line.split("\r\n");
                byteArrayOutputStream.write(buffer, 0, bytesRead);
                if (splitLines.length < 1) continue;
                firstLine = splitLines[0];
                logger.debug((Object)"Request is: ''{0}''", new Object[]{firstLine});
                requestFound = true;
            }
        }
        catch (IOException e) {
            this.cleanup("Unable to handle request", e);
            throw new ServiceException("Unable to handle request", (Throwable)e);
        }
        if (firstLine == null || !requestFound) {
            this.cleanup("Invalid header");
            return;
        }
        String[] args = firstLine.split(" ");
        String contextValue = null;
        String askedURL = null;
        if (args.length > 1 && (askedURL = args[1]).startsWith("/")) {
            int index = askedURL.substring(1).indexOf("/");
            contextValue = index == -1 ? askedURL.substring(1) : askedURL.substring(1, index + 1);
        }
        if (contextValue == null) {
            logger.warn((Object)"Unable to find context in the given request ''{0}''", new Object[]{firstLine});
        }
        if ("jonasOnDemandProxy".equals(contextValue)) {
            if ("/jonasOnDemandProxy/wait.gif".equals(askedURL)) {
                this.sendWaitGif();
            }
            return;
        }
        if (!this.onDemandProxy.getWebContainerService().isInternalContainerStarted()) {
            this.webContainerIsStarting();
            HttpSocketHandler index = this;
            synchronized (index) {
                if (!this.webContainerStartRequested) {
                    this.webContainerStartRequested = true;
                    this.startWebContainer();
                }
            }
            return;
        }
        if (contextValue != null) {
            logger.debug((Object)"Extracted context ''{0}'' from the line", new Object[]{contextValue, firstLine});
            if (this.onDemandProxy.isAvailableContext(contextValue) && !this.onDemandProxy.isContextDeployed(contextValue)) {
                ContextInfo contextInfo = this.onDemandProxy.getContextInfo(contextValue);
                boolean startApplication = false;
                if (!contextInfo.isStarting()) {
                    startApplication = true;
                    contextInfo.setStarting(true);
                }
                this.contextIsStarting(contextValue);
                if (startApplication) {
                    String warFile = contextInfo.getWarFile();
                    try {
                        this.onDemandProxy.getWebContainerService().registerWar(warFile);
                    }
                    catch (RemoteException e) {
                        this.cleanup("Unable to deploy application '" + warFile + "'.", e);
                    }
                }
                return;
            }
        }
        try {
            remoteServerSocket = new Socket(this.onDemandProxy.getServerSocket().getInetAddress(), this.onDemandProxy.getRedirectPortNumber());
        }
        catch (IOException e) {
            this.cleanup("Unable to connect to the remote host '" + this.onDemandProxy.getServerSocket().getInetAddress() + "' on the port number '" + this.onDemandProxy.getRedirectPortNumber() + "'", e);
            return;
        }
        try {
            this.remoteOutputStream = remoteServerSocket.getOutputStream();
        }
        catch (IOException e) {
            this.cleanup("Unable to get remote stream of server socket '" + remoteServerSocket + "'", e);
            return;
        }
        try {
            this.remoteInputStream = remoteServerSocket.getInputStream();
        }
        catch (IOException e) {
            this.cleanup("Unable to get remote stream of server socket '" + remoteServerSocket + "'", e);
            return;
        }
        CopyingStream t = new CopyingStream(this, byteArrayOutputStream, this.clientInputStream, this.remoteOutputStream);
        t.setName(t.getClass().getName() + "-" + counter++);
        t.start();
        byte[] buf = new byte[1024];
        try {
            int count;
            while ((count = this.remoteInputStream.read(buf)) > 0) {
                this.clientOutputStream.write(buf, 0, count);
            }
        }
        catch (Exception e) {
            this.cleanup("Unable to handle data from server to the client", e);
            return;
        }
        this.cleanup();
    }

    public void cleanup() {
        try {
            if (this.clientInputStream != null) {
                this.clientInputStream.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close stream", new Object[]{e});
        }
        try {
            if (this.clientOutputStream != null) {
                this.clientOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close stream", new Object[]{e});
        }
        try {
            if (this.remoteOutputStream != null) {
                this.remoteOutputStream.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close stream", new Object[]{e});
        }
        try {
            if (this.remoteInputStream != null) {
                this.remoteInputStream.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close stream", new Object[]{e});
        }
        try {
            this.clientSocket.close();
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close socket", new Object[]{e});
        }
    }

    public void cleanup(String message) {
        this.cleanup(message, null);
    }

    public void cleanup(String message, Exception exception) {
        HTTPResponse httpResponse = new HTTPResponse("HTTP/1.0 500");
        httpResponse.println(message);
        httpResponse.println("<br>");
        if (exception != null) {
            httpResponse.println(Arrays.asList(exception.getStackTrace()).toString());
        }
        this.sendBytesToClient(httpResponse);
    }

    protected void sendBytesToClient(HTTPResponse httpResponse) {
        try {
            this.clientOutputStream.write(httpResponse.getContent());
            this.clientOutputStream.flush();
        }
        catch (IOException ioe) {
            logger.debug((Object)"Unable to send error message. Stream may be already closed.", new Object[]{ioe});
        }
        try {
            this.clientSocket.shutdownOutput();
        }
        catch (IOException e) {
            logger.debug((Object)"Unable to close the socket", new Object[]{e});
        }
    }

    protected void startWebContainer() {
        this.onDemandProxy.startWebContainer();
    }

    protected void webContainerIsStarting() {
        HTTPResponse httpResponse = new HTTPResponse();
        httpResponse.setRefresh(true);
        String txt = "The HTTP Web Container is starting. Please wait.";
        httpResponse.setTitle(txt);
        txt = "<image src='/jonasOnDemandProxy/wait.gif'><br/><br/>" + txt;
        httpResponse.print(txt);
        this.sendBytesToClient(httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendWaitGif() {
        String waitGifResource = "/" + HttpSocketHandler.class.getPackage().getName().replace(".", "/") + "/wait.gif";
        InputStream is = null;
        HTTPResponse httpResponse = new HTTPResponse();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            is = HttpSocketHandler.class.getClassLoader().getResourceAsStream(waitGifResource);
            httpResponse.setContentType("image/gif");
            httpResponse.setRefresh(true);
            byte[] buf = new byte[1024];
            try {
                int count;
                while ((count = is.read(buf)) > 0) {
                    baos.write(buf, 0, count);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Cannot get data", new Object[]{e});
            }
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.debug((Object)"unable to close", new Object[]{e});
            }
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            logger.debug((Object)"unable to close", new Object[]{e});
        }
        httpResponse.setBodyBytes(baos.toByteArray());
        this.sendBytesToClient(httpResponse);
    }

    protected void contextIsStarting(String contextName) {
        HTTPResponse httpResponse = new HTTPResponse();
        httpResponse.setRefresh(true);
        String txt = "The .war file associated with the context '/" + contextName + "' is loading. Please wait.";
        httpResponse.setTitle(txt);
        txt = "<image src='/jonasOnDemandProxy/wait.gif'><br/><br/>" + txt;
        httpResponse.print(txt);
        this.sendBytesToClient(httpResponse);
    }

    public void run() {
        try {
            this.analyzeRequest();
        }
        catch (HttpOnDemandProxyException e) {
            logger.error((Object)"Unable to handle request", new Object[]{e});
        }
    }
}

