/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.Stack;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;

public class XMLTransformationRecord
extends DOMRecord {
    private UnmarshalRecord owningRecord;
    private NamespaceResolver resolver;

    public XMLTransformationRecord(UnmarshalRecord owner) {
        this.owningRecord = owner;
        this.initializeNamespaceMaps();
    }

    public XMLTransformationRecord(String rootName, UnmarshalRecord owner) {
        super(rootName);
        this.owningRecord = owner;
        this.session = owner.getSession();
        this.resolver = new NamespaceResolver();
        this.initializeNamespaceMaps();
    }

    public String resolveNamespacePrefix(String prefix) {
        return this.resolver.resolveNamespacePrefix(prefix);
    }

    public void initializeNamespaceMaps() {
        UnmarshalRecord next;
        Stack<UnmarshalRecord> records = new Stack<UnmarshalRecord>();
        for (next = this.owningRecord; next != null; next = next.getParentRecord()) {
            records.push(next);
        }
        for (int i = 0; i < records.size(); ++i) {
            next = (UnmarshalRecord)records.pop();
            if (next.getNamespaceMap() == null) continue;
            for (String prefix : next.getNamespaceMap().keySet()) {
                Stack uriStack = (Stack)next.getNamespaceMap().get(prefix);
                if (uriStack.size() <= 0) continue;
                this.resolver.put(prefix, (String)uriStack.peek());
            }
        }
    }
}

