/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.common.Debug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.objectweb.joram.mom.dest.QueueImpl;
import org.objectweb.joram.mom.messages.MessageJMXWrapper;
import org.objectweb.joram.mom.proxies.ClientSubscriptionMBean;
import org.objectweb.joram.mom.proxies.ProxyAgentItf;
import org.objectweb.joram.mom.util.DMQManager;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.joram.shared.selectors.Selector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

class ClientSubscription
implements ClientSubscriptionMBean,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)ClientSubscription.class.getName());
    private AgentId proxyId;
    private boolean durable;
    private AgentId topicId;
    private String name;
    private String selector;
    private AgentId dmqId;
    private int threshold = -1;
    protected int nbMaxMsg = -1;
    private List messageIds;
    private Map deliveredIds;
    private Map deniedMsgs;
    private transient int contextId;
    private transient int subRequestId;
    private transient boolean noLocal;
    private transient boolean noFiltering;
    private transient boolean active;
    private transient int requestId;
    private transient boolean toListener;
    private transient long requestExpTime;
    private transient Map messagesTable;
    private transient ProxyAgentItf proxy;
    protected long nbMsgsSentToDMQSinceCreation = 0L;
    protected long nbMsgsDeliveredSinceCreation = 0L;

    ClientSubscription(AgentId proxyId, int contextId, int reqId, boolean durable, AgentId topicId, String name, String selector, boolean noLocal, AgentId dmqId, int threshold, int nbMaxMsg, Map messagesTable) {
        this.proxyId = proxyId;
        this.contextId = contextId;
        this.subRequestId = reqId;
        this.durable = durable;
        this.topicId = topicId;
        this.name = name;
        this.selector = selector;
        this.noLocal = noLocal;
        this.dmqId = dmqId;
        this.threshold = threshold;
        this.nbMaxMsg = nbMaxMsg;
        this.messagesTable = messagesTable;
        this.messageIds = new Vector();
        this.deliveredIds = new Hashtable();
        this.deniedMsgs = new Hashtable();
        this.noFiltering = !noLocal && (selector == null || selector.equals(""));
        this.active = true;
        this.requestId = -1;
        this.toListener = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": created."));
        }
    }

    public String toString() {
        return "ClientSubscription" + this.proxyId + this.name;
    }

    public int getContextId() {
        return this.contextId;
    }

    public int getSubRequestId() {
        return this.subRequestId;
    }

    public String getName() {
        return this.name;
    }

    public AgentId getTopicId() {
        return this.topicId;
    }

    public String getTopicIdAsString() {
        return this.topicId.toString();
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean getDurable() {
        return this.durable;
    }

    public boolean getActive() {
        return this.active;
    }

    public int getNbMaxMsg() {
        return this.nbMaxMsg;
    }

    public void setNbMaxMsg(int nbMaxMsg) {
        this.nbMaxMsg = nbMaxMsg;
    }

    public int getPendingMessageCount() {
        return this.messageIds.size();
    }

    public String[] getMessageIds() {
        String[] res = new String[this.messageIds.size()];
        this.messageIds.toArray(res);
        return res;
    }

    void setProxyAgent(ProxyAgentItf px) {
        this.proxy = px;
    }

    void reinitialize(Map messagesTable, List persistedMessages, boolean denyDeliveredMessages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this + "].reinitialize()"));
        }
        this.messagesTable = messagesTable;
        for (org.objectweb.joram.mom.messages.Message message : persistedMessages) {
            String msgId = message.getIdentifier();
            if (!this.messageIds.contains(msgId) && !this.deliveredIds.containsKey(msgId)) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> contains message " + msgId));
            }
            ++message.acksCounter;
            ++message.durableAcksCounter;
            if (message.acksCounter != 1) continue;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> messagesTable.put(" + msgId + ')'));
            }
            messagesTable.put(msgId, message);
        }
        if (denyDeliveredMessages) {
            this.deny(this.deliveredIds.keySet().iterator(), false);
            this.deliveredIds.clear();
        }
    }

    void reactivate(int contextId, int reqId, AgentId topicId, String selector, boolean noLocal) {
        this.contextId = contextId;
        this.subRequestId = reqId;
        this.topicId = topicId;
        this.selector = selector;
        this.noLocal = noLocal;
        this.noFiltering = !noLocal && (selector == null || selector.equals(""));
        this.active = true;
        this.requestId = -1;
        this.toListener = false;
        this.save();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": reactivated."));
        }
    }

    void deactivate() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"ClientSubscription.deactivate()");
        }
        this.unsetListener();
        this.unsetReceiver();
        this.active = false;
        this.deny(this.deliveredIds.keySet().iterator(), false);
        this.deliveredIds.clear();
        this.save();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": deactivated."));
        }
    }

    void setActive(boolean active) {
        this.active = active;
    }

    void setListener(int requestId) {
        this.requestId = requestId;
        this.toListener = true;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": listener set."));
        }
    }

    void unsetListener() {
        this.requestId = -1;
        this.toListener = false;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": listener unset."));
        }
    }

    void setReceiver(int requestId, long timeToLive) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".setReceiver(" + requestId + "," + timeToLive + ")"));
        }
        this.requestId = requestId;
        this.toListener = false;
        this.requestExpTime = timeToLive > 0L ? System.currentTimeMillis() + timeToLive : 0L;
    }

    void unsetReceiver() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".unsetReceiver()"));
        }
        this.requestId = -1;
        this.requestExpTime = 0L;
    }

    void setDMQId(AgentId dmqId) {
        this.dmqId = dmqId;
        this.save();
    }

    void setThreshold(int threshold) {
        this.threshold = threshold;
        this.save();
    }

    void browseNewMessages(List newMessages) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".browseNewMessages(" + newMessages + ')'));
        }
        DMQManager dmqManager = null;
        for (org.objectweb.joram.mom.messages.Message message : newMessages) {
            String msgId = message.getIdentifier();
            if (this.nbMaxMsg > 0 && this.nbMaxMsg <= this.messageIds.size()) {
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, null);
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)5);
                continue;
            }
            if (!this.noFiltering && (!Selector.matches((Message)message.getHeaderMessage(), (String)this.selector) || this.noLocal && msgId.startsWith(this.proxyId.toString().substring(1) + "c" + this.contextId + "m", 3))) continue;
            if (message.acksCounter == 0) {
                this.messagesTable.put(msgId, message);
            }
            ++message.acksCounter;
            if (this.durable) {
                ++message.durableAcksCounter;
            }
            this.messageIds.add(msgId);
            this.save();
            if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
            logger.log(BasicLevel.DEBUG, (Object)(this + ": added msg " + msgId + " for delivery."));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    ConsumerMessages deliver() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + ',' + this.topicId + ',' + this.name + "].deliver()"));
        }
        if (this.requestId == -1) {
            return null;
        }
        if (!this.toListener && this.requestExpTime > 0L && System.currentTimeMillis() >= this.requestExpTime) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ": receive request " + this.requestId + " expired."));
            }
            this.requestId = -1;
            this.requestExpTime = 0L;
            return null;
        }
        Integer deliveryAttempts = null;
        int lastPrior = -1;
        int insertionIndex = -1;
        Vector<Object> deliverables = new Vector<Object>();
        DMQManager dmqManager = null;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> messageIds.size() = " + this.messageIds.size()));
        }
        if (this.toListener) {
            while (!this.messageIds.isEmpty()) {
                String id = (String)this.messageIds.remove(0);
                this.save();
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(id);
                if (message != null) {
                    if (message.isValid(System.currentTimeMillis())) {
                        this.deliveredIds.put(id, id);
                        deliveryAttempts = (Integer)this.deniedMsgs.get(id);
                        if (deliveryAttempts == null) {
                            message.setDeliveryCount(1);
                        } else {
                            message.setDeliveryCount(deliveryAttempts + 1);
                            message.setRedelivered();
                        }
                        if (lastPrior == -1 || message.getPriority() == lastPrior) {
                            ++insertionIndex;
                        } else {
                            int prior;
                            for (insertionIndex = 0; insertionIndex < deliverables.size() && (prior = ((org.objectweb.joram.mom.messages.Message)deliverables.get(insertionIndex)).getPriority()) >= message.getPriority(); ++insertionIndex) {
                            }
                        }
                        lastPrior = message.getPriority();
                        deliverables.add(insertionIndex, message.getFullMessage().clone());
                        if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                        logger.log(BasicLevel.DEBUG, (Object)(this + ": message " + id + " added for delivery."));
                        continue;
                    }
                    this.messagesTable.remove(id);
                    if (this.durable) {
                        message.delete();
                    }
                    if ((deliveryAttempts = (Integer)this.deniedMsgs.remove(id)) != null) {
                        message.setDeliveryCount(deliveryAttempts + 1);
                        message.setRedelivered();
                    }
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, null);
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                    continue;
                }
                this.deniedMsgs.remove(id);
            }
        } else {
            int highestP = -1;
            org.objectweb.joram.mom.messages.Message keptMsg = null;
            int i = 0;
            while (i < this.messageIds.size()) {
                String id = (String)this.messageIds.get(i);
                org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(id);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(" -> message = " + message));
                }
                if (message != null) {
                    if (message.isValid(System.currentTimeMillis())) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)" -> valid message");
                        }
                        if (message.getPriority() > highestP) {
                            highestP = message.getPriority();
                            keptMsg = message;
                        }
                        ++i;
                        continue;
                    }
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)" -> invalid message");
                    }
                    this.messageIds.remove(id);
                    this.save();
                    this.messagesTable.remove(id);
                    if (this.durable) {
                        message.delete();
                    }
                    if ((deliveryAttempts = (Integer)this.deniedMsgs.remove(id)) != null) {
                        message.setDeliveryCount(deliveryAttempts);
                        message.setRedelivered();
                    }
                    if (dmqManager == null) {
                        dmqManager = new DMQManager(this.dmqId, null);
                    }
                    ++this.nbMsgsSentToDMQSinceCreation;
                    dmqManager.addDeadMessage(message.getFullMessage(), (short)0);
                    continue;
                }
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)" -> deleted message");
                }
                this.messageIds.remove(id);
                this.deniedMsgs.remove(id);
                this.save();
            }
            if (keptMsg != null) {
                this.messageIds.remove(keptMsg.getIdentifier());
                this.deliveredIds.put(keptMsg.getIdentifier(), keptMsg.getIdentifier());
                this.save();
                deliveryAttempts = (Integer)this.deniedMsgs.get(keptMsg.getIdentifier());
                if (deliveryAttempts == null) {
                    keptMsg.setDeliveryCount(1);
                } else {
                    keptMsg.setDeliveryCount(deliveryAttempts + 1);
                    keptMsg.setRedelivered();
                }
                deliverables.add(keptMsg.getFullMessage().clone());
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)(this + ": message " + keptMsg.getIdentifier() + " added for delivery."));
                }
            } else {
                ++i;
            }
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        if (!deliverables.isEmpty()) {
            this.nbMsgsDeliveredSinceCreation += (long)deliverables.size();
            ConsumerMessages consM = new ConsumerMessages(this.requestId, deliverables, this.name, false);
            if (!this.toListener) {
                this.requestId = -1;
            }
            return consM;
        }
        return null;
    }

    void acknowledge(Iterator acks) {
        while (acks.hasNext()) {
            String id = (String)acks.next();
            this.acknowledge(id);
        }
    }

    void acknowledge(String id) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ": acknowledges message: " + id));
        }
        this.deliveredIds.remove(id);
        this.deniedMsgs.remove(id);
        this.save();
        org.objectweb.joram.mom.messages.Message msg = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(id);
        if (msg != null) {
            this.decrAckCounters(id, msg);
        }
    }

    void deny(Iterator denies) {
        this.deny(denies, true);
    }

    private void deny(Iterator denies, boolean remove) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + ".deny(" + denies + ')'));
        }
        int deliveryAttempts = 1;
        DMQManager dmqManager = null;
        while (denies.hasNext()) {
            org.objectweb.joram.mom.messages.Message message;
            String deliveredMsgId;
            String id = (String)denies.next();
            if (remove && (deliveredMsgId = (String)this.deliveredIds.remove(id)) == null) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                logger.log(BasicLevel.DEBUG, (Object)(this + ": cannot deny message: " + id));
                continue;
            }
            this.save();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + ": deny message: " + id));
            }
            if ((message = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(id)) == null) continue;
            Integer value = (Integer)this.deniedMsgs.get(id);
            if (value != null) {
                deliveryAttempts = value + 1;
            }
            if (this.isUndeliverable(deliveryAttempts)) {
                this.deniedMsgs.remove(id);
                message.setDeliveryCount(deliveryAttempts);
                if (dmqManager == null) {
                    dmqManager = new DMQManager(this.dmqId, null);
                }
                ++this.nbMsgsSentToDMQSinceCreation;
                dmqManager.addDeadMessage(message.getFullMessage(), (short)2);
                this.decrAckCounters(id, message);
                continue;
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> put back to the messages to deliver");
            }
            int i = 0;
            while (i < this.messageIds.size()) {
                String currentId = (String)this.messageIds.get(i);
                org.objectweb.joram.mom.messages.Message currentMessage = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(currentId);
                if (currentMessage != null) {
                    long currentO = currentMessage.order;
                    if (currentO > message.order) break;
                    ++i;
                    continue;
                }
                this.messageIds.remove(i);
            }
            this.messageIds.add(i, id);
            this.deniedMsgs.put(id, new Integer(deliveryAttempts));
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
    }

    void delete() {
        this.messageIds.addAll(this.deliveredIds.keySet());
        Iterator allMessageIds = this.messageIds.iterator();
        while (allMessageIds.hasNext()) {
            this.removeMessage((String)allMessageIds.next());
        }
    }

    private boolean isUndeliverable(int deliveryAttempts) {
        if (this.threshold == 0) {
            return false;
        }
        if (this.threshold > 0) {
            return deliveryAttempts >= this.threshold;
        }
        if (QueueImpl.getDefaultThreshold() > 0) {
            return deliveryAttempts >= QueueImpl.getDefaultThreshold();
        }
        return false;
    }

    public long getNbMsgsSentToDMQSinceCreation() {
        return this.nbMsgsSentToDMQSinceCreation;
    }

    public long getNbMsgsDeliveredSinceCreation() {
        return this.nbMsgsDeliveredSinceCreation;
    }

    org.objectweb.joram.mom.messages.Message getSubscriptionMessage(String msgId) {
        int index;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription.getSubscriptionMessage(" + msgId + ')'));
        }
        if ((index = this.messageIds.indexOf(msgId)) < 0) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> message not found");
            }
            return null;
        }
        return (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(msgId);
    }

    public CompositeData getMessage(String msgId) throws Exception {
        org.objectweb.joram.mom.messages.Message msg = this.getSubscriptionMessage(msgId);
        if (msg == null) {
            return null;
        }
        return MessageJMXWrapper.createCompositeDataSupport(msg);
    }

    public TabularData getMessages() throws Exception {
        return MessageJMXWrapper.createTabularDataSupport(this.messagesTable, this.messageIds);
    }

    public List getMessagesView() {
        ArrayList messages = new ArrayList();
        for (int i = 0; i < this.messageIds.size(); ++i) {
            messages.add(this.messagesTable.get(this.messageIds.get(i)));
        }
        return messages;
    }

    public void deleteMessage(String msgId) {
        this.messageIds.remove(msgId);
        org.objectweb.joram.mom.messages.Message message = this.removeMessage(msgId);
        this.save();
        if (message != null) {
            DMQManager dmqManager = new DMQManager(this.dmqId, null);
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
            dmqManager.sendToDMQ();
        }
    }

    public void clear() {
        DMQManager dmqManager = null;
        for (int i = 0; i < this.messageIds.size(); ++i) {
            String msgId = (String)this.messageIds.get(i);
            org.objectweb.joram.mom.messages.Message message = this.removeMessage(msgId);
            if (message == null) continue;
            if (dmqManager == null) {
                dmqManager = new DMQManager(this.dmqId, null);
            }
            ++this.nbMsgsSentToDMQSinceCreation;
            dmqManager.addDeadMessage(message.getFullMessage(), (short)3);
        }
        if (dmqManager != null) {
            dmqManager.sendToDMQ();
        }
        this.messageIds.clear();
        this.save();
    }

    org.objectweb.joram.mom.messages.Message removeMessage(String msgId) {
        org.objectweb.joram.mom.messages.Message message = (org.objectweb.joram.mom.messages.Message)this.messagesTable.get(msgId);
        if (message != null) {
            this.decrAckCounters(msgId, message);
        }
        return message;
    }

    private void decrAckCounters(String msgId, org.objectweb.joram.mom.messages.Message message) {
        --message.acksCounter;
        if (message.acksCounter == 0) {
            this.messagesTable.remove(msgId);
        }
        if (this.durable) {
            --message.durableAcksCounter;
            if (message.durableAcksCounter == 0) {
                message.delete();
            }
        }
    }

    private void save() {
        if (this.durable) {
            this.proxy.setSave();
        }
    }

    public void readBag(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + "].readbag()"));
        }
        this.contextId = in.readInt();
        this.subRequestId = in.readInt();
        this.noLocal = in.readBoolean();
        this.noFiltering = in.readBoolean();
        this.active = in.readBoolean();
        this.requestId = in.readInt();
        this.toListener = in.readBoolean();
        this.requestExpTime = in.readLong();
    }

    public void writeBag(ObjectOutputStream out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ClientSubscription[" + this.proxyId + "].writeBag()"));
        }
        out.writeInt(this.contextId);
        out.writeInt(this.subRequestId);
        out.writeBoolean(this.noLocal);
        out.writeBoolean(this.noFiltering);
        out.writeBoolean(this.active);
        out.writeInt(this.requestId);
        out.writeBoolean(this.toListener);
        out.writeLong(this.requestExpTime);
    }

    void cleanMessageIds() {
        this.messageIds.retainAll(this.messagesTable.keySet());
    }
}

