/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpProtocol
extends AbstractAjpProtocol {
    private static final Log log = LogFactory.getLog(AjpProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpProtocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
    }

    @Override
    public void init() throws Exception {
        this.endpoint.setName(this.getName());
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        try {
            this.endpoint.init();
        }
        catch (Exception ex) {
            log.error(sm.getString("ajpprotocol.endpoint.initerror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("ajpprotocol.init", this.getName()));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this.endpoint, this.tpOname, null);
            }
            catch (Exception e) {
                log.error("Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        try {
            this.endpoint.start();
        }
        catch (Exception ex) {
            log.error(sm.getString("ajpprotocol.endpoint.starterror"), ex);
            throw ex;
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("ajpprotocol.start", this.getName()));
        }
    }

    protected static class AjpConnectionHandler
    implements JIoEndpoint.Handler {
        protected AjpProtocol proto;
        protected AtomicLong registerCount = new AtomicLong(0L);
        protected RequestGroupInfo global = new RequestGroupInfo();
        protected ConcurrentHashMap<SocketWrapper<Socket>, AjpProcessor> connections = new ConcurrentHashMap();
        protected ConcurrentLinkedQueue<AjpProcessor> recycledProcessors = new ConcurrentLinkedQueue<AjpProcessor>(){
            private static final long serialVersionUID = 1L;
            protected AtomicInteger size = new AtomicInteger(0);

            @Override
            public boolean offer(AjpProcessor processor) {
                boolean offer = AjpConnectionHandler.this.proto.processorCache == -1 ? true : this.size.get() < AjpConnectionHandler.this.proto.processorCache;
                boolean result = false;
                if (offer && (result = super.offer(processor))) {
                    this.size.incrementAndGet();
                }
                if (!result) {
                    AjpConnectionHandler.this.unregister(processor);
                }
                return result;
            }

            @Override
            public AjpProcessor poll() {
                AjpProcessor result = (AjpProcessor)super.poll();
                if (result != null) {
                    this.size.decrementAndGet();
                }
                return result;
            }

            @Override
            public void clear() {
                AjpProcessor next = this.poll();
                while (next != null) {
                    AjpConnectionHandler.this.unregister(next);
                    next = this.poll();
                }
                super.clear();
                this.size.set(0);
            }
        };

        public AjpConnectionHandler(AjpProtocol proto) {
            this.proto = proto;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) {
            return this.process(socket, SocketStatus.OPEN);
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            AjpProcessor processor = this.connections.remove(socket);
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                AbstractEndpoint.Handler.SocketState socketState = state = socket.isAsync() ? processor.asyncDispatch(status) : processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                    return processor.asyncPostProcess();
                }
                this.connections.remove(socket);
                socket.setAsync(false);
                this.recycledProcessors.offer(processor);
                return state;
            }
            catch (SocketException e) {
                log.debug(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.socketexception.debug"), e);
            }
            catch (IOException e) {
                log.debug(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.ioexception.debug"), e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error(AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
            }
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected AjpProcessor createProcessor() {
            AjpProcessor processor = new AjpProcessor(this.proto.packetSize, (JIoEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setKeepAliveTimeout(this.proto.keepAliveTimeout);
            this.register(processor);
            return processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void register(AjpProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        long count = this.registerCount.incrementAndGet();
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(this.global);
                        ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=AjpRequest" + count);
                        if (log.isDebugEnabled()) {
                            log.debug("Register " + rpName);
                        }
                        Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                        rp.setRpName(rpName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering request");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void unregister(AjpProcessor processor) {
            if (this.proto.getDomain() != null) {
                AjpConnectionHandler ajpConnectionHandler = this;
                synchronized (ajpConnectionHandler) {
                    try {
                        RequestInfo rp = processor.getRequest().getRequestProcessor();
                        rp.setGlobalProcessor(null);
                        ObjectName rpName = rp.getRpName();
                        if (log.isDebugEnabled()) {
                            log.debug("Unregister " + rpName);
                        }
                        Registry.getRegistry(null, null).unregisterComponent(rpName);
                        rp.setRpName(null);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering request", e);
                    }
                }
            }
        }
    }
}

