/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.discovery.internal.comm;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.discovery.base.DuplicateServerNameException;
import org.ow2.jonas.discovery.base.comm.DiscGreeting;
import org.ow2.jonas.discovery.base.comm.DiscMessage;
import org.ow2.jonas.discovery.internal.comm.DiscoveryComm;
import org.ow2.jonas.discovery.internal.manager.DiscoveryManager;
import org.ow2.jonas.discovery.internal.utils.DiscoveryHelper;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.lib.util.NetUtils;
import org.ow2.jonas.service.ServiceException;

public class DiscoveryGreetingResponder
extends DiscoveryComm {
    protected DatagramSocket recvUnicastSocket;
    protected int greetingPort;
    protected int greetingTimeOut;
    private DiscGreeting greeting = null;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.discovery");

    public DiscoveryGreetingResponder(DiscoveryManager dm) {
        super(dm);
        this.greetingPort = dm.getGreetingListeningPort();
        this.greetingTimeOut = dm.getGreetingAckTimeOut();
    }

    protected DiscGreeting createDiscGreeting(boolean startup) {
        String theHostAddress;
        try {
            theHostAddress = NetUtils.getLocalAddress();
        }
        catch (UnknownHostException e) {
            logger.log(BasicLevel.ERROR, (Object)"Unknown host", (Throwable)e);
            return null;
        }
        return new DiscGreeting(theHostAddress, this.greetingPort, this.jonasName, this.domainName, startup, this.serverId);
    }

    private void handleReceivedMessage(DiscGreeting msg) throws DuplicateServerNameException {
        if (logger.isLoggable(BasicLevel.ERROR)) {
            logger.log(BasicLevel.ERROR, (Object)("A server with the given name already exists in the domain, received a rejection message: " + msg));
        }
        this.stop();
    }

    public void run() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Sending the greeting.");
        }
        if (this.greeting != null) {
            this.sendNotif((DiscMessage)this.greeting);
        }
    }

    public void handleGreeting() throws DuplicateServerNameException {
        this.join();
        this.greeting = this.createDiscGreeting(true);
        try {
            this.recvUnicastSocket = new DatagramSocket(this.greetingPort);
        }
        catch (SocketException e2) {
            logger.log(BasicLevel.ERROR, (Object)"DiscComm : Unable to create a Datagram socket", (Throwable)e2);
            throw new ServiceException("Unable to create a datagram socket on port " + this.greetingPort + " to listen for rejections. Port is still in use.");
        }
        try {
            this.recvUnicastSocket.setSoTimeout(this.greetingTimeOut);
            long lastTime = (long)this.greetingTimeOut + System.currentTimeMillis();
            Thread sender = new Thread((Runnable)this, "greeting sender");
            boolean msgSent = false;
            while (this.notStopped && System.currentTimeMillis() <= lastTime) {
                if (!msgSent) {
                    sender.start();
                    msgSent = true;
                }
                DatagramPacket datagram = null;
                Object objReceived = null;
                try {
                    datagram = this.getDatagram(1024);
                    this.recvUnicastSocket.receive(datagram);
                    objReceived = DiscoveryHelper.bytesToObject((byte[])datagram.getData());
                }
                catch (IOException e) {
                    if (e instanceof SocketTimeoutException) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("No rejections received within the set timeout period: " + this.greetingTimeOut + " ms. Assuming the server ID used is unique in the domain." + " The timeout period can be changed under jonas.properties:" + " jonas.service.discovery.greeting.timeout"));
                        }
                    } else {
                        logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                        objReceived = null;
                    }
                }
                catch (RuntimeException e) {
                    logger.log(BasicLevel.DEBUG, (Object)("Host received other packet than DataGramSocket packet. That caused following Exception: \n" + e));
                    objReceived = null;
                }
                if (objReceived != null && objReceived instanceof DiscGreeting) {
                    DiscGreeting greet = (DiscGreeting)objReceived;
                    greet.setSourceAddress(datagram.getAddress().getHostAddress());
                    this.handleReceivedMessage(greet);
                }
                datagram = null;
            }
        }
        catch (SocketException e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryGreetingResponder : Socket closed", (Throwable)e);
            this.notStopped = false;
        }
        catch (ClassNotFoundException e) {
            logger.log(BasicLevel.ERROR, (Object)"DiscoveryGreetingResponder ClassNotFoundException ", (Throwable)e);
        }
    }

    public void stop() {
        throw new DuplicateServerNameException();
    }
}

