/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.gui.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.felix.shell.gui.Plugin;
import org.apache.felix.shell.gui.impl.Activator;

public class ShellPanel
extends JPanel
implements PropertyChangeListener {
    private Activator m_activator = null;
    private JPanel m_emptyPanel = null;
    private JList m_pluginList = null;
    private Plugin m_selectedPlugin = null;
    private Runnable m_runnable = null;

    public ShellPanel(Activator activator) {
        this.m_activator = activator;
        this.m_activator.addPropertyChangeListener(this);
        this.setLayout(new BorderLayout());
        JScrollPane scroll = null;
        this.m_pluginList = new JList(new SimpleListModel());
        scroll = new JScrollPane(this.m_pluginList);
        this.add((Component)scroll, "West");
        scroll.setPreferredSize(new Dimension(150, scroll.getPreferredSize().height));
        this.m_emptyPanel = new JPanel();
        this.add((Component)this.m_emptyPanel, "Center");
        this.createEventListeners();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("pluginList")) {
            if (this.m_runnable == null) {
                this.m_runnable = new PropertyChangeRunnable();
            }
            SwingUtilities.invokeLater(this.m_runnable);
        }
    }

    private void createEventListeners() {
        this.m_pluginList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && ShellPanel.this.m_pluginList.getSelectedIndex() >= 0) {
                    if (ShellPanel.this.m_selectedPlugin != null) {
                        ShellPanel.this.remove(ShellPanel.this.m_selectedPlugin.getGUI());
                    } else {
                        ShellPanel.this.remove(ShellPanel.this.m_emptyPanel);
                    }
                    ShellPanel.this.m_selectedPlugin = ShellPanel.this.m_activator.getPlugin(ShellPanel.this.m_pluginList.getSelectedIndex());
                    if (ShellPanel.this.m_selectedPlugin != null) {
                        ShellPanel.this.add(ShellPanel.this.m_selectedPlugin.getGUI(), "Center");
                    } else {
                        ShellPanel.this.add((Component)ShellPanel.this.m_emptyPanel, "Center");
                    }
                    ShellPanel.this.revalidate();
                    ShellPanel.this.repaint();
                }
            }
        });
    }

    private class PropertyChangeRunnable
    implements Runnable {
        private PropertyChangeRunnable() {
        }

        public void run() {
            ((SimpleListModel)ShellPanel.this.m_pluginList.getModel()).update();
            if (ShellPanel.this.m_selectedPlugin != null && !ShellPanel.this.m_activator.pluginExists(ShellPanel.this.m_selectedPlugin)) {
                ShellPanel.this.m_pluginList.clearSelection();
                ShellPanel.this.remove(ShellPanel.this.m_selectedPlugin.getGUI());
                ShellPanel.this.m_selectedPlugin = null;
                ShellPanel.this.add((Component)ShellPanel.this.m_emptyPanel, "Center");
                ShellPanel.this.revalidate();
                ShellPanel.this.repaint();
            }
            if (ShellPanel.this.m_selectedPlugin == null && ShellPanel.this.m_activator.getPluginCount() > 0) {
                ShellPanel.this.m_pluginList.setSelectedIndex(0);
            }
        }
    }

    private class SimpleListModel
    extends AbstractListModel
    implements ListDataListener {
        private SimpleListModel() {
        }

        public int getSize() {
            return ShellPanel.this.m_activator.getPluginCount();
        }

        public Object getElementAt(int index) {
            return ShellPanel.this.m_activator.getPlugin(index).getName();
        }

        public void intervalAdded(ListDataEvent event) {
            this.fireIntervalAdded(this, event.getIndex0(), event.getIndex1());
        }

        public void intervalRemoved(ListDataEvent event) {
            this.fireIntervalRemoved(this, event.getIndex0(), event.getIndex1());
        }

        public void contentsChanged(ListDataEvent event) {
            this.fireContentsChanged(this, event.getIndex0(), event.getIndex1());
        }

        public void update() {
            this.fireContentsChanged(this, 0, -1);
        }
    }
}

