/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.objectweb.jorm.mapper.rdb.adapter.BasicRdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;

public class Db2Adapter
extends BasicRdbAdapter {
    private static final int DEFAULTVARCHARSIZE = 256;
    private static final int DEFAULTVARCHARSIZEINPK = 128;
    private int varcharSize = 256;
    private int varcharSizeInPk = 128;

    public Db2Adapter() {
        super("db2");
    }

    public void setVarcharSize(int s) {
        this.varcharSize = s;
    }

    public void setVarcharSizeInPk(int s) {
        this.varcharSizeInPk = s;
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        switch (typeCode) {
            case 16: {
                return usedInPK ? "VARCHAR(" + (size != -1 ? size : this.varcharSizeInPk) + ") NOT NULL" : "VARCHAR(" + (size != -1 ? size : this.varcharSize) + ")";
            }
            case 0: 
            case 8: {
                return usedInPK ? "INTEGER NOT NULL" : "INTEGER";
            }
            case 1: 
            case 9: {
                return usedInPK ? "CHAR NOT NULL" : "CHAR";
            }
            case 2: 
            case 10: {
                return usedInPK ? "SMALLINT NOT NULL" : "SMALLINT";
            }
            case 3: 
            case 11: {
                return usedInPK ? "SMALLINT NOT NULL" : "SMALLINT";
            }
            case 4: 
            case 12: {
                return usedInPK ? "INTEGER NOT NULL" : "INTEGER";
            }
            case 5: 
            case 13: {
                return usedInPK ? "BIGINT NOT NULL" : "BIGINT";
            }
            case 6: 
            case 14: {
                return usedInPK ? "REAL NOT NULL" : "REAL";
            }
            case 7: 
            case 15: {
                return usedInPK ? "DOUBLE NOT NULL" : "DOUBLE";
            }
            case 17: {
                return usedInPK ? "DATE NOT NULL" : "DATE";
            }
            case 18: {
                return usedInPK ? "VARCHAR NOT NULL" : "VARCHAR";
            }
            case 19: {
                return usedInPK ? "VARCHAR(" + (size != -1 ? size : this.varcharSizeInPk) + ") FOR BIT DATA NOT NULL" : "VARCHAR(" + (size != -1 ? size : this.varcharSize) + ") FOR BIT DATA";
            }
            case 20: {
                return usedInPK ? "VARCHAR(" + (size != -1 ? size : this.varcharSizeInPk) + ") FOR BIT DATA NOT NULL" : "VARCHAR(" + (size != -1 ? size : this.varcharSize) + ") FOR BIT DATA";
            }
            case 22: {
                if (size != -1) {
                    if (scale != -1) {
                        return "DECIMAL(" + size + ", " + scale + ")" + (usedInPK ? " NOT NULL" : "");
                    }
                    return "DECIMAL(" + size + ")" + (usedInPK ? " NOT NULL" : "");
                }
                return "DECIMAL" + (usedInPK ? " NOT NULL" : "");
            }
        }
        return super.getSqlType(typeCode, usedInPK, size, scale);
    }

    public void writeColumnAlias(String alias, StringBuffer sb) {
        sb.append(" \"" + alias + "\" ");
    }

    public String getColumnAliasExpr(String aliasName) {
        return " \"" + aliasName + "\" ";
    }

    public boolean existRelation(Connection connection, String relName, String[] names) throws SQLException {
        return super.existRelation(connection, relName.toUpperCase(), names);
    }

    public String getNextValInSequence(String seqName) {
        return "VALUES( NEXT VALUE FOR " + seqName + ")";
    }

    public boolean existSequence(Connection conn, String seqName) {
        try {
            ResultSet rs = conn.createStatement().executeQuery("VALUES( PREVIOUS VALUE FOR " + seqName + ")");
            return rs.next();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String getValueAsSQLString(Object value, int typeCode) {
        switch (typeCode) {
            case 21: 
            case 22: {
                return value.toString();
            }
        }
        return super.getValueAsSQLString(value, typeCode);
    }
}

