/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.camel.registry.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.CompositeRegistry;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.ow2.jonas.camel.registry.xml.LazySimpleRegistry;
import org.ow2.jonas.camel.registry.xml.generated.Entry;
import org.ow2.jonas.camel.registry.xml.generated.Registry;
import org.ow2.jonas.camel.registry.xml.loader.XmlLoader;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class RegistryWrapper {
    private static final String XSD_URL = "org/ow2/jonas/camel/registry/xml/xsd/file-registry-1.0.xsd";
    private final Log logger = LogFactory.getLog(this.getClass());
    private SimpleRegistry registry;
    private CamelContext ctxt = null;

    public CompositeRegistry createRegistry(CamelContext ctxt) {
        this.ctxt = ctxt;
        org.apache.camel.spi.Registry reg = this.ctxt.getRegistry();
        CompositeRegistry cr = null;
        if (!(reg instanceof CompositeRegistry) || this.registry == null) {
            if (this.registry == null) {
                this.registry = new LazySimpleRegistry(ctxt);
            }
            ArrayList<Object> listRepo = new ArrayList<Object>(2);
            listRepo.add(reg);
            listRepo.add(this.registry);
            cr = new CompositeRegistry(listRepo);
        }
        return cr;
    }

    public SimpleRegistry getRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(InputStream input) throws Exception {
        try {
            Registry registry = XmlLoader.loadSchemaAndFile(XSD_URL, Registry.class, input);
            for (Entry entry : registry.getEntry()) {
                String name = this.removeAllWhitespace(entry.getLogicalName());
                String value = this.removeAllWhitespace(entry.getTechnicalName());
                if (this.registry.containsKey((Object)name)) {
                    throw new IllegalStateException("The entry name " + name + " is already set.");
                }
                this.registry.put((Object)name, (Object)value);
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Error while closing the inputStream", new Object[]{e});
            }
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while closing the inputStream", new Object[]{e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeValues(InputStream input) throws IllegalArgumentException {
        try {
            Registry registry = XmlLoader.loadSchemaAndFile(XSD_URL, Registry.class, input);
            for (Entry entry : registry.getEntry()) {
                String name = this.removeAllWhitespace(entry.getLogicalName());
                if (this.registry.containsKey((Object)name)) {
                    this.registry.remove((Object)name);
                    continue;
                }
                this.logger.warn((Object)"The entry {0} does not exist in the registry.", new Object[]{name});
            }
        }
        catch (Throwable t) {
            try {
                throw new IllegalArgumentException(t.getMessage(), t);
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e) {
                    this.logger.error((Object)"Error while closing the inputStream", new Object[]{e});
                }
                throw throwable;
            }
        }
        try {
            input.close();
            return;
        }
        catch (IOException e) {
            this.logger.error((Object)"Error while closing the inputStream", new Object[]{e});
            return;
        }
    }

    public void addToTheRegistry(InputStream inputStream) throws Exception {
        this.addValues(inputStream);
    }

    public void removeFromTheRegistry(InputStream inputStream) throws IllegalArgumentException {
        this.removeValues(inputStream);
    }

    private String removeAllWhitespace(String input) {
        StringBuilder result = new StringBuilder();
        input = input.replace('\r', '\n');
        for (String line : input.split("\n")) {
            result.append(line.trim());
        }
        return result.toString();
    }

    public void createRegistryAndAssignToContext(DefaultCamelContext ctxt) {
        org.apache.camel.spi.Registry reg = ctxt.getRegistry();
        if (!(reg instanceof CompositeRegistry) || this.registry == null) {
            if (this.registry == null) {
                this.registry = new LazySimpleRegistry((CamelContext)ctxt);
            }
            ArrayList<Object> listRepo = new ArrayList<Object>(2);
            listRepo.add(reg);
            listRepo.add(this.registry);
            CompositeRegistry cr = new CompositeRegistry(listRepo);
            ctxt.setRegistry((org.apache.camel.spi.Registry)cr);
        }
        this.ctxt = ctxt;
    }
}

