/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.BinaryOpExpState;
import org.apache.openjpa.jdbc.kernel.exps.CompareEqualExpression;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.FilterValueImpl;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

class NotEqualExpression
extends CompareEqualExpression {
    public NotEqualExpression(Val val1, Val val2) {
        super(val1, val2);
    }

    public void appendTo(Select sel, ExpContext ctx, BinaryOpExpState bstate, SQLBuffer buf, boolean val1Null, boolean val2Null) {
        if (val1Null && val2Null) {
            buf.append("1 <> 1");
        } else if (val1Null || val2Null) {
            ExpState state;
            Val val = val1Null ? this.getValue2() : this.getValue1();
            ExpState expState = state = val1Null ? bstate.state2 : bstate.state1;
            if (!this.isDirectComparison()) {
                int len = val.length(sel, ctx, state);
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(" AND ");
                    }
                    val.appendTo(sel, ctx, state, buf, i);
                    buf.append(" IS NOT ").appendValue(null);
                }
            } else {
                val.appendIsNotNull(sel, ctx, state, buf);
            }
        } else {
            Val val1 = this.getValue1();
            Val val2 = this.getValue2();
            if (val1.length(sel, ctx, bstate.state1) == 1 && val2.length(sel, ctx, bstate.state2) == 1) {
                ctx.store.getDBDictionary().comparison(buf, "<>", new FilterValueImpl(sel, ctx, bstate.state1, val1), new FilterValueImpl(sel, ctx, bstate.state2, val2));
            } else {
                int len = Math.max(val1.length(sel, ctx, bstate.state1), val2.length(sel, ctx, bstate.state2));
                buf.append("(");
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        buf.append(" OR ");
                    }
                    val1.appendTo(sel, ctx, bstate.state1, buf, i);
                    buf.append(" <> ");
                    val2.appendTo(sel, ctx, bstate.state2, buf, i);
                }
                buf.append(")");
            }
        }
    }
}

