/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase.web;

import org.apache.tools.ant.Task;
import org.ow2.jonas.ant.jonasbase.JReplace;
import org.ow2.jonas.ant.jonasbase.Tasks;
import org.ow2.jonas.ant.jonasbase.web.Ajp;
import org.ow2.jonas.ant.jonasbase.web.Http;
import org.ow2.jonas.ant.jonasbase.web.Https;

public class Jetty
extends Tasks {
    private static final String INFO = "[Jetty] ";
    private static final String HTTPS_TOKEN = "<!-- Add a HTTPS SSL listener on port 9043";
    private static final String AJP_TOKEN = "<!-- Add a AJP13 listener on port 8009";

    public void addConfiguredHttp(Http http) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jetty6.xml");
        propertyReplace.setToken("9000");
        propertyReplace.setValue(http.getPort());
        propertyReplace.setLogInfo("[Jetty] Setting HTTP port number to : " + http.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredHttps(Https https) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jetty6.xml");
        propertyReplace.setToken(HTTPS_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!-- Add a HTTPS SSL listener on port " + https.getPort() + "                           -->\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <Call name=\"addListener\">\n");
        value.append("    <Arg>\n");
        if ("ibm".equalsIgnoreCase(https.getVm())) {
            value.append("      <New class=\"org.mortbay.http.IbmJsseListener\">\n");
        } else {
            value.append("      <New class=\"org.mortbay.http.SunJsseListener\">\n");
        }
        value.append("        <Set name=\"Port\">" + https.getPort() + "</Set>\n");
        value.append("        <Set name=\"MinThreads\">5</Set>\n");
        value.append("        <Set name=\"MaxThreads\">100</Set>\n");
        value.append("        <Set name=\"MaxIdleTimeMs\">30000</Set>\n");
        value.append("        <Set name=\"LowResourcePersistTimeMs\">2000</Set>\n");
        if (https.getKeystoreFile() != null) {
            value.append("        <Set name=\"Keystore\">" + https.getKeystoreFile() + "</Set>\n");
        }
        if (https.getKeystorePass() != null) {
            value.append("        <Set name=\"Password\">" + https.getKeystorePass() + "</Set>\n");
        }
        if (https.getKeyPassword() != null) {
            value.append("  <Set name=\"KeyPassword\">" + https.getKeyPassword() + "</Set>\n");
        }
        value.append("      </New>\n");
        value.append("    </Arg>\n");
        value.append("  </Call>\n\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <!-- Add a HTTPS SSL listener on port 9043");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Jetty] Setting HTTPS port number to : " + https.getPort());
        this.addTask((Task)propertyReplace);
        propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jetty6.xml");
        propertyReplace.setToken("9043");
        propertyReplace.setValue(https.getPort());
        propertyReplace.setLogInfo("[Jetty] Fix HTTP redirect port number to : " + https.getPort());
        this.addTask((Task)propertyReplace);
    }

    public void addConfiguredAjp(Ajp ajp) {
        JReplace propertyReplace = new JReplace();
        propertyReplace.setConfigurationFile("jetty6.xml");
        propertyReplace.setToken(AJP_TOKEN);
        StringBuffer value = new StringBuffer();
        value.append("<!-- Add a AJP13 listener on port " + ajp.getPort() + "                               -->\n");
        value.append("  <!-- This protocol can be used with mod_jk in apache, IIS etc.       -->\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <Call name=\"addListener\">\n");
        value.append("    <Arg>\n");
        value.append("      <New class=\"org.mortbay.http.ajp.AJP13Listener\">\n");
        value.append("        <Set name=\"Port\">" + ajp.getPort() + "</Set>\n");
        value.append("        <Set name=\"MinThreads\">5</Set>\n");
        value.append("        <Set name=\"MaxThreads\">20</Set>\n");
        value.append("        <Set name=\"MaxIdleTimeMs\">0</Set>\n");
        value.append("        <Set name=\"confidentialPort\">9043</Set>\n");
        value.append("      </New>\n");
        value.append("    </Arg>\n");
        value.append("  </Call>\n\n");
        value.append("  <!-- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -->\n");
        value.append("  <!-- Add a AJP13 listener on port 8009");
        propertyReplace.setValue(value.toString());
        propertyReplace.setLogInfo("[Jetty] Setting AJP Connector to : " + ajp.getPort());
        this.addTask((Task)propertyReplace);
    }
}

