/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.commands.admin.util;

import java.io.PrintStream;

public class PrintUtils {
    private static final String SUCCESS = "[SUCCESS] ";
    private static final String FAILURE = "[FAILURE] ";
    private static final String ERROR = "[ERROR] ";
    private static final String WARNING = "[WARNING] ";

    public static void println(String message, PrintStream stream) {
        stream.println(message);
    }

    public static void println(String message) {
        PrintUtils.println(message, System.out);
    }

    public static void println(Throwable exception, PrintStream stream) {
        exception.printStackTrace(stream);
    }

    public static void println(Throwable exception) {
        PrintUtils.println(exception, System.err);
    }

    public static void warning(String message) {
        PrintUtils.println(WARNING + message, System.err);
    }

    public static void success(String message) {
        PrintUtils.println(SUCCESS + message, System.out);
    }

    public static void failure(String message) {
        PrintUtils.println(FAILURE + message, System.err);
    }

    public static void failure(String message, Throwable exception) {
        PrintUtils.failure(message);
        String type = exception.getClass().getSimpleName();
        PrintUtils.failure("Cause: [" + type + "] " + exception.getMessage());
    }

    public static void error(String message) {
        PrintUtils.println(ERROR + message, System.err);
    }

    public static void error(String message, Throwable exception) {
        PrintUtils.error(message);
        String type = exception.getClass().getSimpleName();
        PrintUtils.error("Cause: [" + type + "] " + exception.getMessage());
    }
}

