/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTableMetadata
extends TableMetadata {
    private List<JoinColumnMetadata> m_joinColumns;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns;

    public CollectionTableMetadata() {
        super("<collection-table>");
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    }

    public CollectionTableMetadata(MetadataAccessibleObject accessibleObject) {
        super(null, accessibleObject);
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    }

    public CollectionTableMetadata(MetadataAnnotation collectionTable, MetadataAccessibleObject accessibleObject, boolean isJPACollectionTable) {
        block4: {
            super(collectionTable, accessibleObject);
            this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
            this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
            if (collectionTable == null) break block4;
            if (isJPACollectionTable) {
                for (Object joinColumn : (Object[])collectionTable.getAttributeArray("joinColumns")) {
                    this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessibleObject));
                }
            } else {
                for (Object primaryKeyJoinColumn : (Object[])collectionTable.getAttributeArray("primaryKeyJoinColumns")) {
                    this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn, accessibleObject));
                }
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CollectionTableMetadata) {
            CollectionTableMetadata collectionTable = (CollectionTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, collectionTable.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_primaryKeyJoinColumns, collectionTable.getPrimaryKeyJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_collection_table_catalog";
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_collection_table_name";
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_collection_table_schema";
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

