/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.common.HandlerDesc;
import org.ow2.jonas.deployment.ejb.SessionStatelessDesc;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.SSBPortComponentDesc;
import org.ow2.jonas.generators.wsgen.generator.axis.VcBean;
import org.ow2.jonas.generators.wsgen.generator.axis.VcHandler;

public class VcPortComponent {
    private String name;
    private VcBean bean = null;
    private static final String SEP = ",";
    private String methods = null;
    private Vector handlers = new Vector();
    private String jaxRpcClassName;
    private String wsdlFilename;
    private static final String DOCUMENT_STYLE = "document";
    private String style = null;
    private String use = null;
    private String namespace = null;
    public static final String NS_URI_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    private static final QName SOAP_BINDING_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "binding");
    private static final QName SOAP_OPERATION_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "operation");
    private static final QName SOAP_BODY_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "body");
    private static final QName SOAP_FAULT_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "fault");

    public VcPortComponent(PortComponentDesc pcd, String wsdl) {
        this.name = pcd.getServiceName();
        this.wsdlFilename = wsdl;
        if (pcd.hasBeanImpl()) {
            SessionStatelessDesc ssb = ((SSBPortComponentDesc)pcd).getSessionStatelessDesc();
            this.bean = new VcBean(ssb);
        } else {
            this.jaxRpcClassName = pcd.getSIBClassname();
        }
        Method[] m = pcd.getServiceEndpointInterface().getMethods();
        for (int i = 0; i < m.length; ++i) {
            this.methods = this.methods != null ? this.methods + SEP : "";
            this.methods = this.methods + m[i].getName();
        }
        Definition def = pcd.getServiceDesc().getWSDL().getDefinition();
        boolean portFound = false;
        Iterator i = def.getServices().keySet().iterator();
        while (i.hasNext() && !portFound) {
            Service s = def.getService((QName)i.next());
            Port p = s.getPort(pcd.getQName().getLocalPart());
            if (p == null) continue;
            portFound = true;
            this.style = VcPortComponent.getStyle(p);
            this.use = VcPortComponent.getUse(p);
        }
        this.namespace = def.getTargetNamespace();
        List hs = pcd.getHandlers();
        for (HandlerDesc hd : hs) {
            this.handlers.add(new VcHandler(hd));
        }
    }

    private static String getUse(Port p) {
        String use = null;
        List ops = p.getBinding().getBindingOperations();
        Iterator j = ops.iterator();
        while (j.hasNext() && use == null) {
            BindingOperation bop = (BindingOperation)j.next();
            List inputExt = bop.getBindingInput().getExtensibilityElements();
            Iterator k = inputExt.iterator();
            while (k.hasNext() && use == null) {
                ExtensibilityElement ext = (ExtensibilityElement)k.next();
                if (!ext.getElementType().equals(SOAP_BODY_QNAME)) continue;
                SOAPBody sb = (SOAPBody)ext;
                use = sb.getUse();
            }
            List outputExt = bop.getBindingOutput().getExtensibilityElements();
            Iterator<Object> k2 = outputExt.iterator();
            while (k2.hasNext() && use == null) {
                ExtensibilityElement ext = (ExtensibilityElement)k2.next();
                if (!ext.getElementType().equals(SOAP_BODY_QNAME)) continue;
                SOAPBody sb = (SOAPBody)ext;
                use = sb.getUse();
            }
            k2 = bop.getBindingFaults().keySet().iterator();
            while (k2.hasNext() && use == null) {
                BindingFault bf = bop.getBindingFault((String)k2.next());
                List faultExt = bf.getExtensibilityElements();
                Iterator i = faultExt.iterator();
                while (i.hasNext() && use == null) {
                    ExtensibilityElement ext = (ExtensibilityElement)i.next();
                    if (!ext.getElementType().equals(SOAP_FAULT_QNAME)) continue;
                    SOAPFault sf = (SOAPFault)ext;
                    use = sf.getUse();
                }
            }
        }
        return use;
    }

    private static String getStyle(Port p) {
        String style = null;
        List bindingOps = p.getBinding().getBindingOperations();
        Iterator i = bindingOps.iterator();
        while (i.hasNext() && style == null) {
            BindingOperation bop = (BindingOperation)i.next();
            List extElements = bop.getExtensibilityElements();
            for (ExtensibilityElement ext : extElements) {
                if (!ext.getElementType().equals(SOAP_OPERATION_QNAME)) continue;
                SOAPOperation sop = (SOAPOperation)ext;
                style = sop.getStyle();
            }
        }
        List soapElements = p.getBinding().getExtensibilityElements();
        Iterator i2 = soapElements.iterator();
        while (i2.hasNext() && style == null) {
            ExtensibilityElement ext = (ExtensibilityElement)i2.next();
            if (!ext.getElementType().equals(SOAP_BINDING_QNAME)) continue;
            SOAPBinding soapb = (SOAPBinding)ext;
            style = soapb.getStyle();
        }
        if (style == null) {
            style = DOCUMENT_STYLE;
        }
        return style;
    }

    public VcPortComponent(String name, List hrs) {
        this.name = name;
        for (HandlerDesc hr : hrs) {
            this.handlers.add(new VcHandler(hr));
        }
    }

    public String getName() {
        return this.name;
    }

    public VcBean getBean() {
        return this.bean;
    }

    public String getWSDLFilename() {
        return this.wsdlFilename;
    }

    public String getMethods() {
        return this.methods;
    }

    public Vector getHandlers() {
        return this.handlers;
    }

    public String getJaxRpcClassName() {
        return this.jaxRpcClassName;
    }

    public String getStyle() {
        return this.style;
    }

    public String getUse() {
        return this.use;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

