/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaRequest;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.session.SessionMessageImpl;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class DeltaManager
extends ClusterManagerBase {
    public static final Log log = LogFactory.getLog(DeltaManager.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.ha.session");
    private static final String info = "DeltaManager/2.1";
    protected static String managerName = "DeltaManager";
    protected String name = null;
    private CatalinaCluster cluster = null;
    private volatile ReplicationValve replicationValve = null;
    private boolean expireSessionsOnShutdown = false;
    private boolean notifyListenersOnReplication = true;
    private boolean notifySessionListenersOnReplication = true;
    private volatile boolean stateTransfered = false;
    private int stateTransferTimeout = 60;
    private boolean sendAllSessions = true;
    private int sendAllSessionsSize = 1000;
    private int sendAllSessionsWaitTime = 2000;
    private ArrayList<SessionMessage> receivedMessageQueue = new ArrayList();
    private boolean receiverQueue = false;
    private boolean stateTimestampDrop = true;
    private long stateTransferCreateSendTime;
    private long sessionReplaceCounter = 0L;
    private long counterReceive_EVT_GET_ALL_SESSIONS = 0L;
    private long counterReceive_EVT_ALL_SESSION_DATA = 0L;
    private long counterReceive_EVT_SESSION_CREATED = 0L;
    private long counterReceive_EVT_SESSION_EXPIRED = 0L;
    private long counterReceive_EVT_SESSION_ACCESSED = 0L;
    private long counterReceive_EVT_SESSION_DELTA = 0L;
    private int counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private long counterReceive_EVT_CHANGE_SESSION_ID = 0L;
    private long counterSend_EVT_GET_ALL_SESSIONS = 0L;
    private long counterSend_EVT_ALL_SESSION_DATA = 0L;
    private long counterSend_EVT_SESSION_CREATED = 0L;
    private long counterSend_EVT_SESSION_DELTA = 0L;
    private long counterSend_EVT_SESSION_ACCESSED = 0L;
    private long counterSend_EVT_SESSION_EXPIRED = 0L;
    private int counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private long counterSend_EVT_CHANGE_SESSION_ID = 0L;
    private int counterNoStateTransfered = 0;

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public long getCounterSend_EVT_GET_ALL_SESSIONS() {
        return this.counterSend_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterSend_EVT_SESSION_ACCESSED() {
        return this.counterSend_EVT_SESSION_ACCESSED;
    }

    public long getCounterSend_EVT_SESSION_CREATED() {
        return this.counterSend_EVT_SESSION_CREATED;
    }

    public long getCounterSend_EVT_SESSION_DELTA() {
        return this.counterSend_EVT_SESSION_DELTA;
    }

    public long getCounterSend_EVT_SESSION_EXPIRED() {
        return this.counterSend_EVT_SESSION_EXPIRED;
    }

    public long getCounterSend_EVT_ALL_SESSION_DATA() {
        return this.counterSend_EVT_ALL_SESSION_DATA;
    }

    public int getCounterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getCounterSend_EVT_CHANGE_SESSION_ID() {
        return this.counterSend_EVT_CHANGE_SESSION_ID;
    }

    public long getCounterReceive_EVT_ALL_SESSION_DATA() {
        return this.counterReceive_EVT_ALL_SESSION_DATA;
    }

    public long getCounterReceive_EVT_GET_ALL_SESSIONS() {
        return this.counterReceive_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterReceive_EVT_SESSION_ACCESSED() {
        return this.counterReceive_EVT_SESSION_ACCESSED;
    }

    public long getCounterReceive_EVT_SESSION_CREATED() {
        return this.counterReceive_EVT_SESSION_CREATED;
    }

    public long getCounterReceive_EVT_SESSION_DELTA() {
        return this.counterReceive_EVT_SESSION_DELTA;
    }

    public long getCounterReceive_EVT_SESSION_EXPIRED() {
        return this.counterReceive_EVT_SESSION_EXPIRED;
    }

    public int getCounterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getCounterReceive_EVT_CHANGE_SESSION_ID() {
        return this.counterReceive_EVT_CHANGE_SESSION_ID;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getSessionReplaceCounter() {
        return this.sessionReplaceCounter;
    }

    public int getCounterNoStateTransfered() {
        return this.counterNoStateTransfered;
    }

    public int getReceivedQueueSize() {
        return this.receivedMessageQueue.size();
    }

    public int getStateTransferTimeout() {
        return this.stateTransferTimeout;
    }

    public void setStateTransferTimeout(int timeoutAllSession) {
        this.stateTransferTimeout = timeoutAllSession;
    }

    public boolean getStateTransfered() {
        return this.stateTransfered;
    }

    public void setStateTransfered(boolean stateTransfered) {
        this.stateTransfered = stateTransfered;
    }

    public int getSendAllSessionsWaitTime() {
        return this.sendAllSessionsWaitTime;
    }

    public void setSendAllSessionsWaitTime(int sendAllSessionsWaitTime) {
        this.sendAllSessionsWaitTime = sendAllSessionsWaitTime;
    }

    public boolean isStateTimestampDrop() {
        return this.stateTimestampDrop;
    }

    public void setStateTimestampDrop(boolean isTimestampDrop) {
        this.stateTimestampDrop = isTimestampDrop;
    }

    public boolean isSendAllSessions() {
        return this.sendAllSessions;
    }

    public void setSendAllSessions(boolean sendAllSessions) {
        this.sendAllSessions = sendAllSessions;
    }

    public int getSendAllSessionsSize() {
        return this.sendAllSessionsSize;
    }

    public void setSendAllSessionsSize(int sendAllSessionsSize) {
        this.sendAllSessionsSize = sendAllSessionsSize;
    }

    public boolean isNotifySessionListenersOnReplication() {
        return this.notifySessionListenersOnReplication;
    }

    public void setNotifySessionListenersOnReplication(boolean notifyListenersCreateSessionOnReplication) {
        this.notifySessionListenersOnReplication = notifyListenersCreateSessionOnReplication;
    }

    public boolean isExpireSessionsOnShutdown() {
        return this.expireSessionsOnShutdown;
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.expireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    @Override
    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public Session createSession(String sessionId) {
        return this.createSession(sessionId, true);
    }

    public Session createSession(String sessionId, boolean distribute) {
        DeltaSession session = (DeltaSession)super.createSession(sessionId);
        if (distribute) {
            this.sendCreateSession(session.getId(), session);
        }
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.createSession.newSession", session.getId(), this.sessions.size()));
        }
        return session;
    }

    protected void sendCreateSession(String sessionId, DeltaSession session) {
        if (this.cluster.getMembers().length > 0) {
            SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 1, null, sessionId, sessionId + "-" + System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.sendMessage.newSession", this.name, sessionId));
            }
            msg.setTimestamp(session.getCreationTime());
            ++this.counterSend_EVT_SESSION_CREATED;
            this.send(msg);
        }
    }

    protected void send(SessionMessage msg) {
        if (this.cluster != null) {
            this.cluster.send(msg);
        }
    }

    @Override
    public Session createEmptySession() {
        return this.getNewDeltaSession();
    }

    protected DeltaSession getNewDeltaSession() {
        return new DeltaSession(this);
    }

    @Override
    public void changeSessionId(Session session) {
        this.changeSessionId(session, true);
    }

    public void changeSessionId(Session session, boolean notify) {
        String orgSessionID = session.getId();
        super.changeSessionId(session);
        if (notify) {
            String newSessionID = session.getId();
            try {
                byte[] data = this.serializeSessionId(newSessionID);
                SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 15, data, orgSessionID, orgSessionID + "-" + System.currentTimeMillis());
                msg.setTimestamp(System.currentTimeMillis());
                ++this.counterSend_EVT_CHANGE_SESSION_ID;
                this.send(msg);
            }
            catch (IOException e) {
                log.error(sm.getString("deltaManager.unableSerializeSessionID", newSessionID), e);
            }
        }
    }

    protected byte[] serializeSessionId(String sessionId) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeUTF(sessionId);
        oos.flush();
        oos.close();
        return bos.toByteArray();
    }

    protected String deserializeSessionId(byte[] data) throws IOException {
        ReplicationStream ois = this.getReplicationStream(data);
        String sessionId = ois.readUTF();
        ois.close();
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DeltaRequest deserializeDeltaRequest(DeltaSession session, byte[] data) throws ClassNotFoundException, IOException {
        try {
            session.lock();
            ReplicationStream ois = this.getReplicationStream(data);
            session.getDeltaRequest().readExternal(ois);
            ois.close();
            DeltaRequest deltaRequest = session.getDeltaRequest();
            return deltaRequest;
        }
        finally {
            session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] serializeDeltaRequest(DeltaSession session, DeltaRequest deltaRequest) throws IOException {
        try {
            session.lock();
            byte[] byArray = deltaRequest.serialize();
            return byArray;
        }
        finally {
            session.unlock();
        }
    }

    protected void deserializeSessions(byte[] data) throws ClassNotFoundException, IOException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        ReplicationStream ois = null;
        try {
            ois = this.getReplicationStream(data);
            Integer count = (Integer)ois.readObject();
            int n = count;
            for (int i = 0; i < n; ++i) {
                DeltaSession session = (DeltaSession)this.createEmptySession();
                session.readObjectData(ois);
                session.setManager(this);
                session.setValid(true);
                session.setPrimarySession(false);
                session.access();
                session.setAccessCount(0);
                session.resetDeltaRequest();
                if (this.findSession(session.getIdInternal()) == null) {
                    ++this.sessionCounter;
                } else {
                    ++this.sessionReplaceCounter;
                    if (log.isWarnEnabled()) {
                        log.warn(sm.getString("deltaManager.loading.existing.session", session.getIdInternal()));
                    }
                }
                this.add(session);
                if (!this.notifySessionListenersOnReplication) continue;
                session.tellNew();
            }
        }
        catch (ClassNotFoundException e) {
            log.error(sm.getString("deltaManager.loading.cnfe", e), e);
            throw e;
        }
        catch (IOException e) {
            log.error(sm.getString("deltaManager.loading.ioe", e), e);
            throw e;
        }
        finally {
            try {
                if (ois != null) {
                    ((ObjectInputStream)ois).close();
                }
            }
            catch (IOException f) {}
            ois = null;
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
    }

    protected byte[] serializeSessions(Session[] currentSessions) throws IOException {
        ByteArrayOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(currentSessions.length);
            for (int i = 0; i < currentSessions.length; ++i) {
                ((DeltaSession)currentSessions[i]).writeObjectData(oos);
            }
            oos.flush();
        }
        catch (IOException e) {
            log.error(sm.getString("deltaManager.unloading.ioe", e), e);
            throw e;
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException f) {}
                oos = null;
            }
        }
        return fos.toByteArray();
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            Container host;
            Container context;
            Cluster cluster = this.getCluster();
            if (cluster == null && (context = this.getContainer()) != null && context instanceof Context && (host = context.getParent()) != null && host instanceof Host) {
                cluster = host.getCluster();
                if (cluster != null && cluster instanceof CatalinaCluster) {
                    this.setCluster((CatalinaCluster)cluster);
                } else {
                    Container engine = host.getParent();
                    if (engine != null && engine instanceof Engine) {
                        cluster = engine.getCluster();
                        if (cluster != null && cluster instanceof CatalinaCluster) {
                            this.setCluster((CatalinaCluster)cluster);
                        }
                    } else {
                        cluster = null;
                    }
                }
            }
            if (cluster == null) {
                log.error(sm.getString("deltaManager.noCluster", this.getName()));
                return;
            }
            if (log.isInfoEnabled()) {
                String type = "unknown";
                if (cluster.getContainer() instanceof Host) {
                    type = "Host";
                } else if (cluster.getContainer() instanceof Engine) {
                    type = "Engine";
                }
                log.info(sm.getString("deltaManager.registerCluster", this.getName(), type, cluster.getClusterName()));
            }
            if (log.isInfoEnabled()) {
                log.info(sm.getString("deltaManager.startClustering", this.getName()));
            }
            cluster.registerManager(this);
            this.getAllClusterSessions();
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error(sm.getString("deltaManager.managerLoad"), t);
        }
        this.setState(LifecycleState.STARTING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getAllClusterSessions() {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ArrayList<SessionMessage> arrayList;
            long beforeSendTime = System.currentTimeMillis();
            Member mbr = this.findSessionMasterMember();
            if (mbr == null) {
                return;
            }
            SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 4, null, "GET-ALL", "GET-ALL-" + this.getName());
            this.stateTransferCreateSendTime = beforeSendTime;
            ++this.counterSend_EVT_GET_ALL_SESSIONS;
            this.stateTransfered = false;
            try {
                arrayList = this.receivedMessageQueue;
                synchronized (arrayList) {
                    this.receiverQueue = true;
                }
                this.cluster.send(msg, mbr);
                if (log.isInfoEnabled()) {
                    log.info(sm.getString("deltaManager.waitForSessionState", this.getName(), mbr, this.getStateTransferTimeout()));
                }
                this.waitForSendAllSessions(beforeSendTime);
                arrayList = this.receivedMessageQueue;
            }
            catch (Throwable throwable) {
                ArrayList<SessionMessage> arrayList2 = this.receivedMessageQueue;
                synchronized (arrayList2) {
                    for (SessionMessage smsg : this.receivedMessageQueue) {
                        if (!this.stateTimestampDrop) {
                            this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                            continue;
                        }
                        if (smsg.getEventType() != 4 && smsg.getTimestamp() >= this.stateTransferCreateSendTime) {
                            this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                            continue;
                        }
                        if (!log.isWarnEnabled()) continue;
                        log.warn(sm.getString("deltaManager.dropMessage", this.getName(), smsg.getEventTypeString(), new Date(this.stateTransferCreateSendTime), new Date(smsg.getTimestamp())));
                    }
                    this.receivedMessageQueue.clear();
                    this.receiverQueue = false;
                }
                throw throwable;
            }
            synchronized (arrayList) {
                for (SessionMessage smsg : this.receivedMessageQueue) {
                    if (!this.stateTimestampDrop) {
                        this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                        continue;
                    }
                    if (smsg.getEventType() != 4 && smsg.getTimestamp() >= this.stateTransferCreateSendTime) {
                        this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn(sm.getString("deltaManager.dropMessage", this.getName(), smsg.getEventTypeString(), new Date(this.stateTransferCreateSendTime), new Date(smsg.getTimestamp())));
                }
                this.receivedMessageQueue.clear();
                this.receiverQueue = false;
            }
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("deltaManager.noMembers", this.getName()));
        }
    }

    protected void registerSessionAtReplicationValve(DeltaSession session) {
        Valve[] valves;
        CatalinaCluster cluster;
        if (this.replicationValve == null && this.container instanceof StandardContext && ((StandardContext)this.container).getCrossContext() && (cluster = this.getCluster()) != null && (valves = cluster.getValves()) != null && valves.length > 0) {
            for (int i = 0; this.replicationValve == null && i < valves.length; ++i) {
                if (!(valves[i] instanceof ReplicationValve)) continue;
                this.replicationValve = (ReplicationValve)valves[i];
            }
            if (this.replicationValve == null && log.isDebugEnabled()) {
                log.debug("no ReplicationValve found for CrossContext Support");
            }
        }
        if (this.replicationValve != null) {
            this.replicationValve.registerReplicationSession(session);
        }
    }

    protected Member findSessionMasterMember() {
        Member mbr = null;
        Member[] mbrs = this.cluster.getMembers();
        if (mbrs.length != 0) {
            mbr = mbrs[0];
        }
        if (mbr == null && log.isWarnEnabled()) {
            log.warn(sm.getString("deltaManager.noMasterMember", this.getName(), ""));
        }
        if (mbr != null && log.isDebugEnabled()) {
            log.warn(sm.getString("deltaManager.foundMasterMember", this.getName(), mbr));
        }
        return mbr;
    }

    protected void waitForSendAllSessions(long beforeSendTime) {
        long reqStart;
        long reqNow = reqStart = System.currentTimeMillis();
        boolean isTimeout = false;
        if (this.getStateTransferTimeout() > 0) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception sleep) {
                    // empty catch block
                }
                reqNow = System.currentTimeMillis();
                boolean bl = isTimeout = reqNow - reqStart > (long)(1000 * this.getStateTransferTimeout());
            } while (!this.getStateTransfered() && !isTimeout);
        } else if (this.getStateTransferTimeout() == -1) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception sleep) {
                    // empty catch block
                }
            } while (!this.getStateTransfered());
            reqNow = System.currentTimeMillis();
        }
        if (isTimeout || !this.getStateTransfered()) {
            ++this.counterNoStateTransfered;
            log.error(sm.getString("deltaManager.noSessionState", this.getName(), new Date(beforeSendTime), reqNow - beforeSendTime));
        } else if (log.isInfoEnabled()) {
            log.info(sm.getString("deltaManager.sessionReceived", this.getName(), new Date(beforeSendTime), reqNow - beforeSendTime));
        }
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.stopped", this.getName()));
        }
        this.setState(LifecycleState.STOPPING);
        if (log.isInfoEnabled()) {
            log.info(sm.getString("deltaManager.expireSessions", this.getName()));
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            DeltaSession session = (DeltaSession)sessions[i];
            if (!session.isValid()) continue;
            try {
                session.expire(true, this.isExpireSessionsOnShutdown());
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
            }
        }
        this.getCluster().removeManager(this);
        super.stopInternal();
        this.replicationValve = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageDataReceived(ClusterMessage cmsg) {
        if (cmsg != null && cmsg instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)cmsg;
            switch (msg.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 15: {
                    ArrayList<SessionMessage> arrayList = this.receivedMessageQueue;
                    synchronized (arrayList) {
                        if (this.receiverQueue) {
                            this.receivedMessageQueue.add(msg);
                            return;
                        }
                        break;
                    }
                }
            }
            this.messageReceived(msg, msg.getAddress() != null ? msg.getAddress() : null);
        }
    }

    @Override
    public ClusterMessage requestCompleted(String sessionId) {
        return this.requestCompleted(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterMessage requestCompleted(String sessionId, boolean expires) {
        DeltaSession session = null;
        try {
            session = (DeltaSession)this.findSession(sessionId);
            if (session == null) {
                ClusterMessage clusterMessage = null;
                return clusterMessage;
            }
            DeltaRequest deltaRequest = session.getDeltaRequest();
            session.lock();
            ClusterMessage msg = null;
            boolean isDeltaRequest = false;
            DeltaRequest deltaRequest2 = deltaRequest;
            synchronized (deltaRequest2) {
                boolean bl = isDeltaRequest = deltaRequest.getSize() > 0;
                if (isDeltaRequest) {
                    ++this.counterSend_EVT_SESSION_DELTA;
                    byte[] data = this.serializeDeltaRequest(session, deltaRequest);
                    msg = new SessionMessageImpl(this.getName(), 13, data, sessionId, sessionId + "-" + System.currentTimeMillis());
                    session.resetDeltaRequest();
                }
            }
            if (!isDeltaRequest) {
                if (!expires && !session.isPrimarySession()) {
                    ++this.counterSend_EVT_SESSION_ACCESSED;
                    msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + "-" + System.currentTimeMillis());
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("deltaManager.createMessage.accessChangePrimary", this.getName(), sessionId));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.createMessage.delta", this.getName(), sessionId));
            }
            if (!expires) {
                session.setPrimarySession(true);
            }
            if (!expires && msg == null) {
                long replDelta = System.currentTimeMillis() - session.getLastTimeReplicated();
                if (session.getMaxInactiveInterval() >= 0 && replDelta > (long)(session.getMaxInactiveInterval() * 1000)) {
                    ++this.counterSend_EVT_SESSION_ACCESSED;
                    msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + "-" + System.currentTimeMillis());
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("deltaManager.createMessage.access", this.getName(), sessionId));
                    }
                }
            }
            if (msg != null) {
                session.setLastTimeReplicated(System.currentTimeMillis());
                msg.setTimestamp(session.getLastTimeReplicated());
            }
            ClusterMessage clusterMessage = msg;
            return clusterMessage;
        }
        catch (IOException x) {
            log.error(sm.getString("deltaManager.createMessage.unableCreateDeltaRequest", sessionId), x);
            ClusterMessage clusterMessage = null;
            return clusterMessage;
        }
        finally {
            if (session != null) {
                session.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetStatistics() {
        this.processingTime = 0L;
        this.expiredSessions.set(0L);
        Deque deque = this.sessionCreationTiming;
        synchronized (deque) {
            this.sessionCreationTiming.clear();
            while (this.sessionCreationTiming.size() < 100) {
                this.sessionCreationTiming.add(null);
            }
        }
        deque = this.sessionExpirationTiming;
        synchronized (deque) {
            this.sessionExpirationTiming.clear();
            while (this.sessionExpirationTiming.size() < 100) {
                this.sessionExpirationTiming.add(null);
            }
        }
        this.rejectedSessions = 0;
        this.sessionReplaceCounter = 0L;
        this.counterNoStateTransfered = 0;
        this.setMaxActive(this.getActiveSessions());
        this.sessionCounter = this.getActiveSessions();
        this.counterReceive_EVT_ALL_SESSION_DATA = 0L;
        this.counterReceive_EVT_GET_ALL_SESSIONS = 0L;
        this.counterReceive_EVT_SESSION_ACCESSED = 0L;
        this.counterReceive_EVT_SESSION_CREATED = 0L;
        this.counterReceive_EVT_SESSION_DELTA = 0L;
        this.counterReceive_EVT_SESSION_EXPIRED = 0L;
        this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
        this.counterReceive_EVT_CHANGE_SESSION_ID = 0L;
        this.counterSend_EVT_ALL_SESSION_DATA = 0L;
        this.counterSend_EVT_GET_ALL_SESSIONS = 0L;
        this.counterSend_EVT_SESSION_ACCESSED = 0L;
        this.counterSend_EVT_SESSION_CREATED = 0L;
        this.counterSend_EVT_SESSION_DELTA = 0L;
        this.counterSend_EVT_SESSION_EXPIRED = 0L;
        this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
        this.counterSend_EVT_CHANGE_SESSION_ID = 0L;
    }

    protected void sessionExpired(String id) {
        ++this.counterSend_EVT_SESSION_EXPIRED;
        SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 2, null, id, id + "-EXPIRED-MSG");
        msg.setTimestamp(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.createMessage.expire", this.getName(), id));
        }
        this.send(msg);
    }

    public void expireAllLocalSessions() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireDirect = 0;
        int expireIndirect = 0;
        if (log.isDebugEnabled()) {
            log.debug("Start expire all sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length);
        }
        for (int i = 0; i < sessions.length; ++i) {
            DeltaSession session;
            if (!(sessions[i] instanceof DeltaSession) || !(session = (DeltaSession)sessions[i]).isPrimarySession()) continue;
            if (session.isValid()) {
                session.expire();
                ++expireDirect;
                continue;
            }
            ++expireIndirect;
        }
        long timeEnd = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("End expire sessions " + this.getName() + " exipre processingTime " + (timeEnd - timeNow) + " expired direct sessions: " + expireDirect + " expired direct sessions: " + expireIndirect);
        }
    }

    @Override
    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    protected boolean checkSenderDomain(SessionMessage msg, Member sender) {
        boolean sameDomain = true;
        if (!sameDomain && log.isWarnEnabled()) {
            log.warn(sm.getString("deltaManager.receiveMessage.fromWrongDomain", this.getName(), msg.getEventTypeString(), sender, "", ""));
        }
        return sameDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void messageReceived(SessionMessage msg, Member sender) {
        if (!this.checkSenderDomain(msg, sender)) {
            return;
        }
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader[] loaders = this.getClassLoaders();
            if (loaders != null && loaders.length > 0) {
                Thread.currentThread().setContextClassLoader(loaders[0]);
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.receiveMessage.eventType", this.getName(), msg.getEventTypeString(), sender));
            }
            switch (msg.getEventType()) {
                case 4: {
                    this.handleGET_ALL_SESSIONS(msg, sender);
                    return;
                }
                case 12: {
                    this.handleALL_SESSION_DATA(msg, sender);
                    return;
                }
                case 14: {
                    this.handleALL_SESSION_TRANSFERCOMPLETE(msg, sender);
                    return;
                }
                case 1: {
                    this.handleSESSION_CREATED(msg, sender);
                    return;
                }
                case 2: {
                    this.handleSESSION_EXPIRED(msg, sender);
                    return;
                }
                case 3: {
                    this.handleSESSION_ACCESSED(msg, sender);
                    return;
                }
                case 13: {
                    this.handleSESSION_DELTA(msg, sender);
                    return;
                }
                case 15: {
                    this.handleCHANGE_SESSION_ID(msg, sender);
                    return;
                }
            }
            return;
        }
        catch (Exception x) {
            log.error(sm.getString("deltaManager.receiveMessage.error", this.getName()), x);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    protected void handleALL_SESSION_TRANSFERCOMPLETE(SessionMessage msg, Member sender) {
        ++this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.transfercomplete", this.getName(), sender.getHost(), sender.getPort()));
        }
        this.stateTransferCreateSendTime = msg.getTimestamp();
        this.stateTransfered = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleSESSION_DELTA(SessionMessage msg, Member sender) throws IOException, ClassNotFoundException {
        ++this.counterReceive_EVT_SESSION_DELTA;
        byte[] delta = msg.getSession();
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.receiveMessage.delta", this.getName(), msg.getSessionID()));
            }
            try {
                session.lock();
                DeltaRequest dreq = this.deserializeDeltaRequest(session, delta);
                dreq.execute(session, this.notifyListenersOnReplication);
                session.setPrimarySession(false);
            }
            finally {
                session.unlock();
            }
        }
    }

    protected void handleSESSION_ACCESSED(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_SESSION_ACCESSED;
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.receiveMessage.accessed", this.getName(), msg.getSessionID()));
            }
            session.access();
            session.setPrimarySession(false);
            session.endAccess();
        }
    }

    protected void handleSESSION_EXPIRED(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_SESSION_EXPIRED;
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("deltaManager.receiveMessage.expired", this.getName(), msg.getSessionID()));
            }
            session.expire(this.notifySessionListenersOnReplication, false);
        }
    }

    protected void handleSESSION_CREATED(SessionMessage msg, Member sender) {
        ++this.counterReceive_EVT_SESSION_CREATED;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.createNewSession", this.getName(), msg.getSessionID()));
        }
        DeltaSession session = (DeltaSession)this.createEmptySession();
        session.setManager(this);
        session.setValid(true);
        session.setPrimarySession(false);
        session.setCreationTime(msg.getTimestamp());
        session.setMaxInactiveInterval(this.getMaxInactiveInterval());
        session.access();
        if (this.notifySessionListenersOnReplication) {
            session.setId(msg.getSessionID());
        } else {
            session.setIdInternal(msg.getSessionID());
            this.add(session);
        }
        session.resetDeltaRequest();
        session.endAccess();
    }

    protected void handleALL_SESSION_DATA(SessionMessage msg, Member sender) throws ClassNotFoundException, IOException {
        ++this.counterReceive_EVT_ALL_SESSION_DATA;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.allSessionDataBegin", this.getName()));
        }
        byte[] data = msg.getSession();
        this.deserializeSessions(data);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.allSessionDataAfter", this.getName()));
        }
    }

    protected void handleGET_ALL_SESSIONS(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_GET_ALL_SESSIONS;
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.unloadingBegin", this.getName()));
        }
        Session[] currentSessions = this.findSessions();
        long findSessionTimestamp = System.currentTimeMillis();
        if (this.isSendAllSessions()) {
            this.sendSessions(sender, currentSessions, findSessionTimestamp);
        } else {
            for (int i = 0; i < currentSessions.length; i += this.getSendAllSessionsSize()) {
                int len = i + this.getSendAllSessionsSize() > currentSessions.length ? currentSessions.length - i : this.getSendAllSessionsSize();
                Session[] sendSessions = new Session[len];
                System.arraycopy(currentSessions, i, sendSessions, 0, len);
                this.sendSessions(sender, sendSessions, findSessionTimestamp);
                if (this.getSendAllSessionsWaitTime() <= 0) continue;
                try {
                    Thread.sleep(this.getSendAllSessionsWaitTime());
                    continue;
                }
                catch (Exception sleep) {
                    // empty catch block
                }
            }
        }
        SessionMessageImpl newmsg = new SessionMessageImpl(this.name, 14, null, "SESSION-STATE-TRANSFERED", "SESSION-STATE-TRANSFERED" + this.getName());
        newmsg.setTimestamp(findSessionTimestamp);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.createMessage.allSessionTransfered", this.getName()));
        }
        ++this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        this.cluster.send(newmsg, sender);
    }

    protected void handleCHANGE_SESSION_ID(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_CHANGE_SESSION_ID;
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            String newSessionID = this.deserializeSessionId(msg.getSession());
            session.setPrimarySession(false);
            if (this.notifySessionListenersOnReplication) {
                session.setId(newSessionID);
            } else {
                session.setIdInternal(newSessionID);
                this.add(session);
            }
        }
    }

    protected void sendSessions(Member sender, Session[] currentSessions, long sendTimestamp) throws IOException {
        byte[] data = this.serializeSessions(currentSessions);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.receiveMessage.unloadingAfter", this.getName()));
        }
        SessionMessageImpl newmsg = new SessionMessageImpl(this.name, 12, data, "SESSION-STATE", "SESSION-STATE-" + this.getName());
        newmsg.setTimestamp(sendTimestamp);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("deltaManager.createMessage.allSessionData", this.getName()));
        }
        ++this.counterSend_EVT_ALL_SESSION_DATA;
        this.cluster.send(newmsg, sender);
    }

    @Override
    public ClusterManager cloneFromTemplate() {
        DeltaManager result = new DeltaManager();
        result.name = "Clone-from-" + this.name;
        result.cluster = this.cluster;
        result.replicationValve = this.replicationValve;
        result.maxActiveSessions = this.maxActiveSessions;
        result.expireSessionsOnShutdown = this.expireSessionsOnShutdown;
        result.notifyListenersOnReplication = this.notifyListenersOnReplication;
        result.notifySessionListenersOnReplication = this.notifySessionListenersOnReplication;
        result.stateTransferTimeout = this.stateTransferTimeout;
        result.sendAllSessions = this.sendAllSessions;
        result.sendAllSessionsSize = this.sendAllSessionsSize;
        result.sendAllSessionsWaitTime = this.sendAllSessionsWaitTime;
        result.receiverQueue = this.receiverQueue;
        result.stateTimestampDrop = this.stateTimestampDrop;
        result.stateTransferCreateSendTime = this.stateTransferCreateSendTime;
        return result;
    }
}

