/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.CamelInvocationHandler;
import org.apache.camel.component.bean.MethodInfoCache;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProxyHelper {
    private ProxyHelper() {
    }

    public static Object createProxyObject(Endpoint endpoint, Producer producer, ClassLoader classLoader, Class[] interfaces, MethodInfoCache methodCache) {
        return Proxy.newProxyInstance(classLoader, (Class[])interfaces.clone(), (InvocationHandler)new CamelInvocationHandler(endpoint, producer, methodCache));
    }

    public static <T> T createProxy(Endpoint endpoint, ClassLoader cl, Class[] interfaces, MethodInfoCache methodCache) throws Exception {
        Producer producer = endpoint.createProducer();
        ServiceHelper.startService(producer);
        return (T)ProxyHelper.createProxyObject(endpoint, producer, cl, interfaces, methodCache);
    }

    public static <T> T createProxy(Endpoint endpoint, ClassLoader cl, Class<T> ... interfaceClasses) throws Exception {
        return ProxyHelper.createProxy(endpoint, cl, (Class[])interfaceClasses, ProxyHelper.createMethodInfoCache(endpoint));
    }

    public static <T> T createProxy(Endpoint endpoint, Class<T> ... interfaceClasses) throws Exception {
        return ProxyHelper.createProxy(endpoint, ProxyHelper.getClassLoader(interfaceClasses), interfaceClasses);
    }

    public static <T> T createProxy(Endpoint endpoint, Producer producer, Class<T> ... interfaceClasses) throws Exception {
        return (T)ProxyHelper.createProxyObject(endpoint, producer, ProxyHelper.getClassLoader(interfaceClasses), interfaceClasses, ProxyHelper.createMethodInfoCache(endpoint));
    }

    protected static ClassLoader getClassLoader(Class<?> ... interfaces) {
        if (interfaces == null || interfaces.length < 1) {
            throw new IllegalArgumentException("You must provide at least 1 interface class.");
        }
        return interfaces[0].getClassLoader();
    }

    protected static MethodInfoCache createMethodInfoCache(Endpoint endpoint) {
        return new MethodInfoCache(endpoint.getCamelContext());
    }
}

