/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.rdb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.QueryLeafException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.rdb.api.QualifiedTable;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.api.RdbStringQueryLeaf;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;

public class GroupSameRdbRule
extends BasicRule {
    private DataStore dataStore;

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        QueryNode qn = (QueryNode)qt;
        if (this.dataStore != null) {
            List leaves = this.getLeavesWithDataStore(this.dataStore, qn);
            if (leaves.size() == 0) {
                return qt;
            }
            HashMap localyReplaced = new HashMap();
            if (leaves.get(0) instanceof RdbExpQueryLeaf) {
                BasicRdbExpQueryLeaf leaf = new BasicRdbExpQueryLeaf(this.dataStore, "");
                for (int i = 0; i < leaves.size(); ++i) {
                    this.mergeLeafIntoLeaf((RdbExpQueryLeaf)leaves.get(i), leaf, i, localyReplaced);
                    this.replaceUsage(qn, localyReplaced);
                }
            } else if (leaves.get(0) instanceof RdbStringQueryLeaf) {
                return qt;
            }
        }
        return qt;
    }

    public void setDataStore(DataStore ds) {
        this.dataStore = ds;
    }

    private void mergeLeafIntoLeaf(RdbExpQueryLeaf fromLeaf, RdbExpQueryLeaf intoLeaf, int leafIdx, Map localyReplaced) throws QueryLeafException {
        HashMap clonedTables = new HashMap();
        QualifiedTable[] tables = fromLeaf.getQualifiedTables();
        String fromLeafName = fromLeaf.getName();
        String suffix = fromLeafName != null ? fromLeafName : "ql_" + new Integer(leafIdx).toString();
        for (int i = 0; i < tables.length; ++i) {
            try {
                QualifiedTable newTable = (QualifiedTable)tables[i].clone(null, clonedTables);
                String tableAlias = tables[i].getAliasName();
                if (tableAlias != null) {
                    newTable.setAliasName(tableAlias + "_GSR_" + i + "_" + suffix);
                } else {
                    newTable.setAliasName("_GSR_" + i + "_" + suffix);
                }
                intoLeaf.addQualifiedTable(newTable);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Field[] fields = fromLeaf.getTupleStructure().getFields();
        for (int i = 0; i < fields.length; ++i) {
            RdbExpField newf = (RdbExpField)fields[i];
            newf.setTable((QualifiedTable)clonedTables.get(((RdbExpField)fields[i]).getTable()));
            RdbExpField f = intoLeaf.addRdbField(newf);
            localyReplaced.put(fields[i], f);
        }
        Expression exp = fromLeaf.getQueryFilter();
        Expression intoExp = intoLeaf.getQueryFilter();
        if (intoExp == null) {
            intoLeaf.setQueryFilter(exp);
        } else {
            intoLeaf.setQueryFilter(new And(exp, intoExp));
        }
    }
}

