/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveMetadata;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.asm.ClassReader;
import org.ow2.util.ee.deploy.api.deployable.ArchiveType;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.deployable.CARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.EARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.EJB21DeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.EJB3DeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.OSGiDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.RARDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.UnknownDeployableImpl;
import org.ow2.util.ee.deploy.impl.deployable.WARDeployableImpl;
import org.ow2.util.ee.deploy.impl.helper.DeployableDetectVisitor;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.deploy.deployable.api.FileDeployable;
import org.ow2.util.plan.deploy.deployable.api.factory.FileDeployableException;
import org.ow2.util.plan.deploy.deployable.api.factory.IFileDeployableFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeployableHelper {
    private static final String EAR_EXTENSION = ".ear";
    private static final String WAR_EXTENSION = ".war";
    private static final String RAR_EXTENSION = ".rar";
    private static final String JAR_EXTENSION = ".jar";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final String EJB_DD = "META-INF/ejb-jar.xml";
    private static final String WAR_DD = "WEB-INF/web.xml";
    private static final String RAR_DD = "META-INF/ra.xml";
    private static final String EAR_DD = "META-INF/application.xml";
    private static final String CAR_DD = "META-INF/application-client.xml";
    private static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static Log logger = LogFactory.getLog(DeployableHelper.class);
    private boolean isOSGiEnabled = true;
    private IArchive archive = null;
    private static IFileDeployableFactory fileDeployableFactory = null;

    private DeployableHelper(IArchive archive) {
        this.archive = archive;
    }

    public static IDeployable<?> getDeployable(IArchive archive) throws DeployableHelperException {
        return DeployableHelper.getDeployable(archive, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDeployable<?> getDeployable(IArchive archive, boolean isOSGiEnabled) throws DeployableHelperException {
        IDeployable<?> iDeployable;
        long t = System.currentTimeMillis();
        DeployableHelper helper = new DeployableHelper(archive);
        helper.isOSGiEnabled = isOSGiEnabled;
        try {
            iDeployable = helper.analyze();
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Detect type for ''{0}'' in ''{1}'' ms", new Object[]{archive.getName(), System.currentTimeMillis() - t});
            throw throwable;
        }
        logger.debug((Object)"Detect type for ''{0}'' in ''{1}'' ms", new Object[]{archive.getName(), System.currentTimeMillis() - t});
        return iDeployable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDeployable<?> analyze() throws DeployableHelperException {
        block32: {
            if (this.archive instanceof IFileArchive) {
                if (fileDeployableFactory != null) {
                    FileDeployable fileDeployable = null;
                    try {
                        fileDeployable = fileDeployableFactory.getFileDeployable((IFileArchive)this.archive);
                    }
                    catch (FileDeployableException e) {
                        logger.debug((Object)"It's not a recognized file deployable", new Object[]{e});
                    }
                    if (fileDeployable != null) {
                        return fileDeployable;
                    }
                } else {
                    logger.warn((Object)"FileArchive found but null FileDeployableFactory - could not create deployable", new Object[0]);
                    return null;
                }
            }
            logger.debug((Object)"Try to read XML DD in order to find the type of the archive ''{0}''", new Object[]{this.archive.getName()});
            switch (this.getXMLType()) {
                case EJB21JAR: {
                    logger.debug((Object)"''{0}'' is an EJB 2.1 with XML DD", new Object[]{this.archive});
                    return new EJB21DeployableImpl(this.archive);
                }
                case EJB3JAR: {
                    logger.debug((Object)"''{0}'' is an EJB 3 with XML DD", new Object[]{this.archive});
                    return new EJB3DeployableImpl(this.archive);
                }
                case WAR: {
                    logger.debug((Object)"''{0}'' is a WAR with XML DD", new Object[]{this.archive});
                    return new WARDeployableImpl(this.archive);
                }
                case EAR: {
                    logger.debug((Object)"''{0}'' is an EAR with XML DD", new Object[]{this.archive});
                    return new EARDeployableImpl(this.archive);
                }
                case RAR: {
                    logger.debug((Object)"''{0}'' is a RAR with XML DD", new Object[]{this.archive});
                    return new RARDeployableImpl(this.archive);
                }
                case CLIENT_APP: {
                    logger.debug((Object)"''{0}'' is a CAR with XML DD", new Object[]{this.archive});
                    return new CARDeployableImpl(this.archive);
                }
            }
            logger.debug((Object)"No XML DD, try with file extension", new Object[0]);
            if (this.archive.getName().toLowerCase().endsWith(EAR_EXTENSION)) {
                logger.debug((Object)"''{0}'' is an EAR", new Object[]{this.archive});
                return new EARDeployableImpl(this.archive);
            }
            if (this.archive.getName().toLowerCase().endsWith(WAR_EXTENSION)) {
                logger.debug((Object)"''{0}'' is a WAR", new Object[]{this.archive});
                return new WARDeployableImpl(this.archive);
            }
            if (this.archive.getName().toLowerCase().endsWith(RAR_EXTENSION)) {
                logger.debug((Object)"''{0}'' is a RAR", new Object[]{this.archive});
                return new RARDeployableImpl(this.archive);
            }
            if (this.archive.getName().toLowerCase().endsWith(JAR_EXTENSION)) {
                IArchiveMetadata archiveMetadata;
                if (this.isOSGiEnabled && (archiveMetadata = this.archive.getMetadata()) != null && archiveMetadata.get(BUNDLE_SYMBOLIC_NAME) != null) {
                    return new OSGiDeployableImpl(this.archive);
                }
                try {
                    URL urlManifest = this.archive.getResource(MANIFEST_FILE);
                    if (urlManifest == null) break block32;
                    try {
                        String mainClass;
                        URLConnection urlConnection = urlManifest.openConnection();
                        urlConnection.setDefaultUseCaches(false);
                        InputStream is = urlConnection.getInputStream();
                        Manifest manifest = null;
                        try {
                            manifest = new Manifest(is);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                        }
                        Attributes attributes = manifest.getMainAttributes();
                        if (attributes != null && (mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS)) != null) {
                            logger.debug((Object)"Detecting Main-Class attribute in archive ''{0}'' with value ''{1}''", new Object[]{this.archive.getName(), mainClass});
                            CARDeployableImpl cARDeployableImpl = new CARDeployableImpl(this.archive);
                            return cARDeployableImpl;
                        }
                    }
                    catch (IOException ioe) {
                        throw new DeployableHelperException("Error while analyzing Manifest entry in archive '" + this.archive.getName() + "'", ioe);
                    }
                }
                catch (ArchiveException e) {
                    logger.error((Object)"Cannot get the Manifest file on the archive {0} but try to continue type detection.", new Object[]{this.archive.getName(), e});
                }
                finally {
                    this.archive.close();
                }
            }
        }
        return this.classDetect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IDeployable<?> classDetect() throws DeployableHelperException {
        ArchiveType detectedType = null;
        DeployableDetectVisitor detectVisitor = new DeployableDetectVisitor();
        try {
            Iterator iterator = this.archive.getResources();
            while (iterator.hasNext() && detectedType == null) {
                URL url = (URL)iterator.next();
                if (!url.getPath().toLowerCase().endsWith(".class")) continue;
                try {
                    URLConnection urlConnection = url.openConnection();
                    urlConnection.setDefaultUseCaches(false);
                    InputStream is = urlConnection.getInputStream();
                    try {
                        new ClassReader(is).accept(detectVisitor, 0);
                    }
                    catch (RuntimeException e) {
                        throw new DeployableHelperException("Error while analyzing file entry '" + url + "' in archive '" + this.archive.getName() + "'", e);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    detectedType = detectVisitor.getArchiveType();
                }
                catch (IOException ioe) {
                    throw new DeployableHelperException("Error while analyzing file entry '" + url + "' in archive '" + this.archive.getName() + "'", ioe);
                }
            }
        }
        catch (ArchiveException e) {
            throw new DeployableHelperException("Error while analyzing archive '" + this.archive.getName() + "'", e);
        }
        finally {
            this.archive.close();
        }
        if (ArchiveType.EJB3JAR == detectedType) {
            return new EJB3DeployableImpl(this.archive);
        }
        return new UnknownDeployableImpl(this.archive);
    }

    private ArchiveType getXMLType() throws DeployableHelperException {
        try {
            if (this.archive.getResource(EAR_DD) != null) {
                ArchiveType archiveType = ArchiveType.EAR;
                return archiveType;
            }
            if (this.archive.getResource(WAR_DD) != null) {
                ArchiveType archiveType = ArchiveType.WAR;
                return archiveType;
            }
            if (this.archive.getResource(CAR_DD) != null) {
                ArchiveType archiveType = ArchiveType.CLIENT_APP;
                return archiveType;
            }
            if (this.archive.getResource(RAR_DD) != null) {
                ArchiveType archiveType = ArchiveType.RAR;
                return archiveType;
            }
            if (this.archive.getResource(EJB_DD) != null) {
                this.archive.close();
                ArchiveType archiveType = this.ejbXMLType();
                return archiveType;
            }
        }
        catch (ArchiveException e) {
            throw new DeployableHelperException("Cannot analyze archive '" + this.archive.getName() + "' for finding XML DD entry", e);
        }
        finally {
            this.archive.close();
        }
        return ArchiveType.UNKNOWN;
    }

    private ArchiveType ejbXMLType() throws DeployableHelperException {
        URL ejbDD = null;
        try {
            ejbDD = this.archive.getResource(EJB_DD);
        }
        catch (ArchiveException e) {
            throw new DeployableHelperException("Cannot get the 'META-INF/ejb-jar.xml' entry in the archive '" + this.archive.getName() + "'.", e);
        }
        finally {
            this.archive.close();
        }
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)ejbDD, (boolean)false, null);
        }
        catch (DocumentParserException e) {
            throw new DeployableHelperException("Cannot parse the url", e);
        }
        Element ejbJarRootElement = document.getDocumentElement();
        String ns = ejbJarRootElement.getNamespaceURI();
        if (JAVAEE_NS.equals(ns)) {
            return ArchiveType.EJB3JAR;
        }
        return ArchiveType.EJB21JAR;
    }

    public static void setFileDeployableFactory(IFileDeployableFactory factory) {
        fileDeployableFactory = factory;
    }

    public static IFileDeployableFactory getFileDeployableFactory() {
        return fileDeployableFactory;
    }
}

