/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.dynamic;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.xjc.XJCJavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicJAXBContext
extends JAXBContext {
    private ArrayList<DynamicHelper> helpers = new ArrayList();
    private DynamicClassLoader dClassLoader;
    private static final String SYSTEM_ID = "";
    private Field JDEFINEDCLASS_ENUMCONSTANTS = null;

    DynamicJAXBContext() throws JAXBException {
        try {
            this.JDEFINEDCLASS_ENUMCONSTANTS = PrivilegedAccessHelper.getDeclaredField(JDefinedClass.class, "enumConstantsByName", true);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
    }

    public DynamicType getDynamicType(String javaName) {
        for (DynamicHelper helper : this.helpers) {
            DynamicType type = helper.getType(javaName);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public DynamicEntity newDynamicEntity(String javaName) throws IllegalArgumentException {
        IllegalArgumentException ex = null;
        for (DynamicHelper helper : this.helpers) {
            try {
                return helper.newDynamicEntity(javaName);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
        }
        throw ex;
    }

    public DynamicEntity newDynamicEntity(DynamicType dynamicType) {
        return dynamicType.newDynamicEntity();
    }

    public Object getEnumConstant(String enumName, String constantName) throws ClassNotFoundException, JAXBException {
        ?[] enumConstants;
        Object valueToReturn = null;
        Class<?> enumClass = this.dClassLoader.loadClass(enumName);
        for (Object enumConstant : enumConstants = enumClass.getEnumConstants()) {
            if (!enumConstant.toString().equals(constantName)) continue;
            valueToReturn = enumConstant;
        }
        if (valueToReturn != null) {
            return valueToReturn;
        }
        throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.enumConstantNotFound(enumName + "." + constantName));
    }

    void initializeFromSessionsXML(String sessionNames, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        DynamicClassLoader dynamicClassLoader = classLoader instanceof DynamicClassLoader ? (DynamicClassLoader)classLoader : new DynamicClassLoader(classLoader);
        this.dClassLoader = dynamicClassLoader;
        StringTokenizer st = new StringTokenizer(sessionNames, ":");
        ArrayList<Project> dynamicProjects = new ArrayList<Project>(st.countTokens());
        XMLSessionConfigLoader loader = new XMLSessionConfigLoader();
        while (st.hasMoreTokens()) {
            DatabaseSession dbSession = (DatabaseSession)((Object)SessionManager.getManager().getSession(loader, st.nextToken(), classLoader, false, true));
            Project p = DynamicTypeBuilder.loadDynamicProject(dbSession.getProject(), null, dynamicClassLoader);
            dynamicProjects.add(p);
        }
        this.xmlContext = new XMLContext(dynamicProjects);
        List sessions = this.xmlContext.getSessions();
        for (Session session : sessions) {
            this.helpers.add(new DynamicHelper((DatabaseSession)session));
        }
    }

    void initializeFromXSDNode(Node node, ClassLoader classLoader, EntityResolver resolver, Map<String, ?> properties) throws JAXBException {
        Element element;
        if (node.getNodeType() == 9) {
            element = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 1) {
            element = (Element)node;
        } else {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.cannotInitializeFromNode());
        }
        SchemaCompiler sc = XJC.createSchemaCompiler();
        sc.setEntityResolver(resolver);
        sc.setErrorListener((ErrorListener)new XJCErrorListener());
        sc.parseSchema(SYSTEM_ID, element);
        S2JJAXBModel model = sc.bind();
        if (model == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.xjcBindingError());
        }
        JCodeModel jCodeModel = model.generateCode(new Plugin[0], null);
        this.initializeFromXJC(jCodeModel, classLoader, properties);
    }

    void initializeFromXSDInputSource(InputSource metadataSource, ClassLoader classLoader, EntityResolver resolver, Map<String, ?> properties) throws JAXBException {
        SchemaCompiler sc = XJC.createSchemaCompiler();
        if (metadataSource.getSystemId() == null) {
            metadataSource.setSystemId(SYSTEM_ID);
        }
        sc.setEntityResolver(resolver);
        sc.setErrorListener((ErrorListener)new XJCErrorListener());
        sc.parseSchema(metadataSource);
        S2JJAXBModel model = sc.bind();
        if (model == null) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.xjcBindingError());
        }
        JCodeModel jCodeModel = model.generateCode(new Plugin[0], null);
        this.initializeFromXJC(jCodeModel, classLoader, properties);
    }

    void initializeFromXJC(JCodeModel codeModel, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        JaxbClassLoader jaxbLoader = new JaxbClassLoader(classLoader);
        DynamicClassLoader dynamicClassLoader = classLoader instanceof DynamicClassLoader ? (DynamicClassLoader)classLoader : new DynamicClassLoader(jaxbLoader);
        this.dClassLoader = dynamicClassLoader;
        ArrayList<JDefinedClass> classesToProcess = new ArrayList<JDefinedClass>();
        Iterator packages = codeModel.packages();
        while (packages.hasNext()) {
            JPackage pkg = (JPackage)packages.next();
            Iterator classes = pkg.classes();
            while (classes.hasNext()) {
                JDefinedClass cls = (JDefinedClass)classes.next();
                classesToProcess.add(cls);
            }
        }
        ArrayList<JDefinedClass> innerClasses = new ArrayList<JDefinedClass>();
        for (int i = 0; i < classesToProcess.size(); ++i) {
            innerClasses.addAll(this.getInnerClasses((JDefinedClass)classesToProcess.get(i)));
        }
        classesToProcess.addAll(innerClasses);
        JavaClass[] jotClasses = this.createClassModelFromXJC(classesToProcess, codeModel, dynamicClassLoader);
        Map<String, XmlBindings> bindings = null;
        if (properties != null) {
            bindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, this.dClassLoader);
        }
        XJCJavaModelImpl javaModel = new XJCJavaModelImpl(jaxbLoader, codeModel, dynamicClassLoader);
        XJCJavaModelInputImpl javaModelInput = new XJCJavaModelInputImpl(jotClasses, (JavaModel)javaModel);
        Generator g = new Generator(javaModelInput, bindings, dynamicClassLoader, null);
        Project p = null;
        Project dp = null;
        try {
            p = g.generateProject();
            Vector descriptors = p.getOrderedDescriptors();
            for (ClassDescriptor classDescriptor : descriptors) {
                classDescriptor.setInstantiationPolicy(new InstantiationPolicy());
            }
            dp = DynamicTypeBuilder.loadDynamicProject(p, null, dynamicClassLoader);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
        this.xmlContext = new XMLContext(dp);
        List sessions = this.xmlContext.getSessions();
        for (Session session : sessions) {
            this.helpers.add(new DynamicHelper((DatabaseSession)session));
        }
    }

    private HashSet<JDefinedClass> getInnerClasses(JDefinedClass xjcClass) {
        HashSet<JDefinedClass> classesToReturn = new HashSet<JDefinedClass>();
        Iterator it = xjcClass.classes();
        while (it.hasNext()) {
            JDefinedClass innerClass = (JDefinedClass)it.next();
            classesToReturn.add(innerClass);
            classesToReturn.addAll(this.getInnerClasses(innerClass));
        }
        return classesToReturn;
    }

    private JavaClass[] createClassModelFromXJC(ArrayList<JDefinedClass> xjcClasses, JCodeModel jCodeModel, DynamicClassLoader dynamicClassLoader) throws JAXBException {
        try {
            JavaClass[] elinkClasses = new JavaClass[xjcClasses.size()];
            int count = 0;
            for (JDefinedClass definedClass : xjcClasses) {
                XJCJavaClassImpl xjcClass = new XJCJavaClassImpl(definedClass, jCodeModel, dynamicClassLoader);
                elinkClasses[count] = xjcClass;
                ++count;
                if (!definedClass.getClassType().equals(ClassType.ENUM)) continue;
                Map enumConstants = (Map)PrivilegedAccessHelper.getValueFromField(this.JDEFINEDCLASS_ENUMCONSTANTS, definedClass);
                Object[] enumValues = enumConstants.keySet().toArray();
                dynamicClassLoader.addEnum(definedClass.fullName(), enumValues);
            }
            return elinkClasses;
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(e));
        }
    }

    private class XJCErrorListener
    implements ErrorListener {
        private XJCErrorListener() {
        }

        public void error(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void fatalError(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void info(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }

        public void warning(SAXParseException arg0) {
            throw org.eclipse.persistence.exceptions.JAXBException.errorCreatingDynamicJAXBContext(arg0);
        }
    }
}

