/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.solr.core.AbstractSolrEventListener;
import org.apache.solr.core.SolrException;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.NamedList;

class RunExecutableListener
extends AbstractSolrEventListener {
    protected String[] cmd;
    protected File dir;
    protected String[] envp;
    protected boolean wait = true;

    RunExecutableListener() {
    }

    public void init(NamedList args) {
        String str;
        super.init(args);
        ArrayList cmdlist = new ArrayList();
        cmdlist.add(args.get("exe"));
        List lst = (List)args.get("args");
        if (lst != null) {
            cmdlist.addAll(lst);
        }
        this.cmd = cmdlist.toArray(new String[cmdlist.size()]);
        lst = (List)args.get("env");
        if (lst != null) {
            this.envp = lst.toArray(new String[lst.size()]);
        }
        this.dir = (str = (String)args.get("dir")) == null || str.equals("") || str.equals(".") || str.equals("./") ? null : new File(str);
        if ("false".equals(args.get("wait")) || Boolean.FALSE.equals(args.get("wait"))) {
            this.wait = false;
        }
    }

    protected int exec(String callback) {
        int ret = 0;
        try {
            boolean doLog = log.isLoggable(Level.FINE);
            if (doLog) {
                log.fine("About to exec " + this.cmd[0]);
            }
            Process proc = Runtime.getRuntime().exec(this.cmd, this.envp, this.dir);
            if (this.wait) {
                try {
                    ret = proc.waitFor();
                }
                catch (InterruptedException e) {
                    SolrException.log(log, e);
                }
            }
            if (this.wait && doLog) {
                log.fine("Executable " + this.cmd[0] + " returned " + ret);
            }
        }
        catch (IOException e) {
            SolrException.log(log, e);
        }
        return ret;
    }

    public void postCommit() {
        this.exec("postCommit");
    }

    public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
        this.exec("newSearcher");
    }
}

