/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.processor.aggregate.AggregateProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.GroupedExchangeAggregationStrategy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="aggregate")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AggregateDefinition
extends ProcessorDefinition<AggregateDefinition>
implements ExecutorServiceAwareDefinition<AggregateDefinition> {
    @XmlElement(name="correlationExpression", required=true)
    private ExpressionSubElementDefinition correlationExpression;
    @XmlElement(name="completionPredicate")
    private ExpressionSubElementDefinition completionPredicate;
    @XmlElement(name="completionTimeout")
    private ExpressionSubElementDefinition completionTimeoutExpression;
    @XmlElement(name="completionSize")
    private ExpressionSubElementDefinition completionSizeExpression;
    @XmlTransient
    private ExpressionDefinition expression;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlTransient
    private AggregationRepository aggregationRepository;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private String aggregationRepositoryRef;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private Integer completionSize;
    @XmlAttribute
    private Long completionInterval;
    @XmlAttribute
    private Long completionTimeout;
    @XmlAttribute
    private Boolean completionFromBatchConsumer;
    @XmlAttribute
    private Boolean groupExchanges;
    @XmlAttribute
    private Boolean eagerCheckCompletion;
    @XmlAttribute
    private Boolean ignoreInvalidCorrelationKeys;
    @XmlAttribute
    private Integer closeCorrelationKeyOnCompletion;
    @XmlAttribute
    private Boolean discardOnCompletionTimeout;

    public AggregateDefinition() {
    }

    public AggregateDefinition(Predicate predicate) {
        if (predicate != null) {
            this.setExpression(new ExpressionDefinition(predicate));
        }
    }

    public AggregateDefinition(Expression correlationExpression) {
        if (correlationExpression != null) {
            this.setExpression(new ExpressionDefinition(correlationExpression));
        }
    }

    public AggregateDefinition(ExpressionDefinition correlationExpression) {
        this.expression = correlationExpression;
    }

    public AggregateDefinition(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        this(correlationExpression);
        this.aggregationStrategy = aggregationStrategy;
    }

    public String toString() {
        String expressionString = this.getExpression() != null ? this.getExpression().getLabel() : "";
        return "Aggregate[" + expressionString + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "aggregate";
    }

    @Override
    public String getLabel() {
        return "aggregate";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return this.createAggregator(routeContext);
    }

    public ExpressionClause<AggregateDefinition> createAndSetExpression() {
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(this);
        this.setExpression(clause);
        return clause;
    }

    protected AggregateProcessor createAggregator(RouteContext routeContext) throws Exception {
        Expression expression;
        Processor processor = this.createChildProcessor(routeContext, true);
        processor = new UnitOfWorkProcessor(routeContext, processor);
        Expression correlation = this.getExpression().createExpression(routeContext);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "Aggregator", this);
        if (this.executorService == null) {
            this.executorService = this.isParallelProcessing() ? routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "Aggregator") : routeContext.getCamelContext().getExecutorServiceStrategy().newSynchronousThreadPool(this, "Aggregator");
        }
        AggregateProcessor answer = new AggregateProcessor(routeContext.getCamelContext(), processor, correlation, strategy, this.executorService);
        AggregationRepository repository = this.createAggregationRepository(routeContext);
        if (repository != null) {
            answer.setAggregationRepository(repository);
        }
        answer.setParallelProcessing(this.isParallelProcessing());
        if (this.getCompletionPredicate() != null) {
            Predicate predicate = this.getCompletionPredicate().createPredicate(routeContext);
            answer.setCompletionPredicate(predicate);
        }
        if (this.getCompletionTimeoutExpression() != null) {
            expression = this.getCompletionTimeoutExpression().createExpression(routeContext);
            answer.setCompletionTimeoutExpression(expression);
        }
        if (this.getCompletionTimeout() != null) {
            answer.setCompletionTimeout(this.getCompletionTimeout());
        }
        if (this.getCompletionInterval() != null) {
            answer.setCompletionInterval(this.getCompletionInterval());
        }
        if (this.getCompletionSizeExpression() != null) {
            expression = this.getCompletionSizeExpression().createExpression(routeContext);
            answer.setCompletionSizeExpression(expression);
        }
        if (this.getCompletionSize() != null) {
            answer.setCompletionSize(this.getCompletionSize());
        }
        if (this.isCompletionFromBatchConsumer() != null) {
            answer.setCompletionFromBatchConsumer(this.isCompletionFromBatchConsumer());
        }
        if (this.isEagerCheckCompletion() != null) {
            answer.setEagerCheckCompletion(this.isEagerCheckCompletion());
        }
        if (this.isIgnoreInvalidCorrelationKeys() != null) {
            answer.setIgnoreInvalidCorrelationKeys(this.isIgnoreInvalidCorrelationKeys());
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            answer.setCloseCorrelationKeyOnCompletion(this.getCloseCorrelationKeyOnCompletion());
        }
        if (this.isDiscardOnCompletionTimeout() != null) {
            answer.setDiscardOnCompletionTimeout(this.isDiscardOnCompletionTimeout());
        }
        return answer;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            strategy = routeContext.lookup(this.strategyRef, AggregationStrategy.class);
        }
        if (this.groupExchanges != null && this.groupExchanges.booleanValue()) {
            if (strategy != null || this.strategyRef != null) {
                throw new IllegalArgumentException("Options groupExchanges and AggregationStrategy cannot be enabled at the same time");
            }
            strategy = new GroupedExchangeAggregationStrategy();
        }
        if (strategy == null) {
            throw new IllegalArgumentException("AggregationStrategy or AggregationStrategyRef must be set on " + this);
        }
        return strategy;
    }

    private AggregationRepository createAggregationRepository(RouteContext routeContext) {
        AggregationRepository repository = this.getAggregationRepository();
        if (repository == null && this.aggregationRepositoryRef != null && (repository = routeContext.lookup(this.aggregationRepositoryRef, AggregationRepository.class)) == null) {
            throw new IllegalArgumentException("AggregationRepositoryRef " + this.aggregationRepositoryRef + " not found in registry.");
        }
        return repository;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public String getAggregationStrategyRef() {
        return this.strategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.strategyRef = aggregationStrategyRef;
    }

    public Integer getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(Integer completionSize) {
        this.completionSize = completionSize;
    }

    public Long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(Long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public Long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(Long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public ExpressionSubElementDefinition getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(ExpressionSubElementDefinition completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public ExpressionSubElementDefinition getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(ExpressionSubElementDefinition completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public ExpressionSubElementDefinition getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(ExpressionSubElementDefinition completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public Boolean isGroupExchanges() {
        return this.groupExchanges;
    }

    public void setGroupExchanges(Boolean groupExchanges) {
        this.groupExchanges = groupExchanges;
    }

    public Boolean isCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(Boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing != null && this.parallelProcessing != false;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public Boolean isEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(Boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public Boolean isIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(Boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public String getAggregationRepositoryRef() {
        return this.aggregationRepositoryRef;
    }

    public void setAggregationRepositoryRef(String aggregationRepositoryRef) {
        this.aggregationRepositoryRef = aggregationRepositoryRef;
    }

    public Boolean isDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(Boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public AggregateDefinition eagerCheckCompletion() {
        this.setEagerCheckCompletion(true);
        return this;
    }

    public AggregateDefinition ignoreInvalidCorrelationKeys() {
        this.setIgnoreInvalidCorrelationKeys(true);
        return this;
    }

    public AggregateDefinition closeCorrelationKeyOnCompletion(int capacity) {
        this.setCloseCorrelationKeyOnCompletion(capacity);
        return this;
    }

    public AggregateDefinition discardOnCompletionTimeout() {
        this.setDiscardOnCompletionTimeout(true);
        return this;
    }

    public AggregateDefinition completionFromBatchConsumer() {
        this.setCompletionFromBatchConsumer(true);
        return this;
    }

    public AggregateDefinition completionSize(int completionSize) {
        this.setCompletionSize(completionSize);
        return this;
    }

    public AggregateDefinition completionSize(Expression completionSize) {
        this.setCompletionSizeExpression(new ExpressionSubElementDefinition(completionSize));
        return this;
    }

    public AggregateDefinition completionInterval(long completionInterval) {
        this.setCompletionInterval(completionInterval);
        return this;
    }

    public AggregateDefinition completionTimeout(long completionTimeout) {
        this.setCompletionTimeout(completionTimeout);
        return this;
    }

    public AggregateDefinition completionTimeout(Expression completionTimeout) {
        this.setCompletionTimeoutExpression(new ExpressionSubElementDefinition(completionTimeout));
        return this;
    }

    public AggregateDefinition aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public AggregateDefinition aggregationStrategyRef(String aggregationStrategyRef) {
        this.setAggregationStrategyRef(aggregationStrategyRef);
        return this;
    }

    public AggregateDefinition aggregationRepository(AggregationRepository aggregationRepository) {
        this.setAggregationRepository(aggregationRepository);
        return this;
    }

    public AggregateDefinition aggregationRepositoryRef(String aggregationRepositoryRef) {
        this.setAggregationRepositoryRef(aggregationRepositoryRef);
        return this;
    }

    public AggregateDefinition groupExchanges() {
        this.setGroupExchanges(true);
        return this;
    }

    public ExpressionClause<AggregateDefinition> completionPredicate() {
        this.checkNoCompletedPredicate();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(this);
        this.setCompletionPredicate(new ExpressionSubElementDefinition(clause));
        return clause;
    }

    public AggregateDefinition completionPredicate(Predicate predicate) {
        this.checkNoCompletedPredicate();
        this.setCompletionPredicate(new ExpressionSubElementDefinition(predicate));
        return this;
    }

    public AggregateDefinition parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    @Override
    public AggregateDefinition executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public AggregateDefinition executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    protected void checkNoCompletedPredicate() {
        if (this.getCompletionPredicate() != null) {
            throw new IllegalArgumentException("There is already a completionPredicate defined for this aggregator: " + this);
        }
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public ExpressionDefinition getExpression() {
        if (this.expression == null && this.correlationExpression != null) {
            this.expression = this.correlationExpression.getExpressionType();
        }
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        this.expression = expression;
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }
}

