/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.Random;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.WeightedLoadBalancer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightedRandomLoadBalancer
extends WeightedLoadBalancer {
    private int randomCounter;

    public WeightedRandomLoadBalancer(List<Integer> distributionRatioList) {
        super(distributionRatioList);
    }

    @Override
    protected Processor chooseProcessor(List<Processor> processors, Exchange exchange) {
        boolean found = false;
        while (!found) {
            if (this.getRuntimeRatios().isEmpty()) {
                this.loadRuntimeRatios(this.getDistributionRatioList());
            }
            this.randomCounter = 0;
            if (this.getRuntimeRatios().size() > 0) {
                this.randomCounter = new Random().nextInt(this.getRuntimeRatios().size());
            }
            if (this.getRuntimeRatios().get(this.randomCounter).getRuntimeWeight() > 0) {
                this.getRuntimeRatios().get(this.randomCounter).setRuntimeWeight(this.getRuntimeRatios().get(this.randomCounter).getRuntimeWeight() - 1);
                found = true;
                continue;
            }
            this.getRuntimeRatios().remove(this.randomCounter);
        }
        return processors.get(this.getRuntimeRatios().get(this.randomCounter).getProcessorPosition());
    }
}

