/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.MultipartConfigElement;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.CometEventImpl;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteReader;
import org.apache.catalina.connector.InputBuffer;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.ApplicationPart;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.StringParser;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.StringCache;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.fileupload.FileItem;
import org.apache.tomcat.util.http.fileupload.FileUploadBase;
import org.apache.tomcat.util.http.fileupload.FileUploadException;
import org.apache.tomcat.util.http.fileupload.disk.DiskFileItemFactory;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.apache.tomcat.util.http.mapper.MappingData;
import org.apache.tomcat.util.res.StringManager;

public class Request
implements HttpServletRequest {
    private static final Log log = LogFactory.getLog(Request.class);
    protected org.apache.coyote.Request coyoteRequest;
    protected static final TimeZone GMT_ZONE;
    protected static final StringManager sm;
    protected Cookie[] cookies = null;
    protected SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
    protected static Locale defaultLocale;
    protected HashMap<String, Object> attributes = new HashMap();
    protected boolean sslAttributesParsed = false;
    private HashMap<String, Object> readOnlyAttributes = new HashMap();
    protected ArrayList<Locale> locales = new ArrayList();
    private transient HashMap<String, Object> notes = new HashMap();
    protected String authType = null;
    protected CometEventImpl event = null;
    protected boolean comet = false;
    protected DispatcherType internalDispatcherType = null;
    protected InputBuffer inputBuffer = new InputBuffer();
    protected CoyoteInputStream inputStream = new CoyoteInputStream(this.inputBuffer);
    protected CoyoteReader reader = new CoyoteReader(this.inputBuffer);
    protected boolean usingInputStream = false;
    protected boolean usingReader = false;
    protected Principal userPrincipal = null;
    protected boolean sessionParsed = false;
    protected boolean parametersParsed = false;
    protected boolean cookiesParsed = false;
    protected boolean secure = false;
    protected transient Subject subject = null;
    protected static int CACHED_POST_LEN;
    protected byte[] postData = null;
    protected ParameterMap<String, String[]> parameterMap = new ParameterMap();
    protected Collection<Part> parts = null;
    protected Exception partsParseException = null;
    protected Session session = null;
    protected Object requestDispatcherPath = null;
    protected boolean requestedSessionCookie = false;
    protected String requestedSessionId = null;
    protected boolean requestedSessionURL = false;
    protected boolean requestedSessionSSL = false;
    protected boolean localesParsed = false;
    private StringParser parser = new StringParser();
    protected int localPort = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected String localName = null;
    protected volatile AsyncContextImpl asyncContext = null;
    protected Boolean asyncSupported = null;
    protected Map<String, String> pathParameters = new HashMap<String, String>();
    protected Connector connector;
    protected Context context = null;
    protected FilterChain filterChain = null;
    protected static final String info = "org.apache.coyote.catalina.CoyoteRequest/1.0";
    protected MappingData mappingData = new MappingData();
    protected RequestFacade facade = null;
    protected Response response = null;
    protected B2CConverter URIConverter = null;
    protected Wrapper wrapper = null;

    public Request() {
        this.formats[0].setTimeZone(GMT_ZONE);
        this.formats[1].setTimeZone(GMT_ZONE);
        this.formats[2].setTimeZone(GMT_ZONE);
    }

    public void setCoyoteRequest(org.apache.coyote.Request coyoteRequest) {
        this.coyoteRequest = coyoteRequest;
        this.inputBuffer.setRequest(coyoteRequest);
    }

    public org.apache.coyote.Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    protected void addPathParameter(String name, String value) {
        this.pathParameters.put(name, value);
    }

    protected String getPathParameter(String name) {
        return this.pathParameters.get(name);
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public void recycle() {
        this.context = null;
        this.wrapper = null;
        this.internalDispatcherType = null;
        this.requestDispatcherPath = null;
        this.comet = false;
        if (this.event != null) {
            this.event.clear();
            this.event = null;
        }
        this.authType = null;
        this.inputBuffer.recycle();
        this.usingInputStream = false;
        this.usingReader = false;
        this.userPrincipal = null;
        this.subject = null;
        this.sessionParsed = false;
        this.parametersParsed = false;
        this.parts = null;
        this.partsParseException = null;
        this.cookiesParsed = false;
        this.locales.clear();
        this.localesParsed = false;
        this.secure = false;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.localAddr = null;
        this.localName = null;
        this.attributes.clear();
        this.sslAttributesParsed = false;
        this.notes.clear();
        this.cookies = null;
        if (this.session != null) {
            try {
                this.session.endAccess();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.warn(sm.getString("coyoteRequest.sessionEndAccessFail"), t);
            }
        }
        this.session = null;
        this.requestedSessionCookie = false;
        this.requestedSessionId = null;
        this.requestedSessionURL = false;
        if (Globals.IS_SECURITY_ENABLED || Connector.RECYCLE_FACADES) {
            this.parameterMap = new ParameterMap();
        } else {
            this.parameterMap.setLocked(false);
            this.parameterMap.clear();
        }
        this.mappingData.recycle();
        if (Globals.IS_SECURITY_ENABLED || Connector.RECYCLE_FACADES) {
            if (this.facade != null) {
                this.facade.clear();
                this.facade = null;
            }
            if (this.inputStream != null) {
                this.inputStream.clear();
                this.inputStream = null;
            }
            if (this.reader != null) {
                this.reader.clear();
                this.reader = null;
            }
        }
        this.asyncSupported = null;
        if (this.asyncContext != null) {
            this.asyncContext.recycle();
        }
        this.asyncContext = null;
        this.pathParameters.clear();
    }

    protected boolean isProcessing() {
        return this.coyoteRequest.isProcessing();
    }

    public void clearEncoders() {
        this.inputBuffer.clearEncoders();
    }

    public boolean read() throws IOException {
        return this.inputBuffer.realReadBytes(null, 0, 0) > 0;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void setFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    public Host getHost() {
        return (Host)this.mappingData.host;
    }

    public void setHost(Host host) {
        this.mappingData.host = host;
    }

    public String getInfo() {
        return info;
    }

    public MappingData getMappingData() {
        return this.mappingData;
    }

    public HttpServletRequest getRequest() {
        if (this.facade == null) {
            this.facade = new RequestFacade(this);
        }
        return this.facade;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public InputStream getStream() {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    protected B2CConverter getURIConverter() {
        return this.URIConverter;
    }

    protected void setURIConverter(B2CConverter URIConverter) {
        this.URIConverter = URIConverter;
    }

    public Wrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public ServletInputStream createInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public void finishRequest() throws IOException {
    }

    public Object getNote(String name) {
        return this.notes.get(name);
    }

    public Iterator<String> getNoteNames() {
        return this.notes.keySet().iterator();
    }

    public void removeNote(String name) {
        this.notes.remove(name);
    }

    public void setNote(String name, Object value) {
        this.notes.put(name, value);
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public void setServerName(String name) {
        this.coyoteRequest.serverName().setString(name);
    }

    public void setServerPort(int port) {
        this.coyoteRequest.setServerPort(port);
    }

    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.internalDispatcherType == null ? DispatcherType.REQUEST : this.internalDispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            return this.requestDispatcherPath == null ? this.getRequestPathMB().toString() : this.requestDispatcherPath.toString();
        }
        if (name.equals("org.apache.catalina.ASYNC_SUPPORTED")) {
            return this.asyncSupported;
        }
        Object attr = this.attributes.get(name);
        if (attr != null) {
            return attr;
        }
        attr = this.coyoteRequest.getAttribute(name);
        if (attr != null) {
            return attr;
        }
        if (Request.isSSLAttribute(name)) {
            this.coyoteRequest.action(ActionCode.REQ_SSL_ATTRIBUTE, this.coyoteRequest);
            attr = this.coyoteRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (attr != null) {
                this.attributes.put("javax.servlet.request.X509Certificate", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.cipher_suite")) != null) {
                this.attributes.put("javax.servlet.request.cipher_suite", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.key_size")) != null) {
                this.attributes.put("javax.servlet.request.key_size", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session")) != null) {
                this.attributes.put("javax.servlet.request.ssl_session", attr);
            }
            if ((attr = this.coyoteRequest.getAttribute("javax.servlet.request.ssl_session_mgr")) != null) {
                this.attributes.put("javax.servlet.request.ssl_session_mgr", attr);
            }
            attr = this.attributes.get(name);
            this.sslAttributesParsed = true;
        }
        return attr;
    }

    static boolean isSSLAttribute(String name) {
        return "javax.servlet.request.X509Certificate".equals(name) || "javax.servlet.request.cipher_suite".equals(name) || "javax.servlet.request.key_size".equals(name) || "javax.servlet.request.ssl_session".equals(name) || "javax.servlet.request.ssl_session_mgr".equals(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.isSecure() && !this.sslAttributesParsed) {
            this.getAttribute("javax.servlet.request.X509Certificate");
        }
        return new Enumerator<String>(this.attributes.keySet(), true);
    }

    public String getCharacterEncoding() {
        return this.coyoteRequest.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.coyoteRequest.getContentLength();
    }

    public String getContentType() {
        return this.coyoteRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.usingReader) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getInputStream.ise"));
        }
        this.usingInputStream = true;
        if (this.inputStream == null) {
            this.inputStream = new CoyoteInputStream(this.inputBuffer);
        }
        return this.inputStream;
    }

    public Locale getLocale() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return this.locales.get(0);
        }
        return defaultLocale;
    }

    public Enumeration<Locale> getLocales() {
        if (!this.localesParsed) {
            this.parseLocales();
        }
        if (this.locales.size() > 0) {
            return new Enumerator<Locale>(this.locales);
        }
        ArrayList<Locale> results = new ArrayList<Locale>();
        results.add(defaultLocale);
        return new Enumerator<Locale>(results);
    }

    public String getParameter(String name) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (this.parameterMap.isLocked()) {
            return this.parameterMap;
        }
        Enumeration<String> enumeration = this.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement();
            String[] values = this.getParameterValues(name);
            this.parameterMap.put(name, values);
        }
        this.parameterMap.setLocked(true);
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (!this.parametersParsed) {
            this.parseParameters();
        }
        return this.coyoteRequest.getParameters().getParameterValues(name);
    }

    public String getProtocol() {
        return this.coyoteRequest.protocol().toString();
    }

    public BufferedReader getReader() throws IOException {
        if (this.usingInputStream) {
            throw new IllegalStateException(sm.getString("coyoteRequest.getReader.ise"));
        }
        this.usingReader = true;
        this.inputBuffer.checkConverter();
        if (this.reader == null) {
            this.reader = new CoyoteReader(this.inputBuffer);
        }
        return this.reader;
    }

    @Deprecated
    public String getRealPath(String path) {
        if (this.context == null) {
            return null;
        }
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext == null) {
            return null;
        }
        try {
            return servletContext.getRealPath(path);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_HOST_ADDR_ATTRIBUTE, this.coyoteRequest);
            this.remoteAddr = this.coyoteRequest.remoteAddr().toString();
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            if (!this.connector.getEnableLookups()) {
                this.remoteHost = this.getRemoteAddr();
            } else {
                this.coyoteRequest.action(ActionCode.REQ_HOST_ATTRIBUTE, this.coyoteRequest);
                this.remoteHost = this.coyoteRequest.remoteHost().toString();
            }
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        if (this.remotePort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_REMOTEPORT_ATTRIBUTE, this.coyoteRequest);
            this.remotePort = this.coyoteRequest.getRemotePort();
        }
        return this.remotePort;
    }

    public String getLocalName() {
        if (this.localName == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, this.coyoteRequest);
            this.localName = this.coyoteRequest.localName().toString();
        }
        return this.localName;
    }

    public String getLocalAddr() {
        if (this.localAddr == null) {
            this.coyoteRequest.action(ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE, this.coyoteRequest);
            this.localAddr = this.coyoteRequest.localAddr().toString();
        }
        return this.localAddr;
    }

    public int getLocalPort() {
        if (this.localPort == -1) {
            this.coyoteRequest.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, this.coyoteRequest);
            this.localPort = this.coyoteRequest.getLocalPort();
        }
        return this.localPort;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path;
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    public String getScheme() {
        return this.coyoteRequest.scheme().toString();
    }

    public String getServerName() {
        return this.coyoteRequest.serverName().toString();
    }

    public int getServerPort() {
        return this.coyoteRequest.getServerPort();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        if (name.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.getAttributes().remove(name);
        }
        if (!(found = this.attributes.containsKey(name))) {
            return;
        }
        value = this.attributes.get(name);
        this.attributes.remove(name);
        Object[] listeners = this.context.getApplicationEventListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                listener.attributeRemoved(event);
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.context.getLogger().error(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setAttribute(String name, Object value) {
        Object[] listeners;
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("coyoteRequest.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.internalDispatcherType = (DispatcherType)value;
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (name.equals("org.apache.catalina.ASYNC_SUPPORTED")) {
            this.asyncSupported = (Boolean)value;
        }
        Object oldValue = null;
        boolean replaced = false;
        if (this.readOnlyAttributes.containsKey(name)) {
            return;
        }
        oldValue = this.attributes.put(name, value);
        if (oldValue != null) {
            replaced = true;
        }
        if (name.startsWith("org.apache.tomcat.")) {
            this.coyoteRequest.setAttribute(name, value);
        }
        if ((listeners = this.context.getApplicationEventListeners()) == null || listeners.length == 0) {
            return;
        }
        ServletRequestAttributeEvent event = null;
        event = replaced ? new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, oldValue) : new ServletRequestAttributeEvent(this.context.getServletContext(), (ServletRequest)this.getRequest(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletRequestAttributeListener)) continue;
            ServletRequestAttributeListener listener = (ServletRequestAttributeListener)listeners[i];
            try {
                if (replaced) {
                    listener.attributeReplaced(event);
                    continue;
                }
                listener.attributeAdded(event);
                continue;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                this.context.getLogger().error(sm.getString("coyoteRequest.attributeEvent"), t);
                this.attributes.put("javax.servlet.error.exception", t);
            }
        }
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.usingReader) {
            return;
        }
        byte[] buffer = new byte[]{97};
        new String(buffer, enc);
        this.coyoteRequest.setCharacterEncoding(enc);
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public AsyncContext startAsync() {
        return this.startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.response.getResponse());
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Not supported.");
        }
        if (this.asyncContext == null) {
            this.asyncContext = new AsyncContextImpl(this);
        }
        this.asyncContext.setStarted(this.getContext(), request, response, request == this.getRequest() && response == this.getResponse().getResponse());
        this.asyncContext.setTimeout(this.getConnector().getAsyncTimeout());
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return this.asyncContext.isStarted();
    }

    public boolean isAsyncDispatching() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_DISPATCHING, result);
        return result.get();
    }

    public boolean isAsync() {
        if (this.asyncContext == null) {
            return false;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        this.coyoteRequest.action(ActionCode.ASYNC_IS_ASYNC, result);
        return result.get();
    }

    public boolean isAsyncSupported() {
        if (this.asyncSupported == null) {
            return true;
        }
        return this.asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        if (this.internalDispatcherType == null) {
            return DispatcherType.REQUEST;
        }
        return this.internalDispatcherType;
    }

    public void addCookie(Cookie cookie) {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        int size = 0;
        if (this.cookies != null) {
            size = this.cookies.length;
        }
        Cookie[] newCookies = new Cookie[size + 1];
        for (int i = 0; i < size; ++i) {
            newCookies[i] = this.cookies[i];
        }
        newCookies[size] = cookie;
        this.cookies = newCookies;
    }

    public void addLocale(Locale locale) {
        this.locales.add(locale);
    }

    public void addParameter(String name, String[] values) {
        this.coyoteRequest.getParameters().addParameterValues(name, values);
    }

    public void clearCookies() {
        this.cookiesParsed = true;
        this.cookies = null;
    }

    public void clearHeaders() {
    }

    public void clearLocales() {
        this.locales.clear();
    }

    public void clearParameters() {
    }

    public void setAuthType(String type) {
        this.authType = type;
    }

    public void setContextPath(String path) {
        if (path == null) {
            this.mappingData.contextPath.setString("");
        } else {
            this.mappingData.contextPath.setString(path);
        }
    }

    public void setPathInfo(String path) {
        this.mappingData.pathInfo.setString(path);
    }

    public void setRequestedSessionCookie(boolean flag) {
        this.requestedSessionCookie = flag;
    }

    public void setRequestedSessionId(String id) {
        this.requestedSessionId = id;
    }

    public void setRequestedSessionURL(boolean flag) {
        this.requestedSessionURL = flag;
    }

    public void setRequestedSessionSSL(boolean flag) {
        this.requestedSessionSSL = flag;
    }

    public String getDecodedRequestURI() {
        return this.coyoteRequest.decodedURI().toString();
    }

    public MessageBytes getDecodedRequestURIMB() {
        return this.coyoteRequest.decodedURI();
    }

    public void setServletPath(String path) {
        if (path != null) {
            this.mappingData.wrapperPath.setString(path);
        }
    }

    public void setUserPrincipal(Principal principal) {
        if (Globals.IS_SECURITY_ENABLED) {
            HttpSession session = this.getSession(false);
            if (this.subject != null && !this.subject.getPrincipals().contains(principal)) {
                this.subject.getPrincipals().add(principal);
            } else if (session != null && session.getAttribute("javax.security.auth.subject") == null) {
                this.subject = new Subject();
                this.subject.getPrincipals().add(principal);
            }
            if (session != null) {
                session.setAttribute("javax.security.auth.subject", (Object)this.subject);
            }
        }
        this.userPrincipal = principal;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getContextPath() {
        return this.mappingData.contextPath.toString();
    }

    public MessageBytes getContextPathMB() {
        return this.mappingData.contextPath;
    }

    public Cookie[] getCookies() {
        if (!this.cookiesParsed) {
            this.parseCookies();
        }
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        long result = FastHttpDateFormat.parseDate(value, this.formats);
        if (result != -1L) {
            return result;
        }
        throw new IllegalArgumentException(value);
    }

    public String getHeader(String name) {
        return this.coyoteRequest.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.coyoteRequest.getMimeHeaders().values(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.coyoteRequest.getMimeHeaders().names();
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public String getMethod() {
        return this.coyoteRequest.method().toString();
    }

    public String getPathInfo() {
        return this.mappingData.pathInfo.toString();
    }

    public MessageBytes getPathInfoMB() {
        return this.mappingData.pathInfo;
    }

    public String getPathTranslated() {
        if (this.context == null) {
            return null;
        }
        if (this.getPathInfo() == null) {
            return null;
        }
        return this.context.getServletContext().getRealPath(this.getPathInfo());
    }

    public String getQueryString() {
        return this.coyoteRequest.queryString().toString();
    }

    public String getRemoteUser() {
        if (this.userPrincipal == null) {
            return null;
        }
        return this.userPrincipal.getName();
    }

    public MessageBytes getRequestPathMB() {
        return this.mappingData.requestPath;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.coyoteRequest.requestURI().toString();
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.mappingData.wrapperPath.toString();
    }

    public MessageBytes getServletPathMB() {
        return this.mappingData.wrapperPath;
    }

    public HttpSession getSession() {
        Session session = this.doGetSession(true);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public HttpSession getSession(boolean create) {
        Session session = this.doGetSession(create);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.requestedSessionId == null) {
            return false;
        }
        return this.requestedSessionURL;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.requestedSessionId == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return false;
        }
        Session session = null;
        try {
            session = manager.findSession(this.requestedSessionId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return session != null && session.isValid();
    }

    public boolean isUserInRole(String role) {
        if (this.userPrincipal == null) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        Realm realm = this.context.getRealm();
        if (realm == null) {
            return false;
        }
        return realm.hasRole(this.wrapper, this.userPrincipal, role);
    }

    public Principal getPrincipal() {
        return this.userPrincipal;
    }

    public Principal getUserPrincipal() {
        if (this.userPrincipal instanceof GenericPrincipal) {
            return ((GenericPrincipal)this.userPrincipal).getUserPrincipal();
        }
        return this.userPrincipal;
    }

    public Session getSessionInternal() {
        return this.doGetSession(true);
    }

    public void changeSessionId(String newSessionId) {
        if (this.requestedSessionId != null && this.requestedSessionId.length() > 0) {
            this.requestedSessionId = newSessionId;
        }
        if (this.context != null && !this.context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        if (this.response != null) {
            Cookie newCookie = ApplicationSessionCookieConfig.createSessionCookie(this.context, newSessionId, this.secure);
            this.response.addSessionCookieInternal(newCookie);
        }
    }

    public Session getSessionInternal(boolean create) {
        return this.doGetSession(create);
    }

    public CometEventImpl getEvent() {
        if (this.event == null) {
            this.event = new CometEventImpl(this, this.response);
        }
        return this.event;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean comet) {
        this.comet = comet;
    }

    public boolean isParametersParsed() {
        return this.parametersParsed;
    }

    public boolean getAvailable() {
        return this.inputBuffer.available() > 0;
    }

    protected void checkSwallowInput() {
        Context context = this.getContext();
        if (context != null && !context.getSwallowAbortedUploads()) {
            this.coyoteRequest.action(ActionCode.DISABLE_SWALLOW_INPUT, null);
        }
    }

    public void cometClose() {
        this.coyoteRequest.action(ActionCode.COMET_CLOSE, this.getEvent());
    }

    public void setCometTimeout(long timeout) {
        this.coyoteRequest.action(ActionCode.COMET_SETTIMEOUT, timeout);
    }

    public boolean isRequestedSessionIdFromSSL() {
        return this.requestedSessionSSL;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.authenticate.ise"));
        }
        LoginConfig config = this.context.getLoginConfig();
        if (config == null) {
            throw new ServletException(sm.getString("coyoteRequest.noLoginConfig"));
        }
        return this.context.getAuthenticator().authenticate(this, response, config);
    }

    public void login(String username, String password) throws ServletException {
        if (this.getAuthType() != null || this.getRemoteUser() != null || this.getUserPrincipal() != null) {
            throw new ServletException(sm.getString("coyoteRequest.alreadyAuthenticated"));
        }
        if (this.context.getAuthenticator() == null) {
            throw new ServletException("no authenticator");
        }
        this.context.getAuthenticator().login(username, password, this);
    }

    public void logout() throws ServletException {
        this.context.getAuthenticator().logout(this);
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        this.parseParts();
        if (this.partsParseException != null) {
            if (this.partsParseException instanceof IOException) {
                throw (IOException)this.partsParseException;
            }
            if (this.partsParseException instanceof IllegalStateException) {
                throw (IllegalStateException)this.partsParseException;
            }
            if (this.partsParseException instanceof ServletException) {
                throw (ServletException)this.partsParseException;
            }
        }
        return this.parts;
    }

    private void parseParts() {
        if (this.parts != null || this.partsParseException != null) {
            return;
        }
        MultipartConfigElement mce = this.getWrapper().getMultipartConfigElement();
        if (mce == null) {
            if (this.getContext().getAllowCasualMultipartParsing()) {
                mce = new MultipartConfigElement(null, (long)this.connector.getMaxPostSize(), (long)this.connector.getMaxPostSize(), this.connector.getMaxPostSize());
            } else {
                this.parts = Collections.emptyList();
                return;
            }
        }
        Parameters parameters = this.coyoteRequest.getParameters();
        String locationStr = mce.getLocation();
        File location = locationStr == null || locationStr.length() == 0 ? (File)this.context.getServletContext().getAttribute("javax.servlet.context.tempdir") : new File(locationStr);
        if (!location.isAbsolute() || !location.isDirectory()) {
            this.partsParseException = new IOException(sm.getString("coyoteRequest.uploadLocationInvalid", location));
            return;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        try {
            factory.setRepository(location.getCanonicalFile());
        }
        catch (IOException ioe) {
            this.partsParseException = ioe;
            return;
        }
        factory.setSizeThreshold(mce.getFileSizeThreshold());
        ServletFileUpload upload = new ServletFileUpload();
        upload.setFileItemFactory(factory);
        upload.setFileSizeMax(mce.getMaxFileSize());
        upload.setSizeMax(mce.getMaxRequestSize());
        this.parts = new ArrayList<Part>();
        try {
            List<FileItem> items = upload.parseRequest(this);
            for (FileItem item : items) {
                ApplicationPart part = new ApplicationPart(item, mce);
                this.parts.add(part);
                if (part.getFilename() != null) continue;
                try {
                    String encoding = parameters.getEncoding();
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                    }
                    parameters.addParameterValues(part.getName(), new String[]{part.getString(encoding)});
                }
                catch (UnsupportedEncodingException uee) {
                    try {
                        parameters.addParameterValues(part.getName(), new String[]{part.getString("ISO-8859-1")});
                    }
                    catch (UnsupportedEncodingException e) {}
                }
            }
        }
        catch (FileUploadBase.InvalidContentTypeException e) {
            this.partsParseException = new ServletException((Throwable)e);
        }
        catch (FileUploadBase.SizeException e) {
            this.checkSwallowInput();
            this.partsParseException = new IllegalStateException(e);
        }
        catch (FileUploadException e) {
            this.partsParseException = new IOException(e);
        }
    }

    public Part getPart(String name) throws IOException, IllegalStateException, ServletException {
        Collection<Part> c = this.getParts();
        for (Part part : c) {
            if (!name.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    protected Session doGetSession(boolean create) {
        if (this.context == null) {
            return null;
        }
        if (this.session != null && !this.session.isValid()) {
            this.session = null;
        }
        if (this.session != null) {
            return this.session;
        }
        Manager manager = null;
        if (this.context != null) {
            manager = this.context.getManager();
        }
        if (manager == null) {
            return null;
        }
        if (this.requestedSessionId != null) {
            try {
                this.session = manager.findSession(this.requestedSessionId);
            }
            catch (IOException e) {
                this.session = null;
            }
            if (this.session != null && !this.session.isValid()) {
                this.session = null;
            }
            if (this.session != null) {
                this.session.access();
                return this.session;
            }
        }
        if (!create) {
            return null;
        }
        if (this.context != null && this.response != null && this.context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE) && this.response.getResponse().isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteRequest.sessionCreateCommitted"));
        }
        this.session = "/".equals(this.context.getSessionCookiePath()) && this.isRequestedSessionIdFromCookie() || this.requestedSessionSSL ? manager.createSession(this.getRequestedSessionId()) : manager.createSession(null);
        if (this.session != null && this.getContext() != null && this.getContext().getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            Cookie cookie = ApplicationSessionCookieConfig.createSessionCookie(this.context, this.session.getIdInternal(), this.isSecure());
            this.response.addSessionCookieInternal(cookie);
        }
        if (this.session == null) {
            return null;
        }
        this.session.access();
        return this.session;
    }

    protected String unescape(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\') {
                buf.append(c);
                continue;
            }
            if (++i >= s.length()) {
                throw new IllegalArgumentException();
            }
            c = s.charAt(i);
            buf.append(c);
        }
        return buf.toString();
    }

    protected void parseCookies() {
        this.cookiesParsed = true;
        Cookies serverCookies = this.coyoteRequest.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        this.cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), null);
                int version = scookie.getVersion();
                cookie.setVersion(version);
                cookie.setValue(this.unescape(scookie.getValue().toString()));
                cookie.setPath(this.unescape(scookie.getPath().toString()));
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(this.unescape(domain));
                }
                String comment = scookie.getComment().toString();
                cookie.setComment(version == 1 ? this.unescape(comment) : null);
                this.cookies[idx++] = cookie;
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(this.cookies, 0, ncookies, 0, idx);
            this.cookies = ncookies;
        }
    }

    protected void parseParameters() {
        int semicolon;
        this.parametersParsed = true;
        Parameters parameters = this.coyoteRequest.getParameters();
        String enc = this.getCharacterEncoding();
        boolean useBodyEncodingForURI = this.connector.getUseBodyEncodingForURI();
        if (enc != null) {
            parameters.setEncoding(enc);
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding(enc);
            }
        } else {
            parameters.setEncoding("ISO-8859-1");
            if (useBodyEncodingForURI) {
                parameters.setQueryStringEncoding("ISO-8859-1");
            }
        }
        parameters.handleQueryParameters();
        if (this.usingInputStream || this.usingReader) {
            return;
        }
        if (!this.getConnector().isParseBodyMethod(this.getMethod())) {
            return;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if ("multipart/form-data".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            this.parseParts();
            return;
        }
        if (!"application/x-www-form-urlencoded".equals(contentType)) {
            return;
        }
        int len = this.getContentLength();
        if (len > 0) {
            int maxPostSize = this.connector.getMaxPostSize();
            if (maxPostSize > 0 && len > maxPostSize) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug(sm.getString("coyoteRequest.postTooLarge"));
                }
                this.checkSwallowInput();
                return;
            }
            byte[] formData = null;
            if (len < CACHED_POST_LEN) {
                if (this.postData == null) {
                    this.postData = new byte[CACHED_POST_LEN];
                }
                formData = this.postData;
            } else {
                formData = new byte[len];
            }
            try {
                if (this.readPostBody(formData, len) != len) {
                    return;
                }
            }
            catch (IOException e) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug(sm.getString("coyoteRequest.parseParameters"), e);
                }
                return;
            }
            parameters.processParameters(formData, 0, len);
        } else if ("chunked".equalsIgnoreCase(this.coyoteRequest.getHeader("transfer-encoding"))) {
            byte[] formData = null;
            try {
                formData = this.readChunkedPostBody();
            }
            catch (IOException e) {
                if (this.context.getLogger().isDebugEnabled()) {
                    this.context.getLogger().debug(sm.getString("coyoteRequest.parseParameters"), e);
                }
                return;
            }
            if (formData != null) {
                parameters.processParameters(formData, 0, formData.length);
            }
        }
    }

    protected int readPostBody(byte[] body, int len) throws IOException {
        int inputLen;
        int offset = 0;
        do {
            if ((inputLen = this.getStream().read(body, offset, len - offset)) > 0) continue;
            return offset;
        } while (len - (offset += inputLen) > 0);
        return len;
    }

    protected byte[] readChunkedPostBody() throws IOException {
        ByteChunk body = new ByteChunk();
        byte[] buffer = new byte[CACHED_POST_LEN];
        int len = 0;
        while (len > -1) {
            len = this.getStream().read(buffer, 0, CACHED_POST_LEN);
            if (this.connector.getMaxPostSize() > 0 && body.getLength() + len > this.connector.getMaxPostSize()) {
                this.checkSwallowInput();
                throw new IllegalArgumentException(sm.getString("coyoteRequest.chunkedPostTooLarge"));
            }
            if (len <= 0) continue;
            body.append(buffer, 0, len);
        }
        if (body.getLength() == 0) {
            return null;
        }
        if (body.getLength() < body.getBuffer().length) {
            int length = body.getLength();
            byte[] result = new byte[length];
            System.arraycopy(body.getBuffer(), 0, result, 0, length);
            return result;
        }
        return body.getBuffer();
    }

    protected void parseLocales() {
        this.localesParsed = true;
        Enumeration<String> values = this.getHeaders("accept-language");
        while (values.hasMoreElements()) {
            String value = values.nextElement();
            this.parseLocalesHeader(value);
        }
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            this.parser.setString(sb.toString());
        } else {
            this.parser.setString(value);
        }
        int length = this.parser.getLength();
        while ((start = this.parser.getIndex()) < length) {
            int end = this.parser.findChar(',');
            String entry = this.parser.extract(start, end).trim();
            this.parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    String strQuality = entry.substring(semi + 3);
                    quality = strQuality.length() <= 5 ? Double.parseDouble(strQuality) : 0.0;
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            if (!Request.isAlpha(language) || !Request.isAlpha(country) || !Request.isAlpha(variant)) continue;
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        for (ArrayList list : locales.values()) {
            for (Locale locale : list) {
                this.addLocale(locale);
            }
        }
    }

    protected static final boolean isAlpha(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    static {
        new StringCache.ByteEntry();
        new StringCache.CharEntry();
        GMT_ZONE = TimeZone.getTimeZone("GMT");
        sm = StringManager.getManager("org.apache.catalina.connector");
        defaultLocale = Locale.getDefault();
        CACHED_POST_LEN = 8192;
    }
}

