/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.controller.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@ThreadSafe
public final class CMIThreadFactory
implements ThreadFactory {
    private static final Log LOGGER = LogFactory.getLog(CMIThreadFactory.class);
    private final String managerName;
    private static final AtomicInteger COUNTER = new AtomicInteger();

    public CMIThreadFactory(String managerName) {
        this.managerName = managerName;
    }

    public Thread newThread(Runnable r) {
        return this.newThread(r, null);
    }

    public Thread newThread(Runnable r, final String name) {
        LOGGER.debug((Object)"Creating a new daemon...", new Object[0]);
        Thread thread = new Thread(r, this.managerName + "-" + COUNTER.incrementAndGet());
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error((Object)("UNCAUGHT in thread {0}" + (name == null ? "" : " for the " + name)), new Object[]{t.getName(), e});
            }
        });
        return thread;
    }
}

