/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.AnyAttribute;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.NestedParticle;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SchemaLocationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOSchemaGenerator {
    private Map namespaceToSchemaLocation;
    private SchemaLocationResolver schemaLocationResolver;
    private List allTypes;
    private Schema generatedSchema;
    private HelperContext aHelperContext;

    public SDOSchemaGenerator(HelperContext aContext) {
        this.aHelperContext = aContext;
    }

    public String generate(List types, SchemaLocationResolver aSchemaLocationResolver) {
        this.schemaLocationResolver = aSchemaLocationResolver;
        if (types == null || types.size() == 0) {
            throw new IllegalArgumentException("No Schema was generated from null or empty list of types.");
        }
        String uri = null;
        Type firstType = (Type)types.get(0);
        uri = firstType.getURI();
        this.allTypes = types;
        this.generateSchema(uri, types);
        SchemaModelProject p = new SchemaModelProject();
        Vector generatedNamespaces = this.generatedSchema.getNamespaceResolver().getNamespaces();
        XMLDescriptor desc = (XMLDescriptor)p.getDescriptor(Schema.class);
        for (int i = 0; i < generatedNamespaces.size(); ++i) {
            Namespace next = (Namespace)generatedNamespaces.get(i);
            desc.getNamespaceResolver().put(next.getPrefix(), next.getNamespaceURI());
            if (!next.getNamespaceURI().equals("commonj.sdo") && !next.getNamespaceURI().equals("commonj.sdo/xml") && !next.getNamespaceURI().equals("commonj.sdo/java") || this.importExists(this.generatedSchema.getImports(), next.getNamespaceURI())) continue;
            Import theImport = new Import();
            theImport.setNamespace(next.getNamespaceURI());
            String schemaLocation = "classpath:/xml/";
            if (next.getNamespaceURI().equals("commonj.sdo")) {
                schemaLocation = schemaLocation + "sdoModel.xsd";
            } else if (next.getNamespaceURI().equals("commonj.sdo/xml")) {
                schemaLocation = schemaLocation + "sdoXML.xsd";
            } else if (next.getNamespaceURI().equals("commonj.sdo/java")) {
                schemaLocation = schemaLocation + "sdoJava.xsd";
            }
            try {
                new URL(schemaLocation);
                theImport.setSchemaLocation(schemaLocation);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            this.generatedSchema.getImports().add(theImport);
        }
        XMLLogin login = new XMLLogin();
        login.setDatasourcePlatform(new DOMPlatform());
        p.setDatasourceLogin(login);
        XMLContext context = new XMLContext(p);
        XMLMarshaller marshaller = context.createMarshaller();
        StringWriter generatedSchemaWriter = new StringWriter();
        marshaller.marshal((Object)this.generatedSchema, generatedSchemaWriter);
        return generatedSchemaWriter.toString();
    }

    public String generate(List types, Map aNamespaceToSchemaLocation) {
        if (types == null || types.size() == 0) {
            throw new IllegalArgumentException("No Schema was generated from null or empty list of types.");
        }
        String uri = null;
        this.namespaceToSchemaLocation = aNamespaceToSchemaLocation;
        Type firstType = (Type)types.get(0);
        if (firstType == null) {
            throw new IllegalArgumentException("No Schema was generated from a list of types containing null elements");
        }
        uri = firstType.getURI();
        this.allTypes = types;
        this.generateSchema(uri, types);
        SchemaModelProject p = new SchemaModelProject();
        Vector namespaces = this.generatedSchema.getNamespaceResolver().getNamespaces();
        for (int i = 0; i < namespaces.size(); ++i) {
            Namespace next = (Namespace)namespaces.get(i);
            ((XMLDescriptor)p.getDescriptor(Schema.class)).getNamespaceResolver().put(next.getPrefix(), next.getNamespaceURI());
        }
        XMLLogin login = new XMLLogin();
        login.setDatasourcePlatform(new DOMPlatform());
        p.setDatasourceLogin(login);
        XMLContext context = new XMLContext(p);
        XMLMarshaller marshaller = context.createMarshaller();
        StringWriter generatedSchemaWriter = new StringWriter();
        marshaller.marshal((Object)this.generatedSchema, generatedSchemaWriter);
        return generatedSchemaWriter.toString();
    }

    private void generateSchema(String uri, List typesWithSameUri) {
        this.generatedSchema = new Schema();
        this.generatedSchema.setTargetNamespace(uri);
        this.generatedSchema.setDefaultNamespace(uri);
        this.generatedSchema.setAttributeFormDefault(false);
        this.generatedSchema.setElementFormDefault(true);
        String javaPackage = null;
        for (int i = 0; i < typesWithSameUri.size(); ++i) {
            Object generatedType;
            String fullName;
            SDOType nextType = (SDOType)typesWithSameUri.get(i);
            if (nextType.getBaseTypes() == null || nextType.getBaseTypes().size() > 1) {
                // empty if block
            }
            if (!nextType.isDataType() && (fullName = nextType.getInstanceClassName()) != null) {
                String nextPackage = null;
                int lastDot = fullName.lastIndexOf(46);
                if (lastDot != -1) {
                    nextPackage = fullName.substring(0, lastDot);
                }
                if (nextPackage != null) {
                    javaPackage = nextPackage;
                }
            }
            if (nextType.isDataType()) {
                generatedType = this.generateSimpleType(nextType);
                this.generatedSchema.addTopLevelSimpleTypes((SimpleType)generatedType);
                continue;
            }
            generatedType = this.generateComplexType(nextType);
            this.generatedSchema.addTopLevelComplexTypes((ComplexType)generatedType);
            Element element = this.buildElementForComplexType(this.generatedSchema, (ComplexType)generatedType);
            if (element == null) continue;
            this.generatedSchema.addTopLevelElement(element);
        }
        if (javaPackage != null) {
            this.getPrefixForURI("commonj.sdo/java");
            this.generatedSchema.getAttributesMap().put(SDOConstants.SDOJAVA_PACKAGE_QNAME, javaPackage);
        }
    }

    private SimpleType generateSimpleType(Type type) {
        Object value;
        QName qname;
        String sdoXmlPrefix;
        SDOType sdoType = (SDOType)type;
        SimpleType simpleType = new SimpleType();
        String xsdLocalName = sdoType.getXsdLocalName();
        if (xsdLocalName != null) {
            simpleType.setName(xsdLocalName);
        } else {
            simpleType.setName(sdoType.getName());
        }
        if (sdoType.getAppInfoElements() != null && sdoType.getAppInfoElements().size() > 0) {
            Annotation annotation = new Annotation();
            annotation.setAppInfo(sdoType.getAppInfoElements());
            simpleType.setAnnotation(annotation);
        }
        if (xsdLocalName != null && !xsdLocalName.equals(sdoType.getName())) {
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            QName qname2 = new QName("commonj.sdo/xml", "name", sdoXmlPrefix);
            simpleType.getAttributesMap().put(qname2, sdoType.getName());
        }
        if (sdoType.getAliasNames() != null && sdoType.getAliasNames().size() > 0) {
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            String aliasNamesString = this.buildAliasNameString(sdoType.getAliasNames());
            qname = new QName("commonj.sdo/xml", "aliasName", sdoXmlPrefix);
            simpleType.getAttributesMap().put(qname, aliasNamesString);
        }
        if ((value = sdoType.get(SDOConstants.JAVA_CLASS_PROPERTY)) != null && value instanceof String) {
            String sdoJavaPrefix = this.getPrefixForURI("commonj.sdo/java");
            qname = new QName("commonj.sdo/java", "instanceClass", sdoJavaPrefix);
            simpleType.getAttributesMap().put(qname, value);
        }
        SDOType baseType = null;
        if (sdoType.getBaseTypes() != null && sdoType.getBaseTypes().size() > 0 && (SDOType)sdoType.getBaseTypes().get(0) != null) {
            baseType = (SDOType)sdoType.getBaseTypes().get(0);
        }
        if (baseType != null) {
            Restriction restriction = new Restriction();
            this.addTypeToListIfNeeded(sdoType, baseType);
            QName schemaType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType(baseType);
            if (schemaType != null) {
                String prefix = this.getPrefixStringForURI(schemaType.getNamespaceURI());
                restriction.setBaseType(prefix + schemaType.getLocalPart());
            } else {
                String prefix = this.getPrefixStringForURI(baseType.getURI());
                restriction.setBaseType(prefix + baseType.getName());
            }
            simpleType.setRestriction(restriction);
        }
        return simpleType;
    }

    private ComplexType generateComplexType(Type type) {
        String sdoXmlPrefix;
        SDOType sdoType = (SDOType)type;
        ComplexType complexType = new ComplexType();
        String xsdLocalName = sdoType.getXsdLocalName();
        if (xsdLocalName != null) {
            complexType.setName(xsdLocalName);
        } else {
            complexType.setName(sdoType.getName());
        }
        if (xsdLocalName != null && !xsdLocalName.equals(sdoType.getName())) {
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            QName qname = new QName("commonj.sdo/xml", "name", sdoXmlPrefix);
            complexType.getAttributesMap().put(qname, sdoType.getName());
        }
        complexType.setAbstractValue(sdoType.isAbstract());
        if (sdoType.getAppInfoElements() != null && sdoType.getAppInfoElements().size() > 0) {
            Annotation annotation = new Annotation();
            annotation.setAppInfo(sdoType.getAppInfoElements());
            complexType.setAnnotation(annotation);
        }
        if (sdoType.getAliasNames() != null && sdoType.getAliasNames().size() > 0) {
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            String aliasNamesString = this.buildAliasNameString(sdoType.getAliasNames());
            QName qname = new QName("commonj.sdo/xml", "aliasName", sdoXmlPrefix);
            complexType.getAttributesMap().put(qname, aliasNamesString);
        }
        complexType.setMixed(sdoType.isSequenced());
        Type baseType = null;
        if (sdoType.getBaseTypes() != null && sdoType.getBaseTypes().size() > 0 && (Type)sdoType.getBaseTypes().get(0) != null) {
            baseType = (Type)sdoType.getBaseTypes().get(0);
        }
        if (baseType != null) {
            this.addTypeToListIfNeeded(sdoType, baseType);
            Extension extension = new Extension();
            QName schemaType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType(baseType);
            if (schemaType != null) {
                extension.setBaseType(this.getPrefixStringForURI(schemaType.getNamespaceURI()) + schemaType.getLocalPart());
            } else if (baseType.getURI() == null || baseType.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                extension.setBaseType(baseType.getName());
            } else {
                extension.setBaseType(this.getPrefixStringForURI(baseType.getURI()) + baseType.getName());
            }
            this.buildElementsAndAttributes(extension, sdoType);
            ComplexContent complexContent = new ComplexContent();
            complexContent.setExtension(extension);
            complexType.setComplexContent(complexContent);
            return complexType;
        }
        this.buildElementsAndAttributes(complexType, sdoType);
        return complexType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildElementsAndAttributes(Object owner, Type type) {
        List properties = ((SDOType)type).getDeclaredProperties();
        TypeDefParticle nestedParticle = null;
        if (properties == null || properties.size() == 0) {
            if (!type.isOpen()) return;
            nestedParticle = new Sequence();
        } else if (type.isSequenced()) {
            nestedParticle = new Choice();
            nestedParticle.setMaxOccurs("unbounded");
        } else {
            nestedParticle = new Sequence();
        }
        for (int i = 0; i < properties.size(); ++i) {
            Property nextProperty = (Property)properties.get(i);
            if (this.aHelperContext.getXSDHelper().isElement(nextProperty)) {
                Element elem = this.buildElement(nextProperty, (NestedParticle)((Object)nestedParticle));
                nestedParticle.addElement(elem);
                continue;
            }
            if (!this.aHelperContext.getXSDHelper().isAttribute(nextProperty)) continue;
            Attribute attr = this.buildAttribute(nextProperty);
            if (owner instanceof ComplexType) {
                ((ComplexType)owner).getOrderedAttributes().add(attr);
                continue;
            }
            if (!(owner instanceof Extension)) continue;
            ((Extension)owner).getOrderedAttributes().add(attr);
        }
        if (type.isOpen()) {
            Any any = new Any();
            any.setProcessContents("lax");
            any.setMaxOccurs("unbounded");
            nestedParticle.addAny(any);
            AnyAttribute anyAttribute = new AnyAttribute();
            anyAttribute.setProcessContents("lax");
            if (owner instanceof ComplexType) {
                ((ComplexType)owner).setAnyAttribute(anyAttribute);
            }
        }
        if (nestedParticle.isEmpty()) return;
        if (owner instanceof ComplexType) {
            ((ComplexType)owner).setTypeDefParticle(nestedParticle);
            return;
        } else {
            if (!(owner instanceof Extension)) return;
            ((Extension)owner).setTypeDefParticle(nestedParticle);
        }
    }

    private void addSimpleComponentAnnotations(SimpleComponent sc, Property property, boolean element) {
        Property xmlDataTypeProperty;
        Type dataType;
        QName qname;
        String sdoXmlPrefix;
        String xsdLocalName;
        QName qname2;
        String sdoXmlPrefix2;
        SDOProperty sdoProperty = (SDOProperty)property;
        if (sdoProperty.isReadOnly()) {
            sdoXmlPrefix2 = this.getPrefixForURI("commonj.sdo/xml");
            QName qname3 = new QName("commonj.sdo/xml", "readOnly", sdoXmlPrefix2);
            sc.getAttributesMap().put(qname3, "true");
        }
        if (sdoProperty.hasAliasNames()) {
            sdoXmlPrefix2 = this.getPrefixForURI("commonj.sdo/xml");
            String aliasNamesString = this.buildAliasNameString(sdoProperty.getAliasNames());
            qname2 = new QName("commonj.sdo/xml", "aliasName", sdoXmlPrefix2);
            sc.getAttributesMap().put(qname2, aliasNamesString);
        }
        if ((xsdLocalName = sdoProperty.getXsdLocalName()) != null && !xsdLocalName.equals(sdoProperty.getName())) {
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            qname2 = new QName("commonj.sdo/xml", "name", sdoXmlPrefix);
            sc.getAttributesMap().put(qname2, sdoProperty.getName());
        }
        if (element && !sdoProperty.isContainment() && !sdoProperty.getType().isDataType() || !element && !sdoProperty.getType().isDataType()) {
            String typePrefix;
            sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            String uri = sdoProperty.getType().getURI();
            String value = sdoProperty.getType().getName();
            if (uri != null && (typePrefix = this.getPrefixForURI(uri)) != null) {
                value = typePrefix + ":" + value;
            }
            qname = new QName("commonj.sdo/xml", "propertyType", sdoXmlPrefix);
            sc.getAttributesMap().put(qname, value);
        }
        if (sdoProperty.getOpposite() != null) {
            String value = sdoProperty.getOpposite().getName();
            String sdoXmlPrefix3 = this.getPrefixForURI("commonj.sdo/xml");
            QName qname4 = new QName("commonj.sdo/xml", "oppositeProperty", sdoXmlPrefix3);
            sc.getAttributesMap().put(qname4, value);
        }
        if ((dataType = (Type)sdoProperty.get(xmlDataTypeProperty = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType"))) == null) {
            dataType = this.getAutomaticDataTypeForType(sdoProperty.getType());
        }
        if (dataType != null && !this.shouldSuppressDataType(sdoProperty, dataType)) {
            String dataTypePrefix;
            String sdoXmlPrefix4 = this.getPrefixForURI("commonj.sdo/xml");
            qname = new QName("commonj.sdo/xml", "dataType", sdoXmlPrefix4);
            String dataTypeString = dataType.getName();
            if (dataType.getURI() != null && (dataTypePrefix = this.getPrefixForURI(dataType.getURI())) != null) {
                dataTypeString = dataTypePrefix + ":" + dataTypeString;
            }
            sc.getAttributesMap().put(qname, dataTypeString);
        }
        if (element) {
            QName qname5;
            String prefix;
            String mimeType = (String)sdoProperty.get(SDOConstants.MIME_TYPE_PROPERTY);
            if (mimeType != null) {
                prefix = this.getPrefixForURI("http://www.w3.org/2005/05/xmlmime");
                qname5 = new QName(SDOConstants.XML_MIME_TYPE_QNAME.getNamespaceURI(), SDOConstants.XML_MIME_TYPE_QNAME.getLocalPart(), prefix);
                sc.getAttributesMap().put(qname5, mimeType);
            } else {
                mimeType = (String)sdoProperty.get(SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
                if (mimeType != null) {
                    prefix = this.getPrefixForURI("org.eclipse.persistence.sdo");
                    qname5 = new QName(SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME.getNamespaceURI(), SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME.getLocalPart(), prefix);
                    sc.getAttributesMap().put(qname5, mimeType);
                }
            }
        }
    }

    private boolean shouldSuppressDataType(SDOProperty prop, Type dataType) {
        if (prop.isNullable()) {
            SDOType type = prop.getType();
            if (dataType == SDOConstants.SDO_BOOLEANOBJECT && (type == SDOConstants.SDO_BOOLEAN || type == SDOConstants.SDO_BOOLEANOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_BYTEOBJECT && (type == SDOConstants.SDO_BYTE || type == SDOConstants.SDO_BYTEOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_CHARACTEROBJECT && (type == SDOConstants.SDO_CHARACTER || type == SDOConstants.SDO_CHARACTEROBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_DOUBLEOBJECT && (type == SDOConstants.SDO_DOUBLE || type == SDOConstants.SDO_DOUBLEOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_FLOATOBJECT && (type == SDOConstants.SDO_FLOAT || type == SDOConstants.SDO_FLOATOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_INTOBJECT && (type == SDOConstants.SDO_INT || type == SDOConstants.SDO_INTOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_LONGOBJECT && (type == SDOConstants.SDO_LONG || type == SDOConstants.SDO_LONGOBJECT)) {
                return true;
            }
            if (dataType == SDOConstants.SDO_SHORTOBJECT && (type == SDOConstants.SDO_SHORT || type == SDOConstants.SDO_SHORTOBJECT)) {
                return true;
            }
        }
        return false;
    }

    private String buildAliasNameString(List<String> aliasNames) {
        StringBuilder aliasNamesStringBuilder = new StringBuilder();
        int size = aliasNames.size();
        for (int i = 0; i < size; ++i) {
            aliasNamesStringBuilder.append(aliasNames.get(i));
            if (i >= size - 1) continue;
            aliasNamesStringBuilder.append(' ');
        }
        return aliasNamesStringBuilder.toString();
    }

    private Element buildElement(Property property, NestedParticle nestedParticle) {
        SDOType propertyType;
        SDOProperty sdoProperty = (SDOProperty)property;
        Element elem = new Element();
        String xsdLocalName = sdoProperty.getXsdLocalName();
        if (xsdLocalName != null) {
            elem.setName(xsdLocalName);
        } else {
            elem.setName(sdoProperty.getName());
        }
        elem.setMinOccurs("0");
        elem.setNillable(sdoProperty.isNullable());
        if (sdoProperty.getAppInfoElements() != null && sdoProperty.getAppInfoElements().size() > 0) {
            Annotation annotation = new Annotation();
            annotation.setAppInfo(sdoProperty.getAppInfoElements());
            elem.setAnnotation(annotation);
        }
        if (sdoProperty.isDefaultSet() && !sdoProperty.isMany() && sdoProperty.getType().isDataType()) {
            XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            elem.setDefaultValue((String)xmlConversionManager.convertObject(sdoProperty.getDefault(), ClassConstants.STRING, sdoProperty.getXsdType()));
        }
        this.addSimpleComponentAnnotations(elem, sdoProperty, true);
        Type schemaSDOType = null;
        QName schemaType = sdoProperty.getXsdType();
        if (schemaType != null) {
            schemaSDOType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(schemaType.getNamespaceURI(), schemaType.getLocalPart());
            if (sdoProperty.getType() == SDOConstants.SDO_STRING && schemaSDOType != SDOConstants.SDO_STRING) {
                String sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
                QName qname = new QName("commonj.sdo/xml", "string", sdoXmlPrefix);
                elem.getAttributesMap().put(qname, "true");
            }
        }
        if (!sdoProperty.isContainment() && !sdoProperty.getType().isDataType()) {
            schemaType = SDOConstants.ANY_URI_QNAME;
        }
        if ((propertyType = sdoProperty.getType()) != null) {
            if (sdoProperty.getContainingType() != null) {
                this.addTypeToListIfNeeded(sdoProperty.getContainingType(), propertyType);
            }
            if (schemaType == null) {
                schemaType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType(propertyType);
            }
            if (schemaType != null) {
                elem.setType(this.getPrefixStringForURI(schemaType.getNamespaceURI()) + schemaType.getLocalPart());
                if (schemaSDOType != null) {
                    this.addTypeToListIfNeeded(sdoProperty.getContainingType(), schemaSDOType);
                }
            } else if (propertyType.getURI() == null || propertyType.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                String xsdTypeLocalName = propertyType.getXsdLocalName();
                if (xsdTypeLocalName != null) {
                    elem.setType(xsdTypeLocalName);
                } else {
                    elem.setType(propertyType.getName());
                }
            } else {
                String nameString = null;
                String xsdTypeLocalName = propertyType.getXsdLocalName();
                nameString = xsdTypeLocalName != null ? xsdTypeLocalName : propertyType.getName();
                elem.setType(this.getPrefixStringForURI(propertyType.getURI()) + nameString);
            }
        } else {
            elem.setType("anyURI");
        }
        if (sdoProperty.isMany()) {
            elem.setMaxOccurs("unbounded");
        } else if (nestedParticle.getMaxOccurs() == "unbounded") {
            String sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
            QName qname = new QName("commonj.sdo/xml", "many", sdoXmlPrefix);
            elem.getAttributesMap().put(qname, "false");
        }
        return elem;
    }

    private Attribute buildAttribute(Property property) {
        Attribute attr = new Attribute();
        String xsdLocalName = ((SDOProperty)property).getXsdLocalName();
        if (xsdLocalName != null) {
            attr.setName(xsdLocalName);
        } else {
            attr.setName(property.getName());
        }
        if (((SDOProperty)property).getAppInfoElements() != null && ((SDOProperty)property).getAppInfoElements().size() > 0) {
            Annotation annotation = new Annotation();
            annotation.setAppInfo(((SDOProperty)property).getAppInfoElements());
            attr.setAnnotation(annotation);
        }
        if (((SDOProperty)property).isDefaultSet() && !property.isMany() && ((SDOType)property.getType()).isDataType()) {
            XMLConversionManager xmlConversionManager = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            attr.setDefaultValue((String)xmlConversionManager.convertObject(property.getDefault(), ClassConstants.STRING, ((SDOProperty)property).getXsdType()));
        }
        this.addSimpleComponentAnnotations(attr, property, false);
        Type propertyType = property.getType();
        QName schemaType = ((SDOProperty)property).getXsdType();
        if (schemaType != null) {
            Type schemaSDOType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(schemaType.getNamespaceURI(), schemaType.getLocalPart());
            if (property.getType() == SDOConstants.SDO_STRING && schemaSDOType != SDOConstants.SDO_STRING) {
                String sdoXmlPrefix = this.getPrefixForURI("commonj.sdo/xml");
                QName qname = new QName("commonj.sdo/xml", "string", sdoXmlPrefix);
                attr.getAttributesMap().put(qname, "true");
            }
        }
        if (!((SDOType)property.getType()).isDataType()) {
            schemaType = SDOConstants.ANY_URI_QNAME;
        }
        if (propertyType != null) {
            if (property.getContainingType() != null) {
                this.addTypeToListIfNeeded(property.getContainingType(), propertyType);
            }
            if (schemaType == null) {
                schemaType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType(propertyType);
            }
            if (schemaType != null) {
                attr.setType(this.getPrefixStringForURI(schemaType.getNamespaceURI()) + schemaType.getLocalPart());
            } else if (propertyType.getURI() == null || propertyType.getURI().equalsIgnoreCase(this.generatedSchema.getTargetNamespace())) {
                String xsdTypeLocalName = ((SDOType)propertyType).getXsdLocalName();
                if (xsdTypeLocalName != null) {
                    attr.setType(xsdTypeLocalName);
                } else {
                    attr.setType(propertyType.getName());
                }
            } else {
                String nameString = null;
                String xsdTypeLocalName = ((SDOType)propertyType).getXsdLocalName();
                nameString = xsdTypeLocalName != null ? xsdTypeLocalName : propertyType.getName();
                attr.setType(this.getPrefixStringForURI(propertyType.getURI()) + nameString);
            }
        }
        return attr;
    }

    private void addTypeToListIfNeeded(Type sourceType, Type targetType) {
        if (!(targetType.getURI() == null || targetType.getURI().equals("commonj.sdo") || targetType.getURI().equals("commonj.sdo/java") || targetType.getURI().equals("commonj.sdo/xml"))) {
            boolean alreadyGenerated = this.allTypes.contains(targetType);
            String schemaLocation = null;
            if (this.namespaceToSchemaLocation != null) {
                schemaLocation = (String)this.namespaceToSchemaLocation.get(targetType.getURI());
                if (targetType.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                    if (!alreadyGenerated) {
                        this.allTypes.add(targetType);
                    }
                } else if (!this.importExists(this.generatedSchema.getImports(), schemaLocation)) {
                    Import theImport = new Import();
                    theImport.setSchemaLocation(schemaLocation);
                    theImport.setNamespace(targetType.getURI());
                    this.generatedSchema.getImports().add(theImport);
                }
            } else if (this.schemaLocationResolver != null) {
                schemaLocation = this.schemaLocationResolver.resolveSchemaLocation(sourceType, targetType);
                if (schemaLocation != null) {
                    if (targetType.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                        if (!this.importExists(this.generatedSchema.getIncludes(), schemaLocation)) {
                            Include include = new Include();
                            include.setSchemaLocation(schemaLocation);
                            this.generatedSchema.getIncludes().add(include);
                            this.allTypes.remove(targetType);
                        }
                    } else if (!this.importExists(this.generatedSchema.getImports(), schemaLocation)) {
                        Import theImport = new Import();
                        theImport.setSchemaLocation(schemaLocation);
                        theImport.setNamespace(targetType.getURI());
                        this.generatedSchema.getImports().add(theImport);
                    }
                } else if (!alreadyGenerated && targetType.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                    this.allTypes.add(targetType);
                }
            } else if (!alreadyGenerated && targetType.getURI().equals(this.generatedSchema.getTargetNamespace())) {
                this.allTypes.add(targetType);
            }
        }
    }

    private Element buildElementForComplexType(Schema schema, ComplexType type) {
        Element elem = new Element();
        String name = type.getName();
        if (name == null) {
            return null;
        }
        String lowerName = Character.toLowerCase(name.charAt(0)) + name.substring(1, name.length());
        Object exists = schema.getTopLevelElements().get(lowerName);
        if (exists != null) {
            elem.setName(name);
        } else {
            elem.setName(lowerName);
        }
        elem.setType(type.getName());
        return elem;
    }

    private String getPrefixStringForURI(String uri) {
        if (null == uri || "".equals(uri)) {
            return "";
        }
        String prefix = this.getPrefixForURI(uri);
        if (prefix == null) {
            return "";
        }
        return prefix + ":";
    }

    private String getPrefixForURI(String uri) {
        String prefix = null;
        if (uri.equals(this.generatedSchema.getTargetNamespace())) {
            return null;
        }
        if (uri.equals("http://www.w3.org/2001/XMLSchema")) {
            return "xsd";
        }
        if (uri.equals("commonj.sdo")) {
            prefix = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(uri);
            if (prefix == null) {
                prefix = this.generatedSchema.getNamespaceResolver().generatePrefix("sdo");
                this.generatedSchema.getNamespaceResolver().put(prefix, uri);
            }
        } else if (uri.equals("commonj.sdo/java")) {
            prefix = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(uri);
            if (prefix == null) {
                prefix = this.generatedSchema.getNamespaceResolver().generatePrefix("sdoJava");
                this.generatedSchema.getNamespaceResolver().put(prefix, uri);
            }
        } else if (uri.equals("commonj.sdo/xml") && (prefix = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(uri)) == null) {
            prefix = this.generatedSchema.getNamespaceResolver().generatePrefix("sdoXML");
            this.generatedSchema.getNamespaceResolver().put(prefix, uri);
        }
        if (prefix == null) {
            prefix = this.generatedSchema.getNamespaceResolver().resolveNamespaceURI(uri);
        }
        if (prefix != null) {
            return prefix;
        }
        String generatedPrefix = this.generatedSchema.getNamespaceResolver().generatePrefix();
        this.generatedSchema.getNamespaceResolver().put(generatedPrefix, uri);
        return generatedPrefix;
    }

    private Type getAutomaticDataTypeForType(Type theType) {
        if (theType == SDOConstants.SDO_BOOLEANOBJECT) {
            return SDOConstants.SDO_BOOLEANOBJECT;
        }
        if (theType == SDOConstants.SDO_BYTEOBJECT) {
            return SDOConstants.SDO_BYTEOBJECT;
        }
        if (theType == SDOConstants.SDO_CHARACTEROBJECT) {
            return SDOConstants.SDO_CHARACTEROBJECT;
        }
        if (theType == SDOConstants.SDO_DOUBLEOBJECT) {
            return SDOConstants.SDO_DOUBLEOBJECT;
        }
        if (theType == SDOConstants.SDO_INTOBJECT) {
            return SDOConstants.SDO_INTOBJECT;
        }
        if (theType == SDOConstants.SDO_FLOATOBJECT) {
            return SDOConstants.SDO_FLOATOBJECT;
        }
        if (theType == SDOConstants.SDO_LONGOBJECT) {
            return SDOConstants.SDO_LONGOBJECT;
        }
        if (theType == SDOConstants.SDO_SHORTOBJECT) {
            return SDOConstants.SDO_SHORTOBJECT;
        }
        if (theType == SDOConstants.SDO_DATE) {
            return SDOConstants.SDO_DATE;
        }
        if (theType == SDOConstants.SDO_DATETIME) {
            return SDOConstants.SDO_DATETIME;
        }
        return null;
    }

    private boolean importExists(List imports, String schemaName) {
        for (int i = 0; i < imports.size(); ++i) {
            Include nextImport = (Include)imports.get(i);
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }
}

