/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.transport.nio.NioSender;
import org.apache.catalina.tribes.util.Logs;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ParallelNioSender
extends AbstractSender
implements MultiPointSender {
    private static final Log log = LogFactory.getLog(ParallelNioSender.class);
    protected long selectTimeout = 5000L;
    protected Selector selector;
    protected HashMap<Member, NioSender> nioSenders = new HashMap();

    public ParallelNioSender() throws IOException {
        this.selector = Selector.open();
        this.setConnected(true);
    }

    @Override
    public synchronized void sendMessage(Member[] destination, ChannelMessage msg) throws ChannelException {
        long start = System.currentTimeMillis();
        this.setUdpBased((msg.getOptions() & 0x20) == 32);
        byte[] data = XByteBuffer.createDataPackage((ChannelData)msg);
        NioSender[] senders = this.setupForSend(destination);
        this.connect(senders);
        this.setData(senders, data);
        int remaining = senders.length;
        ChannelException cx = null;
        try {
            boolean waitForAck;
            long delta = System.currentTimeMillis() - start;
            boolean bl = waitForAck = (2 & msg.getOptions()) == 2;
            while (remaining > 0 && delta < this.getTimeout()) {
                block17: {
                    try {
                        remaining -= this.doLoop(this.selectTimeout, this.getMaxRetryAttempts(), waitForAck, msg);
                    }
                    catch (Exception x) {
                        int faulty;
                        if (log.isTraceEnabled()) {
                            log.trace("Error sending message", x);
                        }
                        int n = faulty = cx == null ? 0 : cx.getFaultyMembers().length;
                        if (cx == null) {
                            cx = x instanceof ChannelException ? (ChannelException)x : new ChannelException("Parallel NIO send failed.", x);
                        } else if (x instanceof ChannelException) {
                            cx.addFaultyMember(((ChannelException)x).getFaultyMembers());
                        }
                        if (faulty >= cx.getFaultyMembers().length) break block17;
                        remaining -= cx.getFaultyMembers().length - faulty;
                    }
                }
                if (cx != null && cx.getFaultyMembers().length == remaining) {
                    throw cx;
                }
                delta = System.currentTimeMillis() - start;
            }
            if (remaining > 0) {
                ChannelException cxtimeout = new ChannelException("Operation has timed out(" + this.getTimeout() + " ms.).");
                if (cx == null) {
                    cx = new ChannelException("Operation has timed out(" + this.getTimeout() + " ms.).");
                }
                for (int i = 0; i < senders.length; ++i) {
                    if (senders[i].isComplete()) continue;
                    cx.addFaultyMember(senders[i].getDestination(), cxtimeout);
                }
                throw cx;
            }
            if (cx != null) {
                throw cx;
            }
        }
        catch (Exception x) {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (x instanceof ChannelException) {
                throw (ChannelException)x;
            }
            throw new ChannelException(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doLoop(long selectTimeOut, int maxAttempts, boolean waitForAck, ChannelMessage msg) throws IOException, ChannelException {
        int completed = 0;
        int selectedKeys = this.selector.select(selectTimeOut);
        if (selectedKeys == 0) {
            return 0;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey sk = it.next();
            it.remove();
            int readyOps = sk.readyOps();
            sk.interestOps(sk.interestOps() & ~readyOps);
            NioSender sender = (NioSender)sk.attachment();
            try {
                if (!sender.process(sk, waitForAck)) continue;
                ++completed;
                sender.setComplete(true);
                if (Logs.MESSAGES.isTraceEnabled()) {
                    Logs.MESSAGES.trace("ParallelNioSender - Sent msg:" + new UniqueId(msg.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + sender.getDestination().getName());
                }
                SenderState.getSenderState(sender.getDestination()).setReady();
            }
            catch (Exception x) {
                if (log.isTraceEnabled()) {
                    log.trace("Error while processing send to " + sender.getDestination().getName(), x);
                }
                SenderState state = SenderState.getSenderState(sender.getDestination());
                int attempt = sender.getAttempt() + 1;
                boolean retry = sender.getAttempt() <= maxAttempts && maxAttempts > 0;
                SenderState senderState = state;
                synchronized (senderState) {
                    if (state.isSuspect()) {
                        state.setFailing();
                    }
                    if (state.isReady()) {
                        state.setSuspect();
                        if (retry) {
                            log.warn("Member send is failing for:" + sender.getDestination().getName() + " ; Setting to suspect and retrying.");
                        } else {
                            log.warn("Member send is failing for:" + sender.getDestination().getName() + " ; Setting to suspect.", x);
                        }
                    }
                }
                if (!this.isConnected()) {
                    log.warn("Not retrying send for:" + sender.getDestination().getName() + "; Sender is disconnected.");
                    ChannelException cx = new ChannelException("Send failed, and sender is disconnected. Not retrying.", x);
                    cx.addFaultyMember(sender.getDestination(), x);
                    throw cx;
                }
                byte[] data = sender.getMessage();
                if (retry) {
                    try {
                        sender.disconnect();
                        sender.connect();
                        sender.setAttempt(attempt);
                        sender.setMessage(data);
                    }
                    catch (Exception ignore) {
                        state.setFailing();
                    }
                    continue;
                }
                ChannelException cx = new ChannelException("Send failed, attempt:" + sender.getAttempt() + " max:" + maxAttempts, x);
                cx.addFaultyMember(sender.getDestination(), x);
                throw cx;
            }
        }
        return completed;
    }

    private void connect(NioSender[] senders) throws ChannelException {
        ChannelException x = null;
        for (int i = 0; i < senders.length; ++i) {
            try {
                senders[i].connect();
                continue;
            }
            catch (IOException io) {
                if (x == null) {
                    x = new ChannelException(io);
                }
                x.addFaultyMember(senders[i].getDestination(), io);
            }
        }
        if (x != null) {
            throw x;
        }
    }

    private void setData(NioSender[] senders, byte[] data) throws ChannelException {
        ChannelException x = null;
        for (int i = 0; i < senders.length; ++i) {
            try {
                senders[i].setMessage(data);
                continue;
            }
            catch (IOException io) {
                if (x == null) {
                    x = new ChannelException(io);
                }
                x.addFaultyMember(senders[i].getDestination(), io);
            }
        }
        if (x != null) {
            throw x;
        }
    }

    private NioSender[] setupForSend(Member[] destination) throws ChannelException {
        ChannelException cx = null;
        NioSender[] result = new NioSender[destination.length];
        for (int i = 0; i < destination.length; ++i) {
            NioSender sender = this.nioSenders.get(destination[i]);
            try {
                if (sender == null) {
                    sender = new NioSender();
                    AbstractSender.transferProperties(this, sender);
                    this.nioSenders.put(destination[i], sender);
                }
                sender.reset();
                sender.setDestination(destination[i]);
                sender.setSelector(this.selector);
                sender.setUdpBased(this.isUdpBased());
                result[i] = sender;
                continue;
            }
            catch (UnknownHostException x) {
                if (cx == null) {
                    cx = new ChannelException("Unable to setup NioSender.", x);
                }
                cx.addFaultyMember(destination[i], x);
            }
        }
        if (cx != null) {
            throw cx;
        }
        return result;
    }

    @Override
    public void connect() {
        this.setConnected(true);
    }

    private synchronized void close() throws ChannelException {
        ChannelException x = null;
        Object[] members = this.nioSenders.keySet().toArray();
        for (int i = 0; i < members.length; ++i) {
            Member mbr = (Member)members[i];
            try {
                NioSender sender = this.nioSenders.get(mbr);
                sender.disconnect();
            }
            catch (Exception e) {
                if (x == null) {
                    x = new ChannelException(e);
                }
                x.addFaultyMember(mbr, e);
            }
            this.nioSenders.remove(mbr);
        }
        if (x != null) {
            throw x;
        }
    }

    @Override
    public void add(Member member) {
    }

    @Override
    public void remove(Member member) {
        NioSender sender = this.nioSenders.remove(member);
        if (sender != null) {
            sender.disconnect();
        }
    }

    @Override
    public synchronized void disconnect() {
        this.setConnected(false);
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        block4: {
            try {
                this.disconnect();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Failed to close selector", e);
            }
        }
    }

    @Override
    public boolean keepalive() {
        boolean result = false;
        Iterator<Map.Entry<Member, NioSender>> i = this.nioSenders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Member, NioSender> entry = i.next();
            NioSender sender = entry.getValue();
            if (sender.keepalive()) {
                i.remove();
                result = true;
                continue;
            }
            try {
                sender.read(null);
            }
            catch (IOException x) {
                sender.disconnect();
                sender.reset();
                i.remove();
                result = true;
            }
            catch (Exception x) {
                log.warn("Error during keepalive test for sender:" + sender, x);
            }
        }
        if (result) {
            try {
                this.selector.selectNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

